/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddingIndexerFactoryImpl
extends EmbeddingIndexerFactory {
    private static final Logger LOG = Logger.getLogger(EmbeddingIndexerFactoryImpl.class.getName());
    private static final EmbeddingIndexerFactory VOID_INDEXER_FACTORY = new EmbeddingIndexerFactory(){
        private final EmbeddingIndexer voidIndexer = new EmbeddingIndexer(){

            protected void index(Indexable indexable, Parser.Result result, Context context) {
            }
        };

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            return this.voidIndexer;
        }

        public String getIndexerName() {
            return "void-indexer";
        }

        public int getIndexVersion() {
            return 0;
        }

        public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
        }

        public void filesDirty(Collection<? extends Indexable> collection, Context context) {
        }
    };
    private final String mimeType;
    private EmbeddingIndexerFactory realFactory;

    public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
        return this.getFactory().createIndexer(indexable, snapshot);
    }

    public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
        this.getFactory().filesDeleted(collection, context);
    }

    public void filesDirty(Collection<? extends Indexable> collection, Context context) {
        this.getFactory().filesDirty(collection, context);
    }

    public String getIndexerName() {
        return this.getFactory().getIndexerName();
    }

    public int getIndexVersion() {
        return this.getFactory().getIndexVersion();
    }

    public static EmbeddingIndexerFactory create(FileObject fileObject) {
        String string = fileObject.getParent().getPath().substring("Editors/".length());
        return new EmbeddingIndexerFactoryImpl(string);
    }

    private EmbeddingIndexerFactoryImpl(String string) {
        this.mimeType = string;
    }

    private EmbeddingIndexerFactory getFactory() {
        if (this.realFactory == null) {
            EmbeddingIndexerFactory embeddingIndexerFactory;
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(this.mimeType);
            if (language != null && (embeddingIndexerFactory = language.getIndexerFactory()) != null) {
                this.realFactory = embeddingIndexerFactory;
            }
            if (this.realFactory == null) {
                this.realFactory = VOID_INDEXER_FACTORY;
            }
            LOG.fine("EmbeddingIndexerFactory for '" + this.mimeType + "': " + this.realFactory);
        }
        return this.realFactory;
    }
}

