/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.wizards.AddDomainLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddDomainLocationPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddDomainLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String gfRoot;
    private AtomicBoolean isValidating = new AtomicBoolean();

    public AddDomainLocationPanel(ServerWizardIterator serverWizardIterator) {
        this.wizardIterator = serverWizardIterator;
        this.wizard = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                AddDomainLocationVisualPanel addDomainLocationVisualPanel = (AddDomainLocationVisualPanel)this.getComponent();
                String string = addDomainLocationVisualPanel.getDomainField().trim();
                File file = new File(this.gfRoot, "domains" + File.separator + string);
                if (string.length() < 1) {
                    if (!file.canWrite()) {
                        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_EnterDomainDirectory"));
                    } else {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_MustHaveName"));
                    }
                    boolean bl = false;
                    return bl;
                }
                int n = string.indexOf(File.separator);
                if (AddServerLocationPanel.isRegisterableDomain(file)) {
                    AddServerLocationPanel.readServerConfiguration(file, this.wizardIterator);
                    String string2 = this.wizardIterator.formatUri(this.gfRoot, "localhost", this.wizardIterator.getHttpPort());
                    if (this.wizardIterator.hasServer(string2)) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_DomainAlreadyRegistered", (Object)string));
                        boolean bl = false;
                        return bl;
                    }
                    this.wizardIterator.setDomainLocation(file.getAbsolutePath());
                    this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExistingEmbedded", (Object)string));
                    boolean bl = true;
                    return bl;
                }
                File file2 = file.getParentFile();
                if (file2.canWrite() && n < 0 && !ServerUtilities.isTP2(this.gfRoot)) {
                    this.wizardIterator.setDomainLocation(file.getAbsolutePath());
                    this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_CreateEmbedded", (Object)string));
                    boolean bl = true;
                    return bl;
                }
                file = new File(string);
                String string3 = file.getAbsolutePath();
                if (AddServerLocationPanel.isRegisterableDomain(file)) {
                    this.wizardIterator.setDomainLocation(string3);
                    this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExisting", (Object)string));
                    AddServerLocationPanel.readServerConfiguration(file, this.wizardIterator);
                    boolean bl = true;
                    return bl;
                }
                if (AddServerLocationPanel.canCreate(file) && !ServerUtilities.isTP2(this.gfRoot)) {
                    this.wizardIterator.setDomainLocation(string3);
                    this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"MSG_CreateDomain", (Object)string));
                    boolean bl = true;
                    return bl;
                }
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDomain", (Object)string));
                boolean bl = false;
                return bl;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent(changeEvent);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddDomainLocationVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("registering_app_server_hk2_domain");
    }

    public void readSettings(Object object) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)object;
        }
        this.gfRoot = this.wizardIterator.getGlassfishRoot();
        ((AddDomainLocationVisualPanel)this.getComponent()).initModels(this.gfRoot);
    }

    public void storeSettings(Object object) {
    }
}

