/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.nodes.DecoratorManager;
import org.netbeans.modules.glassfish.common.nodes.Hk2ApplicationNode;
import org.netbeans.modules.glassfish.common.nodes.Hk2ItemNode;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.Decorator;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2ApplicationsChildren
extends Children.Keys<Object>
implements Refreshable {
    private Lookup lookup;
    private static final Node WAIT_NODE = Hk2ItemNode.createWaitNode();

    Hk2ApplicationsChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{WAIT_NODE});
        RequestProcessor.getDefault().post(new Runnable(){
            Vector<Object> keys = new Vector();

            public void run() {
                GlassfishModule glassfishModule = (GlassfishModule)Hk2ApplicationsChildren.this.lookup.lookup(GlassfishModule.class);
                if (glassfishModule != null) {
                    try {
                        Map<String, String> map = glassfishModule.getInstanceProperties();
                        CommandRunner commandRunner = new CommandRunner(map, new OperationStateListener[0]);
                        Map<String, List<AppDesc>> map2 = commandRunner.getApplications(null);
                        for (Map.Entry<String, List<AppDesc>> entry : map2.entrySet()) {
                            List<AppDesc> list = entry.getValue();
                            Decorator decorator = DecoratorManager.findDecorator(entry.getKey(), Hk2ItemNode.J2EE_APPLICATION);
                            for (AppDesc appDesc : list) {
                                this.keys.add((Object)new Hk2ApplicationNode(Hk2ApplicationsChildren.this.lookup, appDesc, decorator));
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
                    }
                    Hk2ApplicationsChildren.this.setKeys(this.keys);
                }
            }
        }, 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof Hk2ItemNode) {
            return new Node[]{(Hk2ItemNode)((Object)object)};
        }
        if (object instanceof String && object.equals(WAIT_NODE)) {
            return new Node[]{WAIT_NODE};
        }
        return null;
    }
}

