/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.openide.util.NbBundle;

public class Commands {
    public static final ServerCommand START = new ServerCommand("start-domain"){};
    public static final ServerCommand STOP = new ServerCommand("stop-domain"){};

    private static void addKeepSessions(StringBuilder stringBuilder, Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            stringBuilder.append("&properties=");
            stringBuilder.append("keepSessions=true");
        }
    }

    public static final class LocationCommand
    extends ServerCommand {
        private Manifest info;
        private String installRoot;
        private String domainRoot;

        public LocationCommand() {
            super("__locations");
        }

        public String getInstallRoot() {
            return this.installRoot;
        }

        public String getDomainRoot() {
            return this.domainRoot;
        }

        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        public boolean processResponse() {
            if (this.info == null) {
                return false;
            }
            Attributes attributes = this.info.getMainAttributes();
            if (attributes != null) {
                this.installRoot = attributes.getValue("Base-Root_value");
                this.domainRoot = attributes.getValue("Domain-Root_value");
            }
            return true;
        }
    }

    public static final class VersionCommand
    extends ServerCommand {
        private Manifest info;

        public VersionCommand() {
            super("version");
        }

        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        public boolean processResponse() {
            return true;
        }
    }

    public static final class UnregisterCommand
    extends ServerCommand {
        public UnregisterCommand(String string, String string2, String string3, boolean bl) {
            super("delete-" + string2);
            StringBuilder stringBuilder = new StringBuilder(128);
            if (bl) {
                stringBuilder.append("cascade=true");
                stringBuilder.append('&');
            }
            stringBuilder.append(string3);
            stringBuilder.append('=');
            stringBuilder.append(string);
            this.query = stringBuilder.toString();
        }
    }

    public static final class UndeployCommand
    extends ServerCommand {
        public UndeployCommand(String string) {
            super("undeploy");
            this.query = "name=" + string;
        }
    }

    public static final class RedeployCommand
    extends ServerCommand {
        public RedeployCommand(String string, String string2, Boolean bl) {
            super("redeploy");
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("name=");
            stringBuilder.append(string);
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append("&contextroot=");
                stringBuilder.append(string2);
            }
            Commands.addKeepSessions(stringBuilder, bl);
            this.query = stringBuilder.toString();
        }
    }

    public static final class DeployCommand
    extends ServerCommand {
        private String path = null;
        private String fileName = null;

        public DeployCommand(File file, String string, String string2, Boolean bl) {
            super("deploy");
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("path=");
            String string3 = file.getAbsolutePath();
            stringBuilder.append(string3);
            this.fileName = string3;
            if (string != null && string.length() > 0) {
                stringBuilder.append("&name=");
                stringBuilder.append(string);
            }
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append("&contextroot=");
                stringBuilder.append(string2);
            }
            stringBuilder.append("&force=true");
            this.query = stringBuilder.toString();
        }

        public String getContentType() {
            return null == this.path ? null : "application/zip";
        }

        public boolean getDoOutput() {
            return this.path != null;
        }

        public InputStream getInputStream() {
            try {
                return null != this.path ? new FileInputStream(this.path) : null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        public String getRequestMethod() {
            return null == this.path ? super.getRequestMethod() : "POST";
        }

        public String getInputName() {
            return this.fileName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListResourcesCommand
    extends ServerCommand {
        private final String cmdSuffix;
        private Manifest list;
        private List<ResourceDesc> resList;

        public ListResourcesCommand(String string) {
            super("list-" + string + "s");
            this.cmdSuffix = string;
        }

        public List<ResourceDesc> getResourceList() {
            if (this.resList != null) {
                return Collections.unmodifiableList(this.resList);
            }
            return Collections.emptyList();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] stringArray;
            if (this.list == null) {
                return false;
            }
            String string = this.list.getMainAttributes().getValue("children");
            if (string == null || string.length() == 0) {
                return true;
            }
            for (String string2 : stringArray = string.split("[,;]")) {
                if (this.skipResource(string2)) continue;
                Attributes attributes = this.list.getAttributes(string2);
                if (attributes != null) {
                    String string3 = attributes.getValue("message");
                    if (string3 == null || string3.length() <= 0) continue;
                    if (this.resList == null) {
                        this.resList = new ArrayList<ResourceDesc>();
                    }
                    this.resList.add(new ResourceDesc(string3, this.cmdSuffix));
                    continue;
                }
                Logger.getLogger("glassfish").log(Level.FINE, "No resource attributes returned for " + string2);
            }
            return true;
        }

        private boolean skipResource(String string) {
            return string.equals(NbBundle.getMessage(Commands.class, (String)"nothingToList"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListComponentsCommand
    extends ServerCommand {
        private final String container;
        private Manifest list;
        private Map<String, List<String>> appMap;
        private static final List<String> engineBias = Arrays.asList("ear", "jruby", "web", "ejb", "appclient", "connector");

        public ListComponentsCommand() {
            this(null);
        }

        public ListComponentsCommand(String string) {
            super("list-components");
            this.container = string;
        }

        public String[] getContainers() {
            String[] stringArray = null;
            if (this.appMap != null && this.appMap.size() > 0) {
                Set<String> set = this.appMap.keySet();
                stringArray = set.toArray(new String[set.size()]);
            }
            return stringArray != null ? stringArray : new String[]{};
        }

        public Map<String, List<String>> getApplicationMap() {
            if (this.appMap != null) {
                return Collections.unmodifiableMap(this.appMap);
            }
            return Collections.emptyMap();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] stringArray;
            if (this.list == null) {
                return false;
            }
            String string = this.list.getMainAttributes().getValue("children");
            if (string == null || string.length() == 0) {
                return true;
            }
            for (String string2 : stringArray = string.split(";")) {
                List<String> list;
                if ("null".equals(string2)) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "list-components contains an invalid result.  Check server log for possible exceptions.");
                    continue;
                }
                String[] stringArray2 = string2.split("[<>]");
                String string3 = stringArray2[0];
                if (string3 == null || string3.length() == 0) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Skipping application with no name...");
                    continue;
                }
                String string4 = this.getPreferredEngine(stringArray2[1]);
                if (this.appMap == null) {
                    this.appMap = new HashMap<String, List<String>>();
                }
                if ((list = this.appMap.get(string4)) == null) {
                    list = new ArrayList<String>();
                    this.appMap.put(string4, list);
                }
                list.add(string3);
            }
            return true;
        }

        private String getPreferredEngine(String string) {
            String[] stringArray = string.split(",");
            String string2 = null;
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.skipContainer(stringArray[i])) continue;
                stringArray[i] = stringArray[i].trim();
                int n2 = engineBias.indexOf(stringArray[i]);
                if (n2 >= 0 && (n == -1 || n2 < n)) {
                    n = n2;
                }
                if (string2 != null) continue;
                string2 = stringArray[i];
            }
            if (n != -1) {
                string2 = engineBias.get(n);
            } else if (string2 == null) {
                string2 = "unknown";
            }
            return string2;
        }

        private boolean skipContainer(String string) {
            return this.container != null ? !this.container.equals(string) : "security_ContractProvider".equals(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListAppsCommand
    extends ServerCommand {
        private final String container;
        private Manifest list;
        private Map<String, List<AppDesc>> appMap;
        private static final List<String> engineBias = Arrays.asList("jruby", "web", "ejb");

        public ListAppsCommand() {
            this(null);
        }

        public ListAppsCommand(String string) {
            super("list-applications");
            this.container = string;
        }

        public String[] getContainers() {
            String[] stringArray = null;
            if (this.appMap != null && this.appMap.size() > 0) {
                Set<String> set = this.appMap.keySet();
                stringArray = set.toArray(new String[set.size()]);
            }
            return stringArray != null ? stringArray : new String[]{};
        }

        public Map<String, List<AppDesc>> getApplicationMap() {
            if (this.appMap != null) {
                return Collections.unmodifiableMap(this.appMap);
            }
            return Collections.emptyMap();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] stringArray;
            if (this.list == null) {
                return false;
            }
            String string = this.list.getMainAttributes().getValue("children");
            if (string == null || string.length() == 0) {
                return true;
            }
            for (String string2 : stringArray = string.split(";")) {
                List<AppDesc> list;
                String string3;
                if ("null".equals(string2)) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "list-applications contains an invalid result.  Check server log for possible exceptions.");
                    continue;
                }
                Attributes attributes = this.list.getAttributes(string2);
                if (attributes == null) continue;
                String string4 = this.getPreferredEngine(attributes.getValue("nb-engine_value"));
                String string5 = attributes.getValue("nb-name_value");
                if (string5 == null || string5.length() == 0) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Skipping application with no name...");
                    continue;
                }
                String string6 = attributes.getValue("nb-location_value");
                if (string6.startsWith("file:")) {
                    string6 = string6.substring(5);
                }
                if ((string3 = attributes.getValue("nb-context-root_value")) == null) {
                    string3 = string5;
                }
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if (this.appMap == null) {
                    this.appMap = new HashMap<String, List<AppDesc>>();
                }
                if ((list = this.appMap.get(string4)) == null) {
                    list = new ArrayList<AppDesc>();
                    this.appMap.put(string4, list);
                }
                list.add(new AppDesc(string5, string6, string3));
            }
            return true;
        }

        private String getPreferredEngine(String string) {
            String[] stringArray = string.split(",");
            String string2 = null;
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.skipContainer(stringArray[i])) continue;
                stringArray[i] = stringArray[i].trim();
                int n2 = engineBias.indexOf(stringArray[i]);
                if (n2 >= 0 && (n == -1 || n2 < n)) {
                    n = n2;
                }
                if (string2 != null) continue;
                string2 = stringArray[i];
            }
            if (n != -1) {
                string2 = engineBias.get(n);
            } else if (string2 == null) {
                string2 = "unknown";
            }
            return string2;
        }

        private boolean skipContainer(String string) {
            return this.container != null ? !this.container.equals(string) : "security_ContractProvider".equals(string);
        }
    }
}

