/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ide.ergonomics.Utilities;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.netbeans.modules.ide.ergonomics.fod.OpenAdvancedAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FodDataObjectFactory
implements DataObject.Factory {
    private static MultiFileLoader delegate;
    private static final Set<FileObject> ignore;
    private FileObject definition;

    private FodDataObjectFactory(FileObject fileObject) {
        this.definition = fileObject;
    }

    public static DataObject.Factory create(FileObject fileObject) {
        return new FodDataObjectFactory(fileObject);
    }

    public DataObject findDataObject(FileObject fileObject, Set<? super FileObject> set) throws IOException {
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getMIMEType().endsWith("+xml")) {
            OpenAdvancedAction.registerCandidate(fileObject);
            return null;
        }
        if (ignore.contains(fileObject)) {
            return null;
        }
        if (delegate == null) {
            Enumeration enumeration = DataLoaderPool.getDefault().allLoaders();
            while (enumeration.hasMoreElements()) {
                DataLoader dataLoader = (DataLoader)enumeration.nextElement();
                if (!(dataLoader instanceof MultiFileLoader)) continue;
                delegate = (MultiFileLoader)dataLoader;
            }
            assert (delegate instanceof MultiFileLoader);
        }
        return new Cookies(fileObject, delegate);
    }

    static {
        ignore = new WeakSet();
    }

    private final class Cookies
    extends MultiDataObject
    implements OpenCookie,
    EditCookie,
    ChangeListener {
        private final FileObject fo;
        private final ChangeListener weakL;
        private boolean open;

        private Cookies(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
            super(fileObject, multiFileLoader);
            this.fo = fileObject;
            this.weakL = WeakListeners.change((ChangeListener)this, (Object)FeatureManager.getInstance());
            FeatureManager.getInstance().addChangeListener(this.weakL);
        }

        protected Node createNodeDelegate() {
            DataNode dataNode = new DataNode((DataObject)this, Children.LEAF);
            dataNode.setIconBaseWithExtension("org/netbeans/modules/ide/ergonomics/fod/file.png");
            return dataNode;
        }

        public Lookup getLookup() {
            return this.getCookieSet().getLookup();
        }

        public void open() {
            this.delegate(true);
        }

        public void edit() {
            this.delegate(false);
        }

        private void delegate(boolean bl) {
            FeatureInfo featureInfo = FoDFileSystem.getInstance().whichProvides(FodDataObjectFactory.this.definition);
            String string = NbBundle.getMessage(FodDataObjectFactory.class, (String)"MSG_Opening_File", (Object)this.fo.getNameExt());
            FoDFileSystem.LOG.log(Level.FINER, "Opening file {0}", this);
            this.open = bl;
            boolean bl2 = Utilities.featureDialog(featureInfo, string, string);
            if (bl2) {
                this.finishOpen();
            }
        }

        private void finishOpen() {
            ignore.add(this.getPrimaryFile());
            try {
                DataObject dataObject = DataObject.find((FileObject)this.fo);
                FoDFileSystem.LOG.log(Level.FINER, "finishOpen {0}", dataObject);
                Class clazz = this.open ? OpenCookie.class : EditCookie.class;
                Object object = dataObject.getLookup().lookup(clazz);
                if (object == this) {
                    dataObject.setValid(false);
                    dataObject = DataObject.find((FileObject)this.fo);
                    object = dataObject.getLookup().lookup(clazz);
                }
                if (object instanceof OpenCookie) {
                    ((OpenCookie)object).open();
                }
                if (object instanceof EditCookie) {
                    ((EditCookie)object).edit();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            FeatureInfo featureInfo = FoDFileSystem.getInstance().whichProvides(FodDataObjectFactory.this.definition);
            FoDFileSystem.LOG.log(Level.FINER, "Refresh state of {0}", this);
            ignore.add(this.getPrimaryFile());
            if (featureInfo == null || featureInfo.isEnabled()) {
                this.dispose();
            }
        }
    }
}

