/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachTypeProxy
extends AttachType
implements Controller,
Callable<JComponent> {
    private AttachType delegate = null;
    private boolean isVisible = true;
    private String attachTypeName;
    PropertyChangeSupport propertyChangeSupport;
    private FeatureInfo featureInfo;

    private AttachTypeProxy(String string, FeatureInfo featureInfo) {
        this.attachTypeName = string;
        this.featureInfo = featureInfo;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public static AttachType create(FileObject fileObject) {
        FeatureInfo featureInfo = FoDFileSystem.getInstance().whichProvides(fileObject);
        String string = (String)fileObject.getAttribute("displayName");
        if (string == null) {
            throw new IllegalArgumentException("No displayName attribute: " + fileObject);
        }
        return new AttachTypeProxy(string, featureInfo);
    }

    public String getTypeDisplayName() {
        if (!this.isVisible) {
            return null;
        }
        if (this.getAttachType() != null) {
            this.isVisible = false;
            return null;
        }
        if (this.delegate != null) {
            return this.delegate.getTypeDisplayName();
        }
        return this.attachTypeName;
    }

    public JComponent getCustomizer() {
        if (this.delegate == null) {
            return new ConfigurationPanel(this.attachTypeName, this, this.featureInfo, false);
        }
        return this.delegate.getCustomizer();
    }

    public Controller getController() {
        if (this.delegate == null) {
            return this;
        }
        return this.getRealController();
    }

    private void invalidate() {
        this.isVisible = false;
        this.delegate = this.getAttachType();
        this.propertyChangeSupport.firePropertyChange("valid", false, true);
    }

    AttachType getAttachType() {
        for (AttachType attachType : DebuggerManager.getDebuggerManager().lookup(null, AttachType.class)) {
            if (attachType instanceof AttachTypeProxy || !attachType.getTypeDisplayName().equals(this.attachTypeName)) continue;
            return attachType;
        }
        return null;
    }

    public boolean isValid() {
        return this.delegate == null ? false : this.getRealController().isValid();
    }

    public boolean ok() {
        return this.delegate != null ? this.getRealController().ok() : false;
    }

    public boolean cancel() {
        return this.delegate == null ? true : this.getRealController().cancel();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public JComponent call() throws Exception {
        this.invalidate();
        return this.getCustomizer();
    }

    private Controller getRealController() {
        Controller controller = null;
        if (this.delegate != null) {
            JComponent jComponent = this.delegate.getCustomizer();
            controller = this.delegate.getController();
        }
        return controller;
    }
}

