/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.FlushVisitor;
import org.netbeans.modules.xml.xdm.visitor.Utils;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends NodeImpl
implements Node,
org.w3c.dom.Element {
    private String tagName = null;

    Element() {
    }

    Element(String string) {
        List<Token> list = this.getTokensForWrite();
        list.add(Token.create("<".concat(string), TokenType.TOKEN_ELEMENT_START_TAG));
        list.add(Token.create("/>", TokenType.TOKEN_ELEMENT_END_TAG));
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public void accept(XMLNodeVisitor xMLNodeVisitor) {
        xMLNodeVisitor.visit(this);
    }

    @Override
    public String getTagName() {
        if (this.tagName == null) {
            for (Token token : this.getTokens()) {
                if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
                this.tagName = token.getValue().substring(1);
                break;
            }
        }
        return this.tagName;
    }

    public void setTagName(String string) {
        assert (string != null && !"".equals(string));
        this.checkNotInTree();
        this.tagName = string;
        int n = -1;
        for (Token token : this.getTokens()) {
            ++n;
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            String string2 = token.getValue();
            String string3 = string2.startsWith("</") ? "</".concat(string) : "<".concat(string);
            Token token2 = Token.create(string3, TokenType.TOKEN_ELEMENT_START_TAG);
            this.getTokensForWrite().set(n, token2);
        }
    }

    @Override
    public String getPrefix() {
        int n;
        String string = this.getTagName();
        if (string != null && (n = string.indexOf(58)) > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    @Override
    public void setPrefix(String string) {
        String string2 = this.getLocalName();
        if (string == null || string.equals("")) {
            this.setTagName(string2);
        } else {
            this.setTagName(string.concat(":").concat(string2));
        }
    }

    @Override
    public String getLocalName() {
        int n;
        String string = this.getTagName();
        if (string != null && (n = string.indexOf(58) + 1) > 0) {
            return string.substring(n);
        }
        return string;
    }

    public void setLocalName(String string) {
        String string2 = this.getPrefix();
        if (string2 == null) {
            this.setTagName(string);
        } else if (string == null || string.equals("")) {
            this.setTagName(string2);
        } else {
            this.setTagName(string2.concat(":").concat(string));
        }
    }

    @Override
    void setTokens(List<Token> list) {
        this.tagName = null;
        super.setTokens(list);
    }

    @Override
    public String getAttribute(String string) {
        Attribute attribute = this.getAttributeNode(string);
        return attribute != null ? attribute.getValue() : "";
    }

    @Override
    public Attribute getAttributeNode(String string) {
        for (Attribute attribute : this.getAttributesForRead()) {
            if (!string.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    @Override
    public String getAttributeNS(String string, String string2) {
        Attribute attribute = this.getAttributeNodeNS(string, string2);
        return attribute != null ? attribute.getValue() : null;
    }

    @Override
    public Attribute getAttributeNodeNS(String string, String string2) {
        String string3 = this.lookupPrefix(string);
        String string4 = string2;
        if (string3 != null && !string3.equals("")) {
            string4 = string3 + ":" + string2;
        }
        return this.getAttributeNode(string4);
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    @Override
    public void setAttribute(String string, String string2) {
        this.checkNotInTree();
        Attribute attribute = this.getAttributeNode(string);
        if (attribute != null) {
            if (!attribute.isInTree()) {
                attribute.setValue(string2);
            } else {
                Attribute attribute2 = (Attribute)attribute.clone(true, false, false);
                attribute2.setValue(string2);
                int n = this.getAttributesForRead().indexOf(attribute);
                this.getAttributesForWrite().set(n, attribute2);
            }
        } else {
            Attribute attribute3 = new Attribute(string, string2);
            this.getAttributesForWrite().add(attribute3);
        }
    }

    @Override
    public Attribute setAttributeNode(Attr attr) {
        this.checkNotInTree();
        if (attr instanceof Attribute) {
            Attribute attribute = (Attribute)attr;
            Attribute attribute2 = this.getAttributeNode(attr.getName());
            if (attribute2 == null) {
                this.getAttributesForWrite().add(attribute);
                return attribute;
            }
            int n = this.getAttributesForRead().indexOf(attribute2);
            return this.getAttributesForWrite().set(n, attribute);
        }
        throw new DOMException(17, null);
    }

    @Override
    public void removeAttribute(String string) {
        Attribute attribute = this.getAttributeNode(string);
        this.removeAttributeNode(attribute);
    }

    @Override
    public Attribute removeAttributeNode(Attr attr) {
        this.checkNotInTree();
        this.getAttributesForWrite().remove(attr);
        return (Attribute)attr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) {
        return this.setAttributeNode(attr);
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) {
        this.checkNotInTree();
        Attribute attribute = this.getAttributeNodeNS(string, string2);
        if (attribute != null) {
            if (!attribute.isInTree()) {
                attribute.setValue(string3);
            } else {
                Attribute attribute2 = (Attribute)attribute.clone(true, false, false);
                attribute2.setValue(string3);
                int n = this.getAttributesForRead().indexOf(attribute);
                this.getAttributesForWrite().set(n, attribute2);
            }
        } else {
            String string4 = this.lookupPrefix(string);
            String string5 = string2;
            if (string4 != null && !string4.equals("")) {
                string5 = string4 + ":" + string2;
            }
            Attribute attribute3 = new Attribute(string5, string3);
            this.getAttributesForWrite().add(attribute3);
        }
    }

    @Override
    public void removeAttributeNS(String string, String string2) {
        this.removeAttributeNode(this.getAttributeNodeNS(string, string2));
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        NodeList nodeList = this.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        boolean bl = "*".equals(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            boolean bl2;
            org.w3c.dom.Node node = nodeList.item(i);
            boolean bl3 = bl2 = node instanceof Element && (bl || node.getNodeName().equals(string));
            if (!bl2) continue;
            arrayList.add((Element)node);
        }
        return new NodeListImpl(arrayList);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        return null;
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl) {
    }

    @Override
    public void setIdAttribute(String string, boolean bl) {
    }

    @Override
    public void setIdAttributeNS(String string, String string2, boolean bl) {
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void replaceAttribute(Attribute attribute, Attribute attribute2) {
        this.checkNotInTree();
        List<Attribute> list = this.getAttributesForRead();
        int n = list.indexOf(attribute2);
        assert (attribute != null && n > -1);
        attribute.checkNotInTree();
        this.getAttributesForWrite().set(list.indexOf(attribute2), attribute);
    }

    public void addAttribute(Attribute attribute, int n) {
        this.checkNotInTree();
        assert (attribute != null);
        attribute.checkNotInTree();
        this.getAttributesForWrite().add(n, attribute);
    }

    public void reorderAttribute(Attribute attribute, int n) {
        this.checkNotInTree();
        if (!attribute.isInTree()) {
            throw new IllegalArgumentException("Node is not in tree");
        }
        if (!this.getAttributesForWrite().remove(attribute)) {
            throw new IllegalArgumentException("Node is not in children");
        }
        this.getAttributesForWrite().add(n, attribute);
    }

    public void reorderAttribute(int[] nArray) {
        this.checkNotInTree();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.getAttributesForRead());
        if (nArray.length != arrayList.size()) {
            throw new IllegalArgumentException("Permutation length: " + nArray.length + " " + "is different than children size: " + arrayList.size());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Attribute attribute = (Attribute)arrayList.get(i);
            this.getAttributesForWrite().set(nArray[i], attribute);
        }
    }

    public void appendAttribute(Attribute attribute) {
        this.checkNotInTree();
        assert (attribute != null);
        attribute.checkNotInTree();
        this.getAttributesForWrite().add(attribute);
    }

    @Override
    public Node appendChild(org.w3c.dom.Node node) {
        boolean bl = this.getModel() == null || this.getModel().getStatus() != XDMModel.Status.PARSING;
        return this.appendChild(node, bl);
    }

    public Node appendChild(org.w3c.dom.Node node, boolean bl) {
        boolean bl2 = this.getChildNodes().getLength() == 0 && this.isStartTagSelfClosing();
        Node node2 = super.appendChild(node);
        if (bl2) {
            Token token = this.getEndToken();
            assert (token != null);
            List<Token> list = this.getTokensForWrite();
            int n = list.indexOf(token);
            assert (n != -1);
            list.set(n, Token.create(">", TokenType.TOKEN_ELEMENT_END_TAG));
            list.add(Token.create("</" + this.getTagName(), TokenType.TOKEN_ELEMENT_START_TAG));
            list.add(Token.create(">", TokenType.TOKEN_ELEMENT_END_TAG));
        }
        if (node2 instanceof Element && bl) {
            this.consolidateNamespaces((Element)node2);
        }
        return node2;
    }

    @Override
    public Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        Node node3 = super.insertBefore(node, node2);
        if (node3 instanceof Element && (this.getModel() == null || this.getModel().getStatus() != XDMModel.Status.PARSING)) {
            this.consolidateNamespaces((Element)node3);
        }
        return node3;
    }

    private Token getEndToken() {
        Token token = null;
        for (Token token2 : this.getTokens()) {
            if (!token2.getType().equals((Object)TokenType.TOKEN_ELEMENT_END_TAG)) continue;
            token = token2;
            break;
        }
        return token;
    }

    private boolean isStartTagSelfClosing() {
        boolean bl = false;
        for (Token token : this.getTokens()) {
            if (!token.getType().equals((Object)TokenType.TOKEN_ELEMENT_END_TAG)) continue;
            bl = token.getValue().equals(Token.create("/>", TokenType.TOKEN_ELEMENT_END_TAG).getValue());
        }
        return bl;
    }

    public String getXmlFragmentText() {
        return new FlushVisitor().flush(this.getChildNodes());
    }

    public void setXmlFragmentText(String string) throws IOException {
        while (this.hasChildNodes()) {
            this.removeChild(this.getFirstChild());
        }
        NodeList nodeList = Utils.parseFragment(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.appendChild(nodeList.item(i));
        }
    }

    private void consolidateNamespaces(Element element) {
        Object object;
        String string;
        String string2;
        Attribute attribute;
        int n;
        if (this.getModel() != null) {
            return;
        }
        String string3 = this.getNamespaceURI();
        if (string3 != null && string3.equals(element.getNamespaceURI())) {
            element.setPrefix(this.getPrefix());
        }
        List<Attribute> list = element.getAttributesForRead();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < list.size(); ++n) {
            attribute = list.get(n);
            if (attribute.isXmlnsAttribute()) continue;
            string2 = attribute.getPrefix();
            if (string2 != null) {
                string = element.lookupNamespaceURI(string2);
                if (string == null) continue;
                object = this.lookupPrefix(string);
                if (object == null || ((String)object).equals("")) {
                    arrayList.add(string2);
                } else if (!((String)object).equals(string2)) {
                    if (element.lookupNamespaceURI((String)object) != null) {
                        arrayList.add(string2);
                    } else {
                        attribute.setPrefix((String)object);
                    }
                }
            }
            if (((String[])(object = (string = attribute.getValue().trim()).split(":"))).length <= 1) continue;
            arrayList.add(object[0]);
        }
        for (n = 0; n < list.size(); ++n) {
            attribute = list.get(n);
            if (!attribute.isXmlnsAttribute() || arrayList.contains(string2 = attribute.getLocalName())) continue;
            if ("xmlns".equals(string2)) {
                string2 = "";
            }
            string = attribute.getValue();
            assert (string != null);
            object = this.lookupNamespaceURI(string2);
            String string4 = this.lookupPrefix(string);
            if (object == null && string4 == null) {
                element.removeAttributeNode(attribute);
                this.appendAttribute(attribute);
                continue;
            }
            if (string.equals(object) && string2.equals(string4)) {
                element.removeAttributeNode(attribute);
                continue;
            }
            if (string4 == null) continue;
            element.removeAttributeNode(attribute);
        }
    }

    @Override
    public Element cloneNode(boolean bl, boolean bl2) {
        Document document = this.isInTree() ? (Document)this.getOwnerDocument() : null;
        Map<Integer, String> map = null;
        if (document != null && bl2) {
            map = document.getNamespaceMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element = (Element)super.cloneNode(bl, map, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = string.length() > 0 ? "xmlns:" + string : "xmlns";
            Attribute attribute = new Attribute(string2, (String)entry.getValue());
            element.setAttributeNode(attribute);
        }
        return element;
    }

    protected void cloneNamespacePrefix(Map<Integer, String> map, Map<String, String> map2) {
        if (map == null) {
            return;
        }
        String string = map.get(this.getId());
        if (string == null) {
            return;
        }
        String string2 = this.getPrefix();
        if (string2 == null && this.getAttributeNode("xmlns") != null) {
            string2 = "";
        }
        if (string2 != null) {
            map2.put(string2, string);
        }
    }
}

