/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class TemplateChooserPanelGUI
extends JPanel
implements PropertyChangeListener,
AsyncGUIJob {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject templatesFolder;
    private TemplatesPanelGUI.Builder builder = new FileChooserBuilder();
    private Project project;
    private String category;
    private String template;
    private boolean isWarmUp = true;
    private ListCellRenderer projectCellRenderer;
    private boolean firstTime = true;
    private JLabel jLabel1;
    private JComboBox projectsComboBox;
    private JPanel templatesPanel;

    public TemplateChooserPanelGUI() {
        this.initComponents();
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_Name"));
        this.projectCellRenderer = new ProjectCellRenderer();
        this.projectsComboBox.setRenderer(this.projectCellRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues(Project project, String string, String string2) {
        boolean bl;
        assert (project != null) : "Project can not be null";
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            this.project = project;
            this.category = string;
            this.template = string2;
            bl = this.isWarmUp;
        }
        if (!bl) {
            this.selectProject(this.project);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(this.category);
            ((TemplatesPanelGUI)this.templatesPanel).setSelectedTemplateByName(this.template);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.project = null;
    }

    private void initValues(Project project) {
        Project[] projectArray = OpenProjectList.getDefault().getOpenProjects();
        Arrays.sort(projectArray, OpenProjectList.PROJECT_BY_DISPLAYNAME);
        DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(projectArray);
        this.projectsComboBox.setModel(defaultComboBoxModel);
        this.selectProject(project);
    }

    private void selectProject(Project project) {
        if (project != null) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.projectsComboBox.getModel();
            if (defaultComboBoxModel.getIndexOf(project) == -1) {
                defaultComboBoxModel.insertElementAt(project, 0);
            }
            this.projectsComboBox.setSelectedItem(project);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject() {
        boolean bl;
        TemplateChooserPanelGUI templateChooserPanelGUI = this;
        synchronized (templateChooserPanelGUI) {
            bl = this.isWarmUp;
        }
        if (bl) {
            return this.project;
        }
        return (Project)this.projectsComboBox.getSelectedItem();
    }

    public FileObject getTemplate() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireChange();
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public String getCategoryName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedCategoryName();
    }

    public String getTemplateName() {
        return ((TemplatesPanelGUI)this.templatesPanel).getSelectedTemplateName();
    }

    public void setCategory(String string) {
        ((TemplatesPanelGUI)this.templatesPanel).setSelectedCategoryByName(string);
    }

    public void addNotify() {
        if (this.firstTime) {
            Utilities.attachInitJob((Component)this, (AsyncGUIJob)this);
            this.firstTime = false;
        }
        super.addNotify();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.templatesPanel = new TemplatesPanelGUI(this.builder);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"LBL_TemplateChooserPanelGUI_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 13, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"ACSN_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"ACSD_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.templatesPanel, gridBagConstraints);
    }

    private static boolean isTemplate(DataObject dataObject) {
        if (dataObject.isTemplate()) {
            return true;
        }
        if (dataObject instanceof DataShadow) {
            return ((DataShadow)dataObject).getOriginal().isTemplate();
        }
        return false;
    }

    private boolean hasChildren(Project project, DataObject dataObject) {
        if (!(dataObject instanceof DataFolder)) {
            return false;
        }
        DataFolder dataFolder = (DataFolder)dataObject;
        if (!OpenProjectList.isRecommended(project, dataFolder.getPrimaryFile())) {
            return false;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        boolean bl = false;
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (TemplateChooserPanelGUI.isTemplate(dataObjectArray[i]) && OpenProjectList.isRecommended(project, dataObjectArray[i].getPrimaryFile())) {
                if (dataObjectArray[i] instanceof DataShadow) continue;
                bl = true;
                break;
            }
            if (!(dataObjectArray[i] instanceof DataFolder) || !this.hasChildren(project, dataObjectArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void construct() {
        this.templatesFolder = FileUtil.getConfigFile((String)"Templates");
        ((TemplatesPanelGUI)this.templatesPanel).warmUp(this.templatesFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        Object object;
        Cursor cursor = null;
        try {
            String string;
            String string2;
            TemplateChooserPanelGUI templateChooserPanelGUI = this;
            synchronized (templateChooserPanelGUI) {
                object = this.project;
                string2 = this.category;
                string = this.template;
            }
            cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.initValues((Project)object);
            ((TemplatesPanelGUI)this.templatesPanel).doFinished(this.templatesFolder, string2, string);
            object = this;
        }
        catch (Throwable throwable) {
            TemplateChooserPanelGUI templateChooserPanelGUI = this;
            synchronized (templateChooserPanelGUI) {
                this.isWarmUp = false;
            }
            if (cursor != null) {
                this.setCursor(cursor);
            }
            throw throwable;
        }
        synchronized (object) {
            this.isWarmUp = false;
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            } else {
                this.setText(object == null ? "" : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private final class FileChooserBuilder
    implements TemplatesPanelGUI.Builder {
        private FileChooserBuilder() {
        }

        public Children createCategoriesChildren(DataFolder dataFolder) {
            return new TemplateChildren(dataFolder);
        }

        public Children createTemplatesChildren(DataFolder dataFolder) {
            return new FileChildren(dataFolder);
        }

        public void fireChange() {
            TemplateChooserPanelGUI.this.fireChange();
        }

        public String getCategoriesName() {
            return NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"CTL_Categories");
        }

        public String getTemplatesName() {
            return NbBundle.getMessage(TemplateChooserPanelGUI.class, (String)"CTL_Files");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FileChildren
    extends Children.Keys<DataObject> {
        private DataFolder root;

        public FileChildren(DataFolder dataFolder) {
            this.root = dataFolder;
            assert (this.root != null) : "Root can not be null";
        }

        protected void addNotify() {
            this.setKeys(this.root.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new DataObject[0]);
        }

        protected Node[] createNodes(DataObject dataObject) {
            if (TemplateChooserPanelGUI.isTemplate(dataObject) && OpenProjectList.isRecommended(TemplateChooserPanelGUI.this.getProject(), dataObject.getPrimaryFile())) {
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                return new Node[]{new FilterNode(dataObject.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TemplateChildren
    extends Children.Keys<DataFolder>
    implements ActionListener {
        private final DataFolder folder;

        TemplateChildren(DataFolder dataFolder) {
            this.folder = dataFolder;
        }

        protected void addNotify() {
            super.addNotify();
            TemplateChooserPanelGUI.this.projectsComboBox.addActionListener(this);
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            TemplateChooserPanelGUI.this.projectsComboBox.removeActionListener(this);
            super.removeNotify();
        }

        private void updateKeys() {
            ArrayList<DataFolder> arrayList = new ArrayList<DataFolder>();
            for (DataObject dataObject : this.folder.getChildren()) {
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!this.acceptTemplate(dataObject, fileObject) || !TemplateChooserPanelGUI.this.hasChildren((Project)TemplateChooserPanelGUI.this.projectsComboBox.getSelectedItem(), dataObject)) continue;
                arrayList.add((DataFolder)dataObject);
            }
            this.setKeys(arrayList);
        }

        protected Node[] createNodes(DataFolder dataFolder) {
            boolean bl = false;
            for (DataObject dataObject : dataFolder.getChildren()) {
                if (!(dataObject instanceof DataFolder) || TemplateChooserPanelGUI.isTemplate(dataObject)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return new Node[]{new FilterNode(dataFolder.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[]{new FilterNode(dataFolder.getNodeDelegate(), (Children)new TemplateChildren(dataFolder))};
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TemplateChooserPanelGUI.this.getCategoryName();
            String string2 = ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).getSelectedTemplateName();
            this.setKeys(Collections.emptySet());
            this.updateKeys();
            TemplateChooserPanelGUI.this.setCategory(string);
            ((TemplatesPanelGUI)TemplateChooserPanelGUI.this.templatesPanel).setSelectedTemplateByName(string2);
        }

        private boolean acceptTemplate(DataObject dataObject, FileObject fileObject) {
            if (dataObject instanceof DataFolder && !TemplateChooserPanelGUI.isTemplate((DataObject)((DataFolder)dataObject))) {
                Object object = fileObject.getAttribute("simple");
                return object == null || Boolean.TRUE.equals(object);
            }
            return false;
        }
    }
}

