/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectsRootNode;
import org.netbeans.modules.project.ui.SyncEditorWithViewsAction;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTab
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener {
    public static final String ID_LOGICAL = "projectTabLogical_tc";
    public static final String ID_PHYSICAL = "projectTab_tc";
    private static final Image ICON_LOGICAL = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.png");
    private static final Image ICON_PHYSICAL = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.png");
    private static Map<String, ProjectTab> tabs = new HashMap<String, ProjectTab>();
    private final transient ExplorerManager manager;
    private transient Node rootNode;
    private String id;
    private final transient ProjectTreeView btv;
    private final JLabel noProjectsLabel = new JLabel(NbBundle.getMessage(ProjectTab.class, (String)"NO_PROJECT_OPEN"));
    private boolean synchronizeViews = false;
    private FileObject objectToSelect;
    private RequestProcessor.Task selectionTask;
    private static final int NODE_SELECTION_DELAY = 200;
    private static final long serialVersionUID = 9374872358L;
    private static final Lookup context = Utilities.actionsGlobalContext();
    private static final Lookup.Result<FileObject> foSelection = context.lookup(new Lookup.Template(FileObject.class));
    private static final Lookup.Result<DataObject> doSelection = context.lookup(new Lookup.Template(DataObject.class));
    private final LookupListener baseListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            if (TopComponent.getRegistry().getActivated() == ProjectTab.this) {
                return;
            }
            if (ProjectTab.this.synchronizeViews) {
                Collection collection = foSelection.allInstances();
                if (collection.size() == 1) {
                    ProjectTab.this.selectNodeAsyncNoSelect((FileObject)collection.iterator().next());
                } else {
                    Collection collection2 = doSelection.allInstances();
                    if (collection2.size() == 1) {
                        ProjectTab.this.selectNodeAsyncNoSelect(((DataObject)collection2.iterator().next()).getPrimaryFile());
                    }
                }
            }
        }
    };
    private final LookupListener weakListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.baseListener, null);
    private final RequestProcessor RP = new RequestProcessor();

    public ProjectTab(String string) {
        this();
        this.id = string;
        this.initValues();
    }

    public ProjectTab() {
        this.manager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", new DelegatingAction("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true)));
        this.initComponents();
        this.btv = new ProjectTreeView();
        this.btv.setDragSource(true);
        this.btv.setUseSubstringInQuickSearch(true);
        this.btv.setRootVisible(false);
        this.add((Component)((Object)this.btv), "Center");
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.noProjectsLabel.addMouseListener(new LabelPopupDisplayer(this.noProjectsLabel));
        this.noProjectsLabel.setHorizontalAlignment(0);
        this.noProjectsLabel.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.noProjectsLabel.setBackground(color != null ? color : Color.white);
        this.noProjectsLabel.setOpaque(true);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
        this.selectionTask = this.createSelectionTask();
        Preferences preferences = NbPreferences.forModule(SyncEditorWithViewsAction.class);
        this.synchronizeViews = preferences.getBoolean("synchronizeEditorWithViews", false);
        preferences.addPreferenceChangeListener(new NbPrefsListener());
    }

    public void setGroup(Group group) {
        if (this.id.equals(ID_LOGICAL)) {
            if (group != null) {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc_with_group", (Object)group.getName()));
            } else {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc"));
            }
        } else {
            this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTab_tc"));
        }
    }

    private void initValues() {
        this.setGroup(Group.getActiveGroup());
        if (this.id.equals(ID_LOGICAL)) {
            this.setIcon(ICON_LOGICAL);
        } else {
            this.setIcon(ICON_PHYSICAL);
        }
        if (this.rootNode == null) {
            this.rootNode = new ProjectsRootNode(this.id.equals(ID_LOGICAL) ? 1 : 0);
        }
        this.manager.setRootContext(this.rootNode);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static synchronized ProjectTab findDefault(String string) {
        ProjectTab projectTab = tabs.get(string);
        if (projectTab == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
            if (topComponent != null) {
                if (!(topComponent instanceof ProjectTab)) {
                    IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + ProjectTab.class.getName() + " Returned:" + topComponent.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                    projectTab = ProjectTab.getDefault(string);
                } else {
                    projectTab = (ProjectTab)topComponent;
                }
            } else {
                projectTab = ProjectTab.getDefault(string);
            }
        }
        return projectTab;
    }

    public static synchronized ProjectTab getDefault(String string) {
        ProjectTab projectTab = tabs.get(string);
        if (projectTab == null) {
            projectTab = new ProjectTab(string);
            tabs.put(string, projectTab);
        }
        return projectTab;
    }

    public static TopComponent getLogical() {
        return ProjectTab.getDefault(ID_LOGICAL);
    }

    public static TopComponent getPhysical() {
        return ProjectTab.getDefault(ID_PHYSICAL);
    }

    protected String preferredID() {
        return this.id;
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.manager.getSelectedNodes(), (HelpCtx)(ID_LOGICAL.equals(this.id) ? new HelpCtx("ProjectTab_Projects") : new HelpCtx("ProjectTab_Files")));
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.btv.requestFocus();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.rootNode.getHandle());
        objectOutput.writeObject(this.btv.getExpandedPaths());
        objectOutput.writeObject(this.getSelectedPaths());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.id = (String)objectInput.readObject();
        this.rootNode = ((Node.Handle)objectInput.readObject()).getNode();
        List list = (List)objectInput.readObject();
        List list2 = null;
        try {
            list2 = (List)objectInput.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        this.initValues();
        if (System.getProperty("netbeans.keep.expansion") != null) {
            this.btv.expandNodes(list);
            this.selectPaths(list2);
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    private void startListening() {
        foSelection.addLookupListener(this.weakListener);
        doSelection.addLookupListener(this.weakListener);
        this.baseListener.resultChanged(null);
    }

    private void stopListening() {
        foSelection.removeLookupListener(this.weakListener);
        doSelection.removeLookupListener(this.weakListener);
    }

    protected void componentShowing() {
        super.componentShowing();
        this.startListening();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.stopListening();
    }

    public void selectNodeAsync(FileObject fileObject) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.open();
        this.requestActive();
        this.selectNodeAsyncNoSelect(fileObject);
    }

    private RequestProcessor.Task createSelectionTask() {
        RequestProcessor.Task task = this.RP.create(new Runnable(){

            public void run() {
                Node node;
                if (ProjectTab.this.objectToSelect == null) {
                    return;
                }
                ProjectsRootNode projectsRootNode = (ProjectsRootNode)ProjectTab.this.manager.getRootContext();
                Node node2 = projectsRootNode.findNode(ProjectTab.this.objectToSelect);
                if (node2 == null && (node = FileOwnerQuery.getOwner((FileObject)ProjectTab.this.objectToSelect)) != null && !OpenProjectList.getDefault().isOpen((Project)node)) {
                    DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
                    String string = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm", (Object)ProjectUtils.getInformation((Project)node).getDisplayName());
                    String string2 = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm_title");
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, string2, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() == NotifyDescriptor.OK_OPTION) {
                        if (!OpenProjectList.getDefault().isOpen((Project)node)) {
                            OpenProjects.getDefault().open(new Project[]{node}, false);
                        }
                        node2 = projectsRootNode.findNode(ProjectTab.this.objectToSelect);
                    }
                }
                node = node2;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (node != null) {
                            try {
                                ProjectTab.this.manager.setSelectedNodes(new Node[]{node});
                                ProjectTab.this.btv.scrollToNode(node);
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectTab.class, (String)(ProjectTab.ID_LOGICAL.equals(ProjectTab.this.id) ? "MSG_NodeNotFound_ProjectsTab" : "MSG_NodeNotFound_FilesTab")));
                        }
                        ProjectTab.this.setCursor(null);
                    }
                });
            }
        });
        return task;
    }

    private void selectNodeAsyncNoSelect(FileObject fileObject) {
        this.objectToSelect = fileObject;
        this.selectionTask.schedule(200);
    }

    public boolean selectNode(FileObject fileObject) {
        ProjectsRootNode projectsRootNode = (ProjectsRootNode)this.manager.getRootContext();
        Node node = projectsRootNode.findNode(fileObject);
        if (node != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node});
                this.btv.scrollToNode(node);
                return true;
            }
            catch (PropertyVetoException propertyVetoException) {
                return false;
            }
        }
        return false;
    }

    public void expandNode(Node node) {
        this.btv.expandNode(node);
    }

    private List<String[]> getSelectedPaths() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Node node = this.manager.getRootContext();
        for (int i = 0; i < nodeArray.length; ++i) {
            String[] stringArray = NodeOp.createPath((Node)nodeArray[i], (Node)node);
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    private void selectPaths(List<String[]> list) {
        if (list == null) {
            return;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node = this.manager.getRootContext();
        for (String[] stringArray : list) {
            try {
                Node node2 = NodeOp.findPath((Node)node, (String[])stringArray);
                if (node2 == null) continue;
                arrayList.add(node2);
            }
            catch (NodeNotFoundException nodeNotFoundException) {}
        }
        if (!arrayList.isEmpty()) {
            Node[] nodeArray = new Node[arrayList.size()];
            arrayList.toArray(nodeArray);
            try {
                this.manager.setSelectedNodes(nodeArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
            if (OpenProjects.getDefault().getOpenProjects().length > 0) {
                this.restoreTreeView();
            } else {
                this.showNoProjectsLabel();
            }
        }
    }

    private void showNoProjectsLabel() {
        if (this.noProjectsLabel.isShowing()) {
            return;
        }
        this.remove((Component)((Object)this.btv));
        this.add(this.noProjectsLabel, "Center");
        this.revalidate();
        this.repaint();
    }

    private void restoreTreeView() {
        if (this.btv.isShowing()) {
            return;
        }
        this.remove(this.noProjectsLabel);
        this.add((Component)((Object)this.btv), "Center");
        this.revalidate();
        this.repaint();
    }

    private class NbPrefsListener
    implements PreferenceChangeListener {
        private NbPrefsListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if ("synchronizeEditorWithViews".equals(preferenceChangeEvent.getKey())) {
                ProjectTab.this.synchronizeViews = Boolean.parseBoolean(preferenceChangeEvent.getNewValue());
            }
        }
    }

    private class LabelPopupDisplayer
    extends MouseAdapter {
        private Component component;

        public LabelPopupDisplayer(Component component) {
            this.component = component;
        }

        private void showPopup(int n, int n2) {
            Action[] actionArray = ProjectTab.this.rootNode.getActions(false);
            JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Component)this.component);
            jPopupMenu.show(this.component, n, n2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && ProjectTab.this.id.equals(ProjectTab.ID_LOGICAL)) {
                this.showPopup(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && ProjectTab.this.id.equals(ProjectTab.ID_LOGICAL)) {
                this.showPopup(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DelegatingAction
    extends AbstractAction
    implements PropertyChangeListener {
        private Action explorerAction;
        private String projectAction;

        public DelegatingAction(String string, Action action) {
            this.projectAction = string;
            this.explorerAction = action;
            ProjectTab.this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            action.addPropertyChangeListener(this);
        }

        private boolean isProject() {
            Node[] nodeArray = ProjectTab.this.manager.getSelectedNodes();
            if (nodeArray.length == 1) {
                return nodeArray[0].getParentNode() == ProjectTab.this.rootNode;
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isProject()) {
                Node[] nodeArray = ProjectTab.this.manager.getSelectedNodes();
                Project project = (Project)nodeArray[0].getLookup().lookup(Project.class);
                assert (project != null);
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.projectAction, nodeArray[0].getLookup());
            } else {
                this.explorerAction.actionPerformed(actionEvent);
            }
        }

        public void updateIsEnabled() {
            if (this.isProject()) {
                Node[] nodeArray = ProjectTab.this.manager.getSelectedNodes();
                Project project = (Project)nodeArray[0].getLookup().lookup(Project.class);
                if (project == null) {
                    this.setEnabled(false);
                    return;
                }
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                String[] stringArray = actionProvider != null ? actionProvider.getSupportedActions() : new String[]{};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!"delete".equals(stringArray[i])) continue;
                    this.setEnabled(actionProvider.isActionEnabled(this.projectAction, nodeArray[0].getLookup()));
                    return;
                }
                this.setEnabled(false);
            } else {
                this.setEnabled(this.explorerAction.isEnabled());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateIsEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectTreeView
    extends BeanTreeView {
        private ProjectTreeView() {
        }

        public void scrollToNode(final Node node) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeNode treeNode = Visualizer.findVisualizer((Node)node);
                    if (treeNode == null) {
                        return;
                    }
                    TreeModel treeModel = ProjectTreeView.this.tree.getModel();
                    if (!(treeModel instanceof DefaultTreeModel)) {
                        return;
                    }
                    TreePath treePath = new TreePath(((DefaultTreeModel)treeModel).getPathToRoot(treeNode));
                    Rectangle rectangle = ProjectTreeView.this.tree.getPathBounds(treePath);
                    if (rectangle != null) {
                        ProjectTreeView.this.tree.scrollRectToVisible(rectangle);
                    }
                }
            });
        }

        public List<String[]> getExpandedPaths() {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            TreeNode treeNode = Visualizer.findVisualizer((Node)ProjectTab.this.rootNode);
            TreePath treePath = new TreePath(treeNode);
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
            while (enumeration != null && enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                Node node = Visualizer.findNode((Object)treePath2.getLastPathComponent());
                String[] stringArray = NodeOp.createPath((Node)node, (Node)ProjectTab.this.rootNode);
                arrayList.add(stringArray);
            }
            return arrayList;
        }

        public void expandNodes(List list) {
            for (String[] stringArray : list) {
                TreePath treePath = this.stringPath2TreePath(stringArray);
                if (treePath == null) continue;
                this.showPath(treePath);
            }
        }

        private TreePath stringPath2TreePath(String[] stringArray) {
            try {
                Node node = NodeOp.findPath((Node)ProjectTab.this.rootNode, (String[])stringArray);
                Object[] objectArray = new TreeNode[stringArray.length + 1];
                for (int i = stringArray.length; i >= 0; --i) {
                    if (node == null) {
                        return null;
                    }
                    objectArray[i] = Visualizer.findVisualizer((Node)node);
                    node = node.getParentNode();
                }
                return new TreePath(objectArray);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
    }
}

