/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.AbstractBindingResult;

public abstract class AbstractPropertyBindingResult
extends AbstractBindingResult {
    protected AbstractPropertyBindingResult(String objectName) {
        super(objectName);
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.getPropertyAccessor();
    }

    protected String canonicalFieldName(String field) {
        return PropertyAccessorUtils.canonicalPropertyName(field);
    }

    public Class getFieldType(String field) {
        return this.getPropertyAccessor().getPropertyType(field);
    }

    public Object getActualFieldValue(String field) {
        return this.getPropertyAccessor().getPropertyValue(field);
    }

    protected Object formatFieldValue(String field, Object value) {
        PropertyEditor customEditor = this.getCustomEditor(field);
        if (customEditor != null) {
            customEditor.setValue(value);
            String textValue = customEditor.getAsText();
            if (textValue != null) {
                return textValue;
            }
        }
        return value;
    }

    public PropertyEditor getCustomEditor(String field) {
        String fixedField = this.fixedField(field);
        Class type = this.getPropertyAccessor().getPropertyType(fixedField);
        return this.getPropertyAccessor().findCustomEditor(type, fixedField);
    }

    public abstract ConfigurablePropertyAccessor getPropertyAccessor();
}

