/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.ObservableActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableAction<T>
extends AbstractAction
implements AsynchronousAction {
    private final List<ObservableActionListener<T>> listeners = Collections.synchronizedList(new ArrayList());
    private volatile Future<T> taskFutureResult = null;
    private final Object lock = new String(ObservableAction.class.getName());

    public ObservableAction(String string) {
        super(string);
    }

    public final void addObservableActionListener(ObservableActionListener<T> observableActionListener) {
        if (!this.listeners.contains(observableActionListener)) {
            this.listeners.add(observableActionListener);
        }
    }

    public final void removeObservableActionListener(ObservableActionListener<T> observableActionListener) {
        this.listeners.remove(observableActionListener);
    }

    protected abstract T performAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (actionEvent == null) {
                // empty if block
            }
            if (this.taskFutureResult == null || this.taskFutureResult.isDone()) {
                this.taskFutureResult = NativeTaskExecutorService.submit(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        ObservableAction.this.fireStarted();
                        Object t = ObservableAction.this.performAction();
                        ObservableAction.this.fireCompleted(t);
                        return t;
                    }
                }, "Performing observable action " + this.getValue("Name"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke() {
        Object object = this.lock;
        synchronized (object) {
            this.actionPerformed(null);
            try {
                this.taskFutureResult.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private void fireStarted() {
        ArrayList<ObservableActionListener<T>> arrayList = new ArrayList<ObservableActionListener<T>>(this.listeners);
        for (ObservableActionListener observableActionListener : arrayList) {
            observableActionListener.actionStarted(this);
        }
    }

    private void fireCompleted(T t) {
        ArrayList<ObservableActionListener<T>> arrayList = new ArrayList<ObservableActionListener<T>>(this.listeners);
        for (ObservableActionListener observableActionListener : arrayList) {
            observableActionListener.actionCompleted(this, t);
        }
    }
}

