/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WindowsSupport {
    private static final WindowsSupport instance = new WindowsSupport();
    private String cygwinBase = null;
    private String cygwinShell = null;
    private String msysBase = null;
    private String msysShell = null;

    private WindowsSupport() {
    }

    public static WindowsSupport getInstance() {
        return instance;
    }

    public String getShell() {
        Object object;
        Object object2;
        String string = WindowsSupport.queryWindowsRegistry("HKLM\\SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)");
        if (string != null && ((File)(object2 = new File(string + "/bin/sh.exe"))).exists() && ((File)object2).canRead()) {
            this.cygwinShell = ((File)object2).getAbsolutePath();
            this.cygwinBase = ((File)object2).getParentFile().getParentFile().getAbsolutePath();
            return this.cygwinShell;
        }
        object2 = WindowsSupport.queryWindowsRegistry("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1", "Inno Setup: App Path", ".*REG_SZ(.*)");
        if (object2 != null && ((File)(object = new File((String)object2 + "/bin/sh.exe"))).exists() && ((File)object).canRead()) {
            this.msysShell = ((File)object).getAbsolutePath();
            this.msysBase = ((File)object).getParentFile().getParentFile().getAbsolutePath();
            return this.msysShell;
        }
        object = System.getenv("PATH");
        if (object != null) {
            for (String string2 : ((String)object).split(";")) {
                File file = new File(string2, "sh.exe");
                if (!file.exists() || !file.canRead()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private static String queryWindowsRegistry(String string, String string2, String string3) {
        try {
            String string4;
            ProcessBuilder processBuilder = new ProcessBuilder("c:\\windows\\system32\\reg.exe", "query", string, "/v", string2);
            Process process = processBuilder.start();
            Pattern pattern = Pattern.compile(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while ((string4 = bufferedReader.readLine()) != null) {
                Matcher matcher = pattern.matcher(string4);
                if (!matcher.matches()) continue;
                return matcher.group(1).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string.toLowerCase().startsWith("hklm")) {
            return WindowsSupport.queryWindowsRegistry("HKCU" + string.substring(4), string2, string3);
        }
        return null;
    }

    public String convertToShellPath(String string) {
        String string2;
        if (string == null) {
            return "";
        }
        while (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(1) != ':') {
            return string.replaceAll("\\\\", "/");
        }
        char c = string.charAt(0);
        String string3 = string.substring(2);
        if (this.cygwinBase != null) {
            string2 = "/cygdrive/" + c + string3;
            string2 = string2.replaceAll("\\\\", "/");
        } else if (this.msysBase != null) {
            string2 = "/" + c + string3;
            string2 = string2.replaceAll("\\\\", "/");
        } else {
            string2 = string;
        }
        string2 = string2.replaceAll("([^\\\\]) ", "$1\\\\ ");
        return string2;
    }

    public String convertToWindowsPath(String string) {
        String string2 = "";
        if (string.startsWith("/cygdrive/")) {
            string = string.substring(9);
        }
        if (string.startsWith("/") && string.charAt(2) == '/') {
            string2 = string.charAt(1) + ":";
            string = string.substring(2);
        }
        string2 = (string2 + string).replaceAll("/", "\\\\");
        return string2;
    }

    public String convertToAllShellPaths(String string) {
        String[] stringArray = string.split(";");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append(this.convertToShellPath(string2));
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }
}

