/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.support.Encrypter;
import org.openide.util.NbPreferences;

public final class PasswordManager {
    private static final String KEY_PREFIX = "remote.user.info";
    private static PasswordManager instance = new PasswordManager();
    private final Map<String, String> cache = Collections.synchronizedMap(new HashMap());

    private PasswordManager() {
    }

    public static PasswordManager getInstance() {
        return instance;
    }

    public char[] get(ExecutionEnvironment executionEnvironment) {
        String string = ((Object)executionEnvironment).toString();
        Encrypter encrypter = new Encrypter(string);
        String string2 = this.cache.get(string);
        if (string2 != null) {
            return encrypter.decrypt(string2).toCharArray();
        }
        String string3 = encrypter.encrypt(KEY_PREFIX + string);
        String string4 = NbPreferences.forModule(PasswordManager.class).get(string3, null);
        if (string4 != null) {
            this.cache.put(string, string4);
            return encrypter.decrypt(string4.toCharArray());
        }
        return null;
    }

    public void put(ExecutionEnvironment executionEnvironment, char[] cArray, boolean bl) {
        String string = ((Object)executionEnvironment).toString();
        Encrypter encrypter = new Encrypter(string);
        String string2 = String.valueOf(encrypter.encrypt(cArray));
        this.cache.put(string, string2);
        if (bl) {
            String string3 = encrypter.encrypt(KEY_PREFIX + string);
            NbPreferences.forModule(PasswordManager.class).put(string3, String.valueOf(string2));
        }
    }

    public void clearPassword(ExecutionEnvironment executionEnvironment) {
        String string = ((Object)executionEnvironment).toString();
        Encrypter encrypter = new Encrypter(string);
        this.cache.remove(string);
        String string2 = encrypter.encrypt(KEY_PREFIX + string);
        NbPreferences.forModule(PasswordManager.class).remove(string2);
    }
}

