/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

public class CommandLineHelper {
    private static final WeakHashMap<ExecutionEnvironment, CommandLineHelper> cache = new WeakHashMap();
    private final ExecutionEnvironment ee;
    private final HostInfo hostInfo;
    private final boolean isWindows;
    private final boolean isMacOS;

    private CommandLineHelper(ExecutionEnvironment executionEnvironment) {
        this.ee = executionEnvironment;
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        this.hostInfo = hostInfo;
        this.isWindows = this.hostInfo != null && this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        this.isMacOS = this.hostInfo != null && this.hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandLineHelper getInstance(ExecutionEnvironment executionEnvironment) {
        CommandLineHelper commandLineHelper = null;
        WeakHashMap<ExecutionEnvironment, CommandLineHelper> weakHashMap = cache;
        synchronized (weakHashMap) {
            if (cache.containsKey(executionEnvironment)) {
                commandLineHelper = cache.get(executionEnvironment);
            }
            if (commandLineHelper == null) {
                commandLineHelper = new CommandLineHelper(executionEnvironment);
                cache.put(executionEnvironment, commandLineHelper);
            }
        }
        return commandLineHelper;
    }

    public String toShellPaths(String string) {
        if (this.isWindows) {
            return WindowsSupport.getInstance().convertToAllShellPaths(string);
        }
        return string;
    }

    public String toSystemPath(String string) {
        String string2;
        if (this.isWindows) {
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            string = WindowsSupport.getInstance().convertToWindowsPath(string);
            string2 = "\"" + string + "\"";
        } else {
            string2 = this.escapeSpaces(string);
        }
        return string2;
    }

    public String toShellPath(String string) {
        String string2 = this.isWindows ? WindowsSupport.getInstance().convertToShellPath(string) : this.escapeSpaces(string);
        return string2;
    }

    private String escapeSpaces(String string) {
        return string.replaceAll("([^\\\\]) ", "$1\\\\ ");
    }
}

