/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.LocalNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.TerminalLocalNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.support.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProcessBuilder
implements Callable<Process> {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private NativeProcessInfo info;
    private ExternalTerminal externalTerminal = null;
    private AbstractNativeProcess process = null;

    private NativeProcessBuilder(ExecutionEnvironment executionEnvironment) {
        this.info = new NativeProcessInfo(executionEnvironment);
    }

    public static NativeProcessBuilder newProcessBuilder(ExecutionEnvironment executionEnvironment) {
        return new NativeProcessBuilder(executionEnvironment);
    }

    public static NativeProcessBuilder newLocalProcessBuilder() {
        return new NativeProcessBuilder(ExecutionEnvironmentFactory.getLocal());
    }

    public void redirectError() {
        this.info.redirectError(true);
    }

    public NativeProcessBuilder setExecutable(String string) {
        this.info.setExecutable(string);
        return this;
    }

    public NativeProcessBuilder setCommandLine(String string) {
        this.info.setCommandLine(string);
        return this;
    }

    public NativeProcessBuilder addNativeProcessListener(ChangeListener changeListener) {
        this.info.addNativeProcessListener(changeListener);
        return this;
    }

    @Override
    public NativeProcess call() throws IOException {
        if (this.info.getExecutionEnvironment().isRemote()) {
            this.process = new RemoteNativeProcess(this.info);
        } else if (this.externalTerminal != null) {
            boolean bl = this.externalTerminal.isAvailable(this.info.getExecutionEnvironment());
            if (bl) {
                this.process = new TerminalLocalNativeProcess(this.info, this.externalTerminal);
            } else {
                log.info("Unable to find external terminal. Will start in OutputWindow");
                this.process = new LocalNativeProcess(this.info);
            }
        } else {
            this.process = new LocalNativeProcess(this.info);
        }
        return this.process.createAndStart();
    }

    public NativeProcessBuilder setWorkingDirectory(String string) {
        this.info.setWorkingDirectory(string);
        return this;
    }

    public NativeProcessBuilder addEnvironmentVariable(String string, String string2) {
        this.info.addEnvironmentVariable(string, string2);
        return this;
    }

    public NativeProcessBuilder addEnvironmentVariables(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        this.info.addEnvironmentVariables(map);
        return this;
    }

    public NativeProcessBuilder setArguments(String ... stringArray) {
        this.info.setArguments(stringArray);
        return this;
    }

    public NativeProcessBuilder useExternalTerminal(ExternalTerminal externalTerminal) {
        this.externalTerminal = externalTerminal;
        return this;
    }

    public NativeProcessBuilder unbufferOutput(boolean bl) {
        this.info.setUnbuffer(bl);
        return this;
    }

    public NativeProcessBuilder setX11Forwarding(boolean bl) {
        if (Boolean.getBoolean("cnd.remote.noX11")) {
            return this;
        }
        this.info.setX11Forwarding(bl);
        return this;
    }
}

