/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.DoxygenTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoxygenLexer
implements Lexer<DoxygenTokenId> {
    private static final int EOF = -1;
    private static final int INIT = 0;
    private static final int OTHER = 1;
    private LexerInput input;
    private int state = 0;
    private TokenFactory<DoxygenTokenId> tokenFactory;
    private static final String DOXYGEN_CONTROL_SYMBOLS = "@<.#";

    public DoxygenLexer(LexerRestartInfo<DoxygenTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.fromState((Integer)lexerRestartInfo.state());
    }

    public Object state() {
        return this.state == 0 ? null : Integer.valueOf(this.state);
    }

    private void fromState(Integer n) {
        this.state = n == null ? 0 : n;
    }

    public Token<DoxygenTokenId> nextToken() {
        int n = this.input.read();
        if (n == -1) {
            return null;
        }
        int n2 = this.state;
        this.state = 1;
        if (n2 == 0 && n == 60) {
            return this.token(DoxygenTokenId.POINTER_MARK);
        }
        if (CndLexerUtilities.isCppIdentifierStart(n)) {
            while (CndLexerUtilities.isCppIdentifierPart(this.input.read())) {
            }
            this.input.backup(1);
            return this.token(DoxygenTokenId.IDENT);
        }
        if (DOXYGEN_CONTROL_SYMBOLS.indexOf(n) == -1) {
            n = this.input.read();
            while (!CndLexerUtilities.isCppIdentifierStart(n) && DOXYGEN_CONTROL_SYMBOLS.indexOf(n) == -1 && n != -1) {
                n = this.input.read();
            }
            if (n != -1) {
                this.input.backup(1);
            }
            return this.token(DoxygenTokenId.OTHER_TEXT);
        }
        switch (n) {
            case 64: {
                while (Character.isLetter(n = this.input.read())) {
                }
                this.input.backup(1);
                return this.tokenFactory.createToken((TokenId)DoxygenTokenId.TAG, this.input.readLength());
            }
            case 60: {
                while ((n = this.input.read()) != 62 && n != -1) {
                }
                return this.token(DoxygenTokenId.HTML_TAG);
            }
            case 46: {
                return this.token(DoxygenTokenId.DOT);
            }
            case 35: {
                return this.token(DoxygenTokenId.HASH);
            }
        }
        assert (false);
        return null;
    }

    private Token<DoxygenTokenId> token(DoxygenTokenId doxygenTokenId) {
        return this.tokenFactory.createToken((TokenId)doxygenTokenId);
    }

    public void release() {
    }
}

