/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TransportToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TransportSecurity
extends ProfileBaseForm {
    private JCheckBox requireCertificateChBox;

    public TransportSecurity(WSDLComponent wSDLComponent, SecurityProfile securityProfile) {
        super(wSDLComponent, securityProfile);
        this.initComponents();
        this.sync();
    }

    protected void sync() {
        this.inSync = true;
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, TransportToken.class);
        HttpsToken httpsToken = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        if (httpsToken instanceof HttpsToken) {
            this.setChBox(this.requireCertificateChBox, SecurityTokensModelHelper.isRequireClientCertificate(httpsToken));
        }
        this.inSync = false;
    }

    protected void setValue(JComponent jComponent) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        if (jComponent.equals(this.requireCertificateChBox)) {
            WSDLComponent wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, TransportToken.class);
            HttpsToken httpsToken = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
            SecurityTokensModelHelper.setRequireClientCertificate(httpsToken, this.requireCertificateChBox.isSelected());
        }
    }

    private void initComponents() {
        this.requireCertificateChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.requireCertificateChBox, (String)NbBundle.getMessage(TransportSecurity.class, (String)"LBL_RequireClientCertificate"));
        this.requireCertificateChBox.setMargin(new Insets(0, 0, 0, 0));
        this.requireCertificateChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransportSecurity.this.requireCertificateChBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.requireCertificateChBox).addContainerGap(40, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.requireCertificateChBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void requireCertificateChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.requireCertificateChBox);
    }

    protected void enableDisable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

