/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.STSIssuedSupportingToken;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class STSIssuedSupportingTokenProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature,
AdvancedSecurityFeature {
    public int getId() {
        return 120;
    }

    public String getDisplayName() {
        return ComboConstants.PROF_STSISSUEDSUPPORTING;
    }

    public String getDescription() {
        return ComboConstants.PROF_STSISSUEDSUPPORTING_INFO;
    }

    public boolean isCurrentProfile(WSDLComponent wSDLComponent) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(wSDLComponent));
    }

    public void displayConfig(WSDLComponent wSDLComponent, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        wSDLModel.addUndoableEditListener((UndoableEditListener)undoCounter);
        STSIssuedSupportingToken sTSIssuedSupportingToken = new STSIssuedSupportingToken(wSDLComponent, this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sTSIssuedSupportingToken, this.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        wSDLModel.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    public void setServiceDefaults(WSDLComponent wSDLComponent, Project project) {
        ProprietarySecurityPolicyModelHelper.clearValidators(wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, false);
        String string = ServerUtils.getStoreLocation(project, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, string, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreType(wSDLComponent, "JKS", false, false);
        ProprietarySecurityPolicyModelHelper.setStorePassword(wSDLComponent, "changeit", false, false);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(wSDLComponent, "xws-security-server", false);
    }

    public void setClientDefaults(WSDLComponent wSDLComponent, WSDLComponent wSDLComponent2, Project project) {
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, true);
    }

    public boolean isServiceDefaultSetupUsed(WSDLComponent wSDLComponent, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        String string = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string2 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string3 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        return Util.isEqual(DefaultSettings.getDefaultPassword(project), string3) && Util.isEqual(ServerUtils.getStoreLocation(project, false, false), string2) && Util.isEqual("xws-security-server", string);
    }

    public boolean isClientDefaultSetupUsed(WSDLComponent wSDLComponent, Binding binding, Project project) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(wSDLComponent)) {
            return false;
        }
        return false;
    }

    public boolean isSecureConversation(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        return wSDLComponent3 instanceof SecureConversationToken;
    }

    public void enableSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(wSDLComponent)).setSecureConversation(wSDLComponent, bl);
    }

    public void profileSelected(WSDLComponent wSDLComponent, boolean bl, ConfigVersion configVersion) {
        ProfilesModelHelper profilesModelHelper = ProfilesModelHelper.getInstance(configVersion);
        RMModelHelper rMModelHelper = RMModelHelper.getInstance(configVersion);
        profilesModelHelper.setSecurityProfile(wSDLComponent, this.getDisplayName(), bl);
        boolean bl2 = rMModelHelper.isRMEnabled(wSDLComponent);
        if (bl2) {
            this.enableSecureConversation(wSDLComponent, true);
        }
    }
}

