/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class STSIssuedEndorsing
extends ProfileBaseForm {
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysChBox;
    private JCheckBox encryptOrderChBox;
    private JCheckBox encryptSignatureChBox;
    private JTextField issuerAddressField;
    private JLabel issuerAddressLabel;
    private JTextField issuerMetadataField;
    private JLabel issuerMetadataLabel;
    private JComboBox keySizeCombo;
    private JLabel keySizeLabel;
    private JComboBox keyTypeCombo;
    private JLabel keyTypeLabel;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqDerivedKeys;
    private JCheckBox reqDerivedKeysIssued;
    private JCheckBox reqSigConfChBox;
    private JCheckBox secConvChBox;
    private JComboBox tokenTypeCombo;
    private JLabel tokenTypeLabel;

    public STSIssuedEndorsing(WSDLComponent wSDLComponent, SecurityProfile securityProfile) {
        super(wSDLComponent, securityProfile);
        this.initComponents();
        this.inSync = true;
        this.fillLayoutCombo(this.layoutCombo);
        this.tokenTypeCombo.removeAllItems();
        this.tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML10);
        this.tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML11);
        this.tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML20);
        this.keyTypeCombo.removeAllItems();
        this.keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_SYMMETRIC);
        this.keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_PUBLIC);
        this.fillAlgoSuiteCombo(this.algoSuiteCombo);
        this.inSync = false;
        this.sync();
    }

    protected void sync() {
        Policy policy;
        WSDLComponent wSDLComponent;
        this.inSync = true;
        ExtensibilityElement extensibilityElement = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement2, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        this.setChBox(this.secConvChBox, bl);
        if (bl) {
            wSDLComponent = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
            policy = (Policy)extensibilityElement.getParent();
            this.setChBox(this.derivedKeysChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(wSDLComponent3));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation((WSDLComponent)policy));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(wSDLComponent));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(wSDLComponent));
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.derivedKeysChBox, false);
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(this.comp));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(this.comp));
        }
        wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, ProtectionToken.class);
        policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        this.setChBox(this.reqDerivedKeys, SecurityPolicyModelHelper.isRequireDerivedKeys((WSDLComponent)policy));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)extensibilityElement));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)extensibilityElement));
        wSDLComponent = bl ? SecurityTokensModelHelper.getSupportingToken((WSDLComponent)extensibilityElement.getParent(), 2) : SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
        policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        this.setChBox(this.reqDerivedKeysIssued, SecurityPolicyModelHelper.isRequireDerivedKeys((WSDLComponent)policy));
        this.setCombo(this.tokenTypeCombo, SecurityTokensModelHelper.getIssuedTokenType((WSDLComponent)policy));
        this.setCombo(this.keyTypeCombo, SecurityTokensModelHelper.getIssuedKeyType((WSDLComponent)policy));
        this.fillKeySize(this.keySizeCombo, ComboConstants.ISSUED_KEYTYPE_PUBLIC.equals(this.keyTypeCombo.getSelectedItem()));
        this.setCombo(this.keySizeCombo, SecurityTokensModelHelper.getIssuedKeySize((WSDLComponent)policy));
        this.issuerAddressField.setText(SecurityTokensModelHelper.getIssuedIssuerAddress((WSDLComponent)policy));
        this.issuerMetadataField.setText(SecurityTokensModelHelper.getIssuedIssuerMetadataAddress((WSDLComponent)policy));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent) {
        Policy policy;
        WSDLComponent wSDLComponent;
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement2, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        if (jComponent.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        SecurityPolicyModelHelper securityPolicyModelHelper = SecurityPolicyModelHelper.getInstance(this.cfgVersion);
        SecurityTokensModelHelper securityTokensModelHelper = SecurityTokensModelHelper.getInstance(this.cfgVersion);
        AlgoSuiteModelHelper algoSuiteModelHelper = AlgoSuiteModelHelper.getInstance(this.cfgVersion);
        if (bl) {
            wSDLComponent = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
            policy = (Policy)extensibilityElement.getParent();
            if (jComponent.equals(this.derivedKeysChBox)) {
                securityPolicyModelHelper.enableRequireDerivedKeys(wSDLComponent3, this.derivedKeysChBox.isSelected());
            }
            if (jComponent.equals(this.reqSigConfChBox)) {
                securityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11((WSDLComponent)policy), this.reqSigConfChBox.isSelected());
            }
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            if (jComponent.equals(this.reqSigConfChBox)) {
                securityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
        }
        wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, ProtectionToken.class);
        policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        if (jComponent.equals(this.encryptSignatureChBox)) {
            securityPolicyModelHelper.enableEncryptSignature((WSDLComponent)extensibilityElement, this.encryptSignatureChBox.isSelected());
            if (bl) {
                securityPolicyModelHelper.enableEncryptSignature((WSDLComponent)extensibilityElement2, this.encryptSignatureChBox.isSelected());
            }
        }
        if (jComponent.equals(this.encryptOrderChBox)) {
            securityPolicyModelHelper.enableEncryptBeforeSigning((WSDLComponent)extensibilityElement, this.encryptOrderChBox.isSelected());
            if (bl) {
                securityPolicyModelHelper.enableEncryptBeforeSigning((WSDLComponent)extensibilityElement2, this.encryptOrderChBox.isSelected());
            }
        }
        if (jComponent.equals(this.layoutCombo)) {
            securityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement, (String)this.layoutCombo.getSelectedItem());
            if (bl) {
                securityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement2, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.algoSuiteCombo)) {
            algoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement, (String)this.algoSuiteCombo.getSelectedItem());
            if (bl) {
                algoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement2, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.reqDerivedKeys)) {
            securityPolicyModelHelper.enableRequireDerivedKeys((WSDLComponent)policy, this.reqDerivedKeys.isSelected());
            return;
        }
        wSDLComponent = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)extensibilityElement.getParent(), 2);
        policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        if (jComponent.equals(this.reqDerivedKeysIssued)) {
            securityPolicyModelHelper.enableRequireDerivedKeys((WSDLComponent)policy, this.reqDerivedKeysIssued.isSelected());
            return;
        }
        if (jComponent.equals(this.tokenTypeCombo) || jComponent.equals(this.keyTypeCombo)) {
            this.fillKeySize(this.keySizeCombo, ComboConstants.ISSUED_KEYTYPE_PUBLIC.equals(this.keyTypeCombo.getSelectedItem()));
            if ("       ".equals(this.keySizeCombo.getSelectedItem())) {
                securityTokensModelHelper.setIssuedTokenRSTAttributes((WSDLComponent)policy, (String)this.tokenTypeCombo.getSelectedItem(), (String)this.keyTypeCombo.getSelectedItem(), null);
            } else {
                securityTokensModelHelper.setIssuedTokenRSTAttributes((WSDLComponent)policy, (String)this.tokenTypeCombo.getSelectedItem(), (String)this.keyTypeCombo.getSelectedItem(), (String)this.keySizeCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.keySizeCombo)) {
            if ("       ".equals(this.keySizeCombo.getSelectedItem())) {
                securityTokensModelHelper.setIssuedTokenRSTAttributes((WSDLComponent)policy, (String)this.tokenTypeCombo.getSelectedItem(), (String)this.keyTypeCombo.getSelectedItem(), null);
            } else {
                securityTokensModelHelper.setIssuedTokenRSTAttributes((WSDLComponent)policy, (String)this.tokenTypeCombo.getSelectedItem(), (String)this.keyTypeCombo.getSelectedItem(), (String)this.keySizeCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.issuerAddressField) || jComponent.equals(this.issuerMetadataField)) {
            securityTokensModelHelper.setIssuedTokenAddressAttributes((WSDLComponent)policy, this.issuerAddressField.getText(), this.issuerMetadataField.getText());
        }
        this.enableDisable();
    }

    protected void enableDisable() {
        boolean bl = this.secConvChBox.isSelected();
        this.derivedKeysChBox.setEnabled(bl);
    }

    private void initComponents() {
        this.secConvChBox = new JCheckBox();
        this.reqSigConfChBox = new JCheckBox();
        this.derivedKeysChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.encryptSignatureChBox = new JCheckBox();
        this.reqDerivedKeysIssued = new JCheckBox();
        this.encryptOrderChBox = new JCheckBox();
        this.issuerAddressLabel = new JLabel();
        this.issuerAddressField = new JTextField();
        this.issuerMetadataLabel = new JLabel();
        this.issuerMetadataField = new JTextField();
        this.tokenTypeLabel = new JLabel();
        this.keyTypeLabel = new JLabel();
        this.keySizeLabel = new JLabel();
        this.tokenTypeCombo = new JComboBox();
        this.keyTypeCombo = new JComboBox();
        this.keySizeCombo = new JComboBox();
        this.reqDerivedKeys = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.secConvChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.reqSigConfChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysChBox, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.derivedKeysChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.derivedKeysChBoxActionPerformed(actionEvent);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.algoSuiteComboActionPerformed(actionEvent);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.layoutComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptSignatureChBox, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_EncryptSignatureLabel"));
        this.encryptSignatureChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptSignatureChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptSignatureChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.encryptSignatureChBox(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeysIssued, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RequireDerivedKeysIssued"));
        this.reqDerivedKeysIssued.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqDerivedKeysIssued.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeysIssued.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.reqDerivedKeysIssuedActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptOrderChBox, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_EncryptOrderLabel"));
        this.encryptOrderChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptOrderChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptOrderChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.encryptOrderChBoxActionPerformed(actionEvent);
            }
        });
        this.issuerAddressLabel.setLabelFor(this.issuerAddressField);
        Mnemonics.setLocalizedText((JLabel)this.issuerAddressLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_IssuerAddress"));
        this.issuerAddressField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                STSIssuedEndorsing.this.issuerAddressFieldKeyReleased(keyEvent);
            }
        });
        this.issuerMetadataLabel.setLabelFor(this.issuerMetadataField);
        Mnemonics.setLocalizedText((JLabel)this.issuerMetadataLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_IssuerMetadataAddress"));
        this.issuerMetadataField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                STSIssuedEndorsing.this.issuerMetadataFieldKeyReleased(keyEvent);
            }
        });
        this.tokenTypeLabel.setLabelFor(this.tokenTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.tokenTypeLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RSTTokenType"));
        this.keyTypeLabel.setLabelFor(this.keyTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.keyTypeLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RSTKeyType"));
        this.keySizeLabel.setLabelFor(this.keySizeCombo);
        Mnemonics.setLocalizedText((JLabel)this.keySizeLabel, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RSTKeySize"));
        this.tokenTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.tokenTypeComboActionPerformed(actionEvent);
            }
        });
        this.keyTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.keyTypeComboActionPerformed(actionEvent);
            }
        });
        this.keySizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.keySizeComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeys, (String)NbBundle.getMessage(STSIssuedEndorsing.class, (String)"LBL_RequireDerivedKeysX509"));
        this.reqDerivedKeys.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqDerivedKeys.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeys.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                STSIssuedEndorsing.this.reqDerivedKeysActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.reqSigConfChBox).add((Component)this.secConvChBox).add((Component)this.derivedKeysChBox).add((Component)this.encryptSignatureChBox).add((Component)this.encryptOrderChBox).add((Component)this.reqDerivedKeys).add((Component)this.reqDerivedKeysIssued).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.issuerMetadataLabel).add((Component)this.layoutLabel).add((Component)this.algoSuiteLabel).add((Component)this.tokenTypeLabel).add((Component)this.keyTypeLabel).add((Component)this.keySizeLabel).add((Component)this.issuerAddressLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.tokenTypeCombo, -2, -1, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keySizeCombo, -2, -1, -2).add((Component)this.keyTypeCombo, -2, -1, -2))).add((Component)this.algoSuiteCombo, -2, -1, -2).add((Component)this.layoutCombo, -2, -1, -2).add((Component)this.issuerMetadataField, -1, 159, Short.MAX_VALUE).add((Component)this.issuerAddressField)))).addContainerGap(12, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.keySizeCombo, this.keyTypeCombo, this.layoutCombo, this.tokenTypeCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.issuerAddressLabel).add((Component)this.issuerAddressField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.issuerMetadataLabel).add((Component)this.issuerMetadataField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tokenTypeLabel).add((Component)this.tokenTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyTypeLabel).add((Component)this.keyTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keySizeLabel).add((Component)this.keySizeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.reqDerivedKeys).addPreferredGap(0).add((Component)this.reqDerivedKeysIssued).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysChBox).addPreferredGap(0).add((Component)this.reqSigConfChBox).addPreferredGap(0).add((Component)this.encryptSignatureChBox).addPreferredGap(0).add((Component)this.encryptOrderChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.keySizeCombo, this.keyTypeCombo, this.layoutCombo, this.tokenTypeCombo}, 2);
    }

    private void reqDerivedKeysActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqDerivedKeys);
    }

    private void keySizeComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.keySizeCombo);
    }

    private void keyTypeComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.keyTypeCombo);
    }

    private void tokenTypeComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.tokenTypeCombo);
    }

    private void issuerMetadataFieldKeyReleased(KeyEvent keyEvent) {
        this.setValue(this.issuerMetadataField);
    }

    private void issuerAddressFieldKeyReleased(KeyEvent keyEvent) {
        this.setValue(this.issuerAddressField);
    }

    private void encryptOrderChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.encryptOrderChBox);
    }

    private void reqDerivedKeysIssuedActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqDerivedKeysIssued);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqSigConfChBox);
    }

    private void derivedKeysChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.derivedKeysChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.secConvChBox);
    }

    private void encryptSignatureChBox(ActionEvent actionEvent) {
        this.setValue(this.encryptSignatureChBox);
    }

    private void layoutComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.algoSuiteCombo);
    }
}

