/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityChecker;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityCheckerRegistry {
    private static SecurityCheckerRegistry instance;
    private List<SecurityChecker> checkers = Collections.synchronizedList(new LinkedList());
    private static final Logger logger;

    private SecurityCheckerRegistry() {
    }

    public static SecurityCheckerRegistry getDefault() {
        if (instance == null) {
            instance = new SecurityCheckerRegistry();
        }
        return instance;
    }

    public void register(SecurityChecker securityChecker) {
        if (securityChecker != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registerChecker: " + securityChecker + ", dName: " + securityChecker.getDisplayName());
            }
            this.checkers.add(securityChecker);
        }
    }

    public void unregister(SecurityChecker securityChecker) {
        if (securityChecker != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "unregisterChecker: " + securityChecker + ", dName: " + securityChecker.getDisplayName());
            }
            this.checkers.remove(securityChecker);
        }
    }

    public Collection<SecurityChecker> getSecurityCheckers() {
        return Collections.unmodifiableList(this.checkers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNonWsitSecurityEnabled(Node node, JaxWsModel jaxWsModel) {
        Collection<SecurityChecker> collection;
        if (node != null && jaxWsModel != null && (collection = this.getSecurityCheckers()) != null && !collection.isEmpty()) {
            for (SecurityChecker securityChecker : collection) {
                boolean bl = false;
                try {
                    bl = securityChecker.isSecurityEnabled(node, jaxWsModel);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Exception from SecurityChecker: ", exception);
                }
                finally {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "securityEnabled: " + bl + ", " + securityChecker + ", dName: " + securityChecker.getDisplayName() + ", node: " + node + ", jaxwsmodel: " + jaxWsModel);
                    }
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    static {
        logger = Logger.getLogger("org.netbeans.modules.websvc.wsitconf.spi");
    }
}

