/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.palette.FormPaletteActions;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class PaletteUtils {
    private static FileObject paletteFolder;
    private static DataFolder paletteDataFolder;
    private static FileObject context;
    private static Map<Project, ProjectPaletteInfo> palettes;

    private PaletteUtils() {
    }

    static String getItemComponentDescription(PaletteItem paletteItem) {
        ClassSource classSource = paletteItem.getComponentClassSource();
        if (classSource == null || !classSource.hasEntries()) {
            String string = classSource.getClassName();
            if (string != null) {
                if (string.startsWith("javax.") || string.startsWith("java.")) {
                    return PaletteUtils.getBundleString("MSG_StandardJDKComponent");
                }
                if (string.startsWith("org.netbeans.")) {
                    return PaletteUtils.getBundleString("MSG_NetBeansComponent");
                }
            }
            return PaletteUtils.getBundleString("MSG_UnspecifiedComponent");
        }
        return NbBundle.getMessage(PaletteUtils.class, (String)"FMT_ComponentFrom", (Object)classSource.getEntries().iterator().next().getDisplayName());
    }

    public static FileObject getPaletteFolder() {
        if (paletteFolder != null) {
            return paletteFolder;
        }
        try {
            paletteFolder = FileUtil.getConfigFile((String)"FormDesignerPalette");
            if (paletteFolder == null) {
                paletteFolder = FileUtil.getConfigRoot().createFolder("FormDesignerPalette");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Palette folder not found and cannot be created.");
        }
        return paletteFolder;
    }

    public static Node getPaletteNode() {
        return PaletteUtils.getPaletteDataFolder().getNodeDelegate();
    }

    public static void showPaletteManager() {
        try {
            PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)new FormPaletteActions(), (PaletteFilter)new ClassPathFilter(null), null).showCustomizer();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public static void setContext(FileObject fileObject) {
        context = fileObject;
    }

    public static synchronized void addPaletteListener(PropertyChangeListener propertyChangeListener, FileObject fileObject) {
        ProjectPaletteInfo projectPaletteInfo = PaletteUtils.preparePalette(fileObject);
        if (projectPaletteInfo != null) {
            if (projectPaletteInfo.paletteListeners == null) {
                projectPaletteInfo.paletteListeners = new LinkedList<PropertyChangeListener>();
            }
            projectPaletteInfo.paletteListeners.add(propertyChangeListener);
            projectPaletteInfo.getPalette().addPropertyChangeListener(propertyChangeListener);
        }
    }

    public static synchronized void removePaletteListener(PropertyChangeListener propertyChangeListener, FileObject fileObject) {
        ProjectPaletteInfo projectPaletteInfo;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (projectPaletteInfo = palettes.get(project)) != null && projectPaletteInfo.paletteListeners != null) {
            projectPaletteInfo.paletteListeners.remove(propertyChangeListener);
            projectPaletteInfo.getPalette().removePropertyChangeListener(propertyChangeListener);
        }
    }

    public static Lookup getPaletteLookup(FileObject fileObject) {
        ProjectPaletteInfo projectPaletteInfo = PaletteUtils.preparePalette(fileObject);
        return projectPaletteInfo != null ? projectPaletteInfo.paletteLookup : Lookups.fixed((Object[])new Object[0]);
    }

    private static PaletteController getPalette() {
        ProjectPaletteInfo projectPaletteInfo = PaletteUtils.preparePalette(context);
        return projectPaletteInfo != null ? projectPaletteInfo.getPalette() : null;
    }

    private static ClassPathFilter getPaletteFilter() {
        ProjectPaletteInfo projectPaletteInfo;
        Project project;
        if (context != null && (project = FileOwnerQuery.getOwner((FileObject)context)) != null && (projectPaletteInfo = palettes.get(project)) != null) {
            return projectPaletteInfo.paletteFilter;
        }
        return null;
    }

    private static ProjectPaletteInfo preparePalette(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ProjectPaletteInfo projectPaletteInfo = palettes.get(project);
        if (projectPaletteInfo == null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            classPath.addPropertyChangeListener((PropertyChangeListener)new ClassPathListener(classPath, project));
            PaletteLookup paletteLookup = new PaletteLookup();
            ClassPathFilter classPathFilter = new ClassPathFilter(classPath);
            paletteLookup.setPalette(PaletteUtils.createPalette(classPathFilter));
            projectPaletteInfo = new ProjectPaletteInfo();
            projectPaletteInfo.paletteLookup = paletteLookup;
            projectPaletteInfo.paletteFilter = classPathFilter;
            palettes.put(project, projectPaletteInfo);
        }
        return projectPaletteInfo;
    }

    private static PaletteController createPalette(ClassPathFilter classPathFilter) {
        try {
            return PaletteFactory.createPalette((String)"FormDesignerPalette", (PaletteActions)new FormPaletteActions(), (PaletteFilter)classPathFilter, null);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    private static synchronized void bootClassPathChanged(Project project, ClassPath classPath) {
        ProjectPaletteInfo projectPaletteInfo = palettes.get(project);
        if (projectPaletteInfo != null) {
            PaletteLookup paletteLookup = projectPaletteInfo.paletteLookup;
            PaletteController paletteController = projectPaletteInfo.getPalette();
            paletteController.clearSelection();
            ClassPathFilter classPathFilter = new ClassPathFilter(classPath);
            PaletteController paletteController2 = PaletteUtils.createPalette(classPathFilter);
            if (projectPaletteInfo.paletteListeners != null) {
                for (PropertyChangeListener propertyChangeListener : projectPaletteInfo.paletteListeners) {
                    paletteController.removePropertyChangeListener(propertyChangeListener);
                    paletteController2.addPropertyChangeListener(propertyChangeListener);
                }
            }
            paletteLookup.setPalette(paletteController2);
            projectPaletteInfo.paletteFilter = classPathFilter;
        }
    }

    static DataFolder getPaletteDataFolder() {
        if (paletteDataFolder == null) {
            paletteDataFolder = DataFolder.findFolder((FileObject)PaletteUtils.getPaletteFolder());
        }
        return paletteDataFolder;
    }

    public static void clearPaletteSelection() {
        PaletteController paletteController = PaletteUtils.getPalette();
        if (paletteController != null) {
            paletteController.clearSelection();
        }
    }

    public static PaletteItem getSelectedItem() {
        PaletteController paletteController = PaletteUtils.getPalette();
        if (paletteController == null) {
            return null;
        }
        Lookup lookup = paletteController.getSelectedItem();
        return (PaletteItem)lookup.lookup(PaletteItem.class);
    }

    public static void selectItem(PaletteItem paletteItem) {
        if (null == paletteItem) {
            PaletteUtils.clearPaletteSelection();
        } else {
            Node node = (Node)PaletteUtils.getPalette().getRoot().lookup(Node.class);
            Node[] nodeArray = PaletteUtils.getCategoryNodes(node, true, true, true, true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node[] nodeArray2 = PaletteUtils.getItemNodes(nodeArray[i], true);
                for (int j = 0; j < nodeArray2.length; ++j) {
                    PaletteItem paletteItem2 = (PaletteItem)nodeArray2[j].getLookup().lookup(PaletteItem.class);
                    if (!paletteItem.equals(paletteItem2)) continue;
                    PaletteUtils.getPalette().setSelectedItem(nodeArray[i].getLookup(), nodeArray2[j].getLookup());
                }
            }
        }
    }

    public static Image getIconForClass(String string, int n, boolean bl) {
        Image image = null;
        for (PaletteItem paletteItem : PaletteUtils.getAllItems(bl)) {
            if (PaletteItem.TYPE_CHOOSE_BEAN.equals(paletteItem.getExplicitComponentType()) || !string.equals(paletteItem.getComponentClassName())) continue;
            Node node = paletteItem.getNode();
            image = node != null ? node.getIcon(n) : paletteItem.getIcon(n);
        }
        return image;
    }

    public static PaletteItem[] getAllItems() {
        return PaletteUtils.getAllItems(true);
    }

    public static PaletteItem[] getAllItems(boolean bl) {
        HashSet<PaletteItem> hashSet = null;
        Node[] nodeArray = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false, true, false, bl);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node[] nodeArray2 = PaletteUtils.getItemNodes(nodeArray[i], true, bl);
            for (int j = 0; j < nodeArray2.length; ++j) {
                PaletteItem paletteItem = (PaletteItem)nodeArray2[j].getLookup().lookup(PaletteItem.class);
                if (null == paletteItem) continue;
                if (null == hashSet) {
                    hashSet = new HashSet<PaletteItem>();
                }
                if (PaletteItem.TYPE_CHOOSE_BEAN.equals(paletteItem.getExplicitComponentType())) continue;
                hashSet.add(paletteItem);
            }
        }
        PaletteItem[] paletteItemArray = null != hashSet ? hashSet.toArray(new PaletteItem[hashSet.size()]) : new PaletteItem[]{};
        return paletteItemArray;
    }

    static String getBundleString(String string) {
        return NbBundle.getBundle(PaletteUtils.class).getString(string);
    }

    public static Node[] getItemNodes(Node node, boolean bl) {
        return PaletteUtils.getItemNodes(node, bl, true);
    }

    private static Node[] getItemNodes(Node node, boolean bl, boolean bl2) {
        Node[] nodeArray = node.getChildren().getNodes(bl2);
        if (!bl) {
            return nodeArray;
        }
        ClassPathFilter classPathFilter = PaletteUtils.getPaletteFilter();
        if (classPathFilter == null) {
            return nodeArray;
        }
        ArrayList<Node> arrayList = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            PaletteItem paletteItem = (PaletteItem)nodeArray[i].getCookie(PaletteItem.class);
            if (classPathFilter.isValidItem(paletteItem)) {
                if (arrayList == null) continue;
                arrayList.add(nodeArray[i]);
                continue;
            }
            if (arrayList != null) continue;
            arrayList = new ArrayList<Node>(nodeArray.length);
            for (int j = 0; j < i; ++j) {
                arrayList.add(nodeArray[j]);
            }
        }
        if (arrayList != null) {
            nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        }
        return nodeArray;
    }

    public static Node[] getCategoryNodes(Node node, boolean bl) {
        return PaletteUtils.getCategoryNodes(node, bl, bl, true, true);
    }

    private static Node[] getCategoryNodes(Node node, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            bl3 = true;
            bl2 = true;
        }
        Node[] nodeArray = node.getChildren().getNodes(bl4);
        ClassPathFilter classPathFilter = bl2 ? PaletteUtils.getPaletteFilter() : null;
        ArrayList<Node> arrayList = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!(bl && !PaletteUtils.isVisibleCategoryNode(nodeArray[i]) || bl2 && classPathFilter != null && !classPathFilter.isValidCategory(nodeArray[i]) || bl3 && !PaletteUtils.representsShowableCategory(nodeArray[i]))) {
                if (arrayList == null) continue;
                arrayList.add(nodeArray[i]);
                continue;
            }
            if (arrayList != null) continue;
            arrayList = new ArrayList<Node>(nodeArray.length);
            for (int j = 0; j < i; ++j) {
                arrayList.add(nodeArray[j]);
            }
        }
        if (arrayList != null) {
            nodeArray = new Node[arrayList.size()];
            arrayList.toArray(nodeArray);
        }
        return nodeArray;
    }

    private static boolean isVisibleCategoryNode(Node node) {
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        if (dataFolder != null) {
            Object object = node.getValue("psa_isVisible");
            if (null == object || "null".equals(object)) {
                object = dataFolder.getPrimaryFile().getAttribute("isVisible");
            }
            if (object == null) {
                object = Boolean.TRUE;
            }
            return Boolean.valueOf(object.toString());
        }
        return false;
    }

    private static boolean representsShowableCategory(Node node) {
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        return dataFolder != null && !Boolean.TRUE.equals(dataFolder.getPrimaryFile().getAttribute("isNoPaletteCategory"));
    }

    static {
        palettes = new WeakHashMap<Project, ProjectPaletteInfo>();
    }

    private static class PaletteLookup
    extends AbstractLookup {
        private InstanceContent content;

        PaletteLookup() {
            this(new InstanceContent());
        }

        private PaletteLookup(InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.content = instanceContent;
        }

        void setPalette(PaletteController paletteController) {
            this.content.set(Arrays.asList(paletteController), null);
        }
    }

    private static class ClassPathListener
    implements PropertyChangeListener {
        private ClassPath classPath;
        private WeakReference<Project> projRef;

        ClassPathListener(ClassPath classPath, Project project) {
            this.classPath = classPath;
            this.projRef = new WeakReference<Project>(project);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("roots".equals(propertyChangeEvent.getPropertyName())) {
                final Project project = (Project)this.projRef.get();
                if (project != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            PaletteUtils.bootClassPathChanged(project, ClassPathListener.this.classPath);
                        }
                    });
                } else {
                    this.classPath.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    private static class ClassPathFilter
    extends PaletteFilter {
        private ClassPath classPath;
        private Set<PaletteItem> validItems;
        private Set<PaletteItem> invalidItems;

        ClassPathFilter(ClassPath classPath) {
            if (classPath != null) {
                this.validItems = new WeakSet();
                this.invalidItems = new WeakSet();
            }
            this.classPath = classPath;
        }

        public boolean isValidCategory(Lookup lookup) {
            Node node = (Node)lookup.lookup(Node.class);
            if (!PaletteUtils.representsShowableCategory(node)) {
                return false;
            }
            return this.isValidCategory(node);
        }

        boolean isValidCategory(Node node) {
            if (this.classPath == null) {
                return true;
            }
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            if (dataFolder == null) {
                return false;
            }
            DataObject[] dataObjectArray = dataFolder.getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                PaletteItem paletteItem = (PaletteItem)dataObjectArray[i].getCookie(PaletteItem.class);
                if (paletteItem != null && !this.isValidItem(paletteItem)) continue;
                return true;
            }
            return dataObjectArray.length == 0;
        }

        public boolean isValidItem(Lookup lookup) {
            return this.isValidItem((PaletteItem)lookup.lookup(PaletteItem.class));
        }

        boolean isValidItem(PaletteItem paletteItem) {
            if (this.classPath == null) {
                return true;
            }
            if (paletteItem == null) {
                return false;
            }
            if (paletteItem.getComponentClassSource().hasEntries() || PaletteItem.TYPE_CHOOSE_BEAN.equals(paletteItem.getExplicitComponentType()) || "org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport".equals(paletteItem.getComponentClassName())) {
                return true;
            }
            if (this.validItems.contains(paletteItem)) {
                return true;
            }
            if (this.invalidItems.contains(paletteItem)) {
                return false;
            }
            String string = paletteItem.getComponentClassName().replace('.', '/').concat(".class");
            if (this.classPath.findResource(string) != null) {
                this.validItems.add(paletteItem);
                return true;
            }
            this.invalidItems.add(paletteItem);
            return false;
        }
    }

    private static class ProjectPaletteInfo {
        PaletteLookup paletteLookup;
        ClassPathFilter paletteFilter;
        List<PropertyChangeListener> paletteListeners;

        private ProjectPaletteInfo() {
        }

        PaletteController getPalette() {
            return (PaletteController)this.paletteLookup.lookup(PaletteController.class);
        }
    }
}

