/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

class CategorySelector
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();

    CategorySelector() {
        this.explorerManager.setRootContext(this.getCategoryRootNode());
        ListView listView = new ListView();
        JScrollPane jScrollPane = new JScrollPane();
        listView.setBorder(jScrollPane.getBorder());
        listView.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_CTL_PaletteCategories"));
        listView.setPopupAllowed(false);
        listView.setTraversalAllowed(false);
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)PaletteUtils.getBundleString("CTL_PaletteCategories"));
        if (listView.getViewport() != null && listView.getViewport().getView() != null) {
            jLabel.setLabelFor(listView.getViewport().getView());
        } else {
            jLabel.setLabelFor((Component)listView);
        }
        this.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_PaletteCategoriesSelector"));
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)jLabel, "North");
        this.add((Component)listView, "Center");
    }

    private Node getCategoryRootNode() {
        AbstractNode abstractNode = new AbstractNode((Children)new Children.Array());
        Node[] nodeArray = PaletteUtils.getCategoryNodes(PaletteUtils.getPaletteNode(), false);
        Node[] nodeArray2 = new Node[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray2[i] = new FilterNode(nodeArray[i], Children.LEAF);
        }
        abstractNode.getChildren().add(nodeArray2);
        this.getExplorerManager().setRootContext((Node)abstractNode);
        return abstractNode;
    }

    public static String selectCategory() {
        CategorySelector categorySelector = new CategorySelector();
        categorySelector.setBorder(new EmptyBorder(12, 12, 0, 11));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)categorySelector, PaletteUtils.getBundleString("CTL_SelectCategory_Title"), true, null);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION ? categorySelector.getSelectedCategory() : null;
    }

    String getSelectedCategory() {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        return nodeArray.length == 1 ? nodeArray[0].getName() : null;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }
}

