/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.editors.ImportImageWizard;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomIconEditor
extends JPanel {
    private IconEditor propertyEditor;
    private FileObject packageRoot;
    private FileObject selectedPackage;
    private FileObject selectedCPFile;
    private File selectedExternalFile;
    private String selectedURL;
    private static String lastDirectoryUsed;
    private boolean ignoreSetValue;
    private boolean ignoreNull;
    private boolean ignoreCombo;
    private Icon packageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/package.gif", (boolean)false);
    private JButton browseExternalButton;
    private JButton browseFileButton;
    private ButtonGroup buttonGroup1;
    private JRadioButton classPathRadio;
    private JRadioButton externalRadio;
    private JComboBox fileCombo;
    private JLabel fileLabel;
    private JButton importButton;
    private JRadioButton noIconRadio;
    private JComboBox packageCombo;
    private JLabel packageLabel;
    private JLabel previewLabel;
    private JScrollPane scrollPane;
    private JTextField urlField;
    private JLabel urlLabel;

    public CustomIconEditor(IconEditor iconEditor) {
        this.propertyEditor = iconEditor;
        this.initComponents();
        this.scrollPane.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        CustomIconEditor.setupBrowseButton(this.browseFileButton);
        CustomIconEditor.setupBrowseButton(this.browseExternalButton);
        if (!iconEditor.isExternalIconsAllowed()) {
            this.externalRadio.setEnabled(false);
            this.urlField.setEnabled(false);
            this.browseExternalButton.setEnabled(false);
        }
        this.packageCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setIcon(CustomIconEditor.this.packageIcon);
                return this;
            }
        });
        this.fileCombo.setPrototypeDisplayValue(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor_FileCombo_Select"));
        this.fileCombo.setRenderer(new IconComboRenderer());
        this.setTransferHandler(new FileDropHandler());
    }

    private static void setupBrowseButton(JButton jButton) {
        Insets insets = jButton.getMargin();
        if (insets.left > 4) {
            insets.left = 4;
            insets.right = 4;
            jButton.setMargin(insets);
        }
    }

    void setValue(IconEditor.NbImageIcon nbImageIcon) {
        if (this.ignoreSetValue || nbImageIcon == null && this.ignoreNull) {
            return;
        }
        this.selectedCPFile = null;
        this.selectedExternalFile = null;
        this.selectedURL = null;
        this.ignoreCombo = true;
        if (this.fileCombo.getItemCount() > 0) {
            this.fileCombo.setSelectedIndex(0);
        }
        this.ignoreCombo = false;
        this.urlField.setText("");
        if (nbImageIcon == null || nbImageIcon.getType() != 3) {
            FileObject fileObject = this.propertyEditor.getSourceFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            this.setPackageRoot(classPath.findOwnerRoot(fileObject));
            this.setPackage(this.propertyEditor.getDefaultResourceFolder());
        }
        if (nbImageIcon == null) {
            this.classPathRadio.setSelected(true);
            this.previewLabel.setIcon(null);
            return;
        }
        switch (nbImageIcon.getType()) {
            case 3: {
                this.setFromResourceName(nbImageIcon.getName(), true);
                this.classPathRadio.setSelected(true);
                break;
            }
            case 2: {
                this.setFromFileName(nbImageIcon.getName());
                this.externalRadio.setSelected(true);
                break;
            }
            case 1: {
                this.setFromURL(nbImageIcon.getName());
                this.externalRadio.setSelected(true);
            }
        }
        this.previewLabel.setIcon(nbImageIcon.getIcon());
    }

    private void setFromResourceName(String string, boolean bl) {
        String string2;
        FileObject fileObject;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        FileObject fileObject2 = this.propertyEditor.getSourceFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        ClassPath classPath2 = null;
        ClassPath classPath3 = classPath;
        Object object = classPath3.findResource(string);
        if (object == null && (object = (classPath3 = (classPath2 = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/execute"))).findResource(string)) != null && (fileObject = this.findSourceRoots((FileObject)object)) != null && ((FileObject[])fileObject).length != 0) {
            string2 = this.findSourceRootOf((FileObject[])fileObject, string);
            if (string2 == null) {
                object = null;
                classPath3 = classPath;
            } else {
                object = string2;
                classPath3 = ClassPath.getClassPath((FileObject)string2, (String)"classpath/source");
            }
        }
        if (object != null) {
            this.setPackageRoot(classPath3.findOwnerRoot(object));
            this.setPackage(object.getParent());
            this.setPackageFile((FileObject)object);
        } else if (bl) {
            FileObject[] fileObjectArray;
            fileObject = null;
            int n = string.lastIndexOf(47);
            if (n < 0) {
                string2 = null;
            } else {
                classPath3 = classPath;
                string2 = string.substring(0, n);
                fileObject = classPath3.findResource(string2);
                if (fileObject == null && (fileObject = (classPath3 = classPath2).findResource(string2)) != null && (fileObjectArray = this.findSourceRoots(fileObject)) != null && fileObjectArray.length > 0) {
                    FileObject fileObject3 = this.findSourceRootOf(fileObjectArray, string2);
                    if (fileObject3 == null) {
                        fileObject = null;
                        classPath3 = classPath;
                    } else {
                        fileObject = fileObject3;
                        classPath3 = ClassPath.getClassPath((FileObject)fileObject3, (String)"classpath/source");
                    }
                }
            }
            if (fileObject == null) {
                fileObject = this.propertyEditor.getDefaultResourceFolder();
            }
            if ((fileObjectArray = classPath3.findOwnerRoot(fileObject)) == null) {
                this.setPackageRoot(classPath.findOwnerRoot(fileObject2));
            } else {
                this.setPackageRoot((FileObject)fileObjectArray);
            }
            this.setPackage(fileObject);
        }
    }

    private FileObject[] findSourceRoots(FileObject fileObject) {
        try {
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.propertyEditor.getSourceFile(), (String)"classpath/execute");
            return SourceForBinaryQuery.findSourceRoots((URL)classPath.findOwnerRoot(fileObject).getURL()).getRoots();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Logger.getLogger(CustomIconEditor.class.getName()).log(Level.INFO, null, fileStateInvalidException);
            return null;
        }
    }

    private FileObject findSourceRootOf(FileObject[] fileObjectArray, String string) {
        for (FileObject fileObject : fileObjectArray) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            FileObject fileObject2 = classPath.findResource(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    private void setFromFileName(String string) {
        this.selectedExternalFile = new File(string);
        try {
            this.urlField.setText(this.selectedExternalFile.toURL().toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            this.urlField.setText("file:/" + string);
        }
    }

    private void setFromURL(String string) {
        this.selectedURL = string;
        this.urlField.setText(this.selectedURL);
    }

    private void setPackageRoot(FileObject fileObject) {
        if (fileObject != this.packageRoot) {
            this.packageCombo.setModel(CustomIconEditor.createPackageComboModel(fileObject));
            this.packageRoot = fileObject;
        }
    }

    private void setPackage(FileObject fileObject) {
        if (fileObject != this.selectedPackage) {
            this.selectedPackage = fileObject;
            this.ignoreCombo = true;
            this.packageCombo.setSelectedItem(CustomIconEditor.getPackageName(fileObject, this.packageRoot));
            this.ignoreCombo = false;
            this.fileCombo.setModel(CustomIconEditor.createFileComboModel(fileObject));
        }
    }

    private void setPackageFile(FileObject fileObject) {
        this.selectedCPFile = null;
        int n = this.fileCombo.getModel().getSize();
        for (int i = 1; i < n; ++i) {
            IconFileItem iconFileItem = (IconFileItem)this.fileCombo.getModel().getElementAt(i);
            if (!iconFileItem.file.equals(fileObject)) continue;
            this.selectedCPFile = fileObject;
            this.ignoreCombo = true;
            this.fileCombo.setSelectedIndex(i);
            this.ignoreCombo = false;
            break;
        }
    }

    private void setExternalFile(File file) {
        this.setExternalAsCPFile(file);
        this.selectedExternalFile = file;
        this.selectedURL = null;
    }

    private boolean setExternalAsCPFile(File file) {
        ClassPath classPath;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null && (classPath = ClassPath.getClassPath((FileObject)this.propertyEditor.getSourceFile(), (String)"classpath/source")).contains(fileObject)) {
            this.setPackageRoot(classPath.findOwnerRoot(fileObject));
            this.setPackage(fileObject.getParent());
            this.setPackageFile(fileObject);
            return true;
        }
        return false;
    }

    private void switchFromCPToExternal() {
        if (this.isClassPathSelected() && this.selectedCPFile != null && this.selectedExternalFile == null && this.selectedURL == null) {
            this.selectedExternalFile = FileUtil.toFile((FileObject)this.selectedCPFile);
            try {
                this.urlField.setText(this.selectedExternalFile.toURL().toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        int n = -1;
        String string = null;
        ImageIcon imageIcon = null;
        if (this.isClassPathSelected()) {
            if (this.selectedCPFile != null) {
                string = FileUtil.getRelativePath((FileObject)this.packageRoot, (FileObject)this.selectedCPFile);
                try {
                    BufferedImage bufferedImage = ImageIO.read(this.selectedCPFile.getURL());
                    if (bufferedImage != null) {
                        imageIcon = new ImageIcon(bufferedImage);
                        n = 3;
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
        } else if (this.isExternalSelected()) {
            if (this.selectedExternalFile != null) {
                string = this.selectedExternalFile.getAbsolutePath();
                try {
                    BufferedImage bufferedImage = ImageIO.read(new File(string));
                    if (bufferedImage != null) {
                        imageIcon = new ImageIcon(bufferedImage);
                        n = 2;
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, iOException);
                }
            } else if (this.selectedURL != null && !"".equals(this.selectedURL)) {
                n = 1;
                string = this.selectedURL;
                try {
                    BufferedImage bufferedImage = ImageIO.read(new URL(this.selectedURL));
                    if (bufferedImage != null) {
                        imageIcon = new ImageIcon(bufferedImage);
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
        }
        this.ignoreSetValue = true;
        try {
            this.propertyEditor.setValue(n != -1 ? new IconEditor.NbImageIcon(n, string, imageIcon) : null);
        }
        finally {
            this.ignoreSetValue = false;
        }
        this.previewLabel.setIcon(imageIcon);
    }

    private boolean isClassPathSelected() {
        return this.classPathRadio.isSelected();
    }

    private boolean isExternalSelected() {
        return this.externalRadio.isSelected();
    }

    private static ComboBoxModel createPackageComboModel(FileObject fileObject) {
        TreeSet<String> treeSet = new TreeSet<String>();
        CustomIconEditor.collectPackages(fileObject, fileObject, treeSet);
        return new DefaultComboBoxModel<String>(new Vector<String>(treeSet));
    }

    private static void collectPackages(FileObject fileObject, FileObject fileObject2, Collection<String> collection) {
        assert (fileObject.isFolder());
        boolean bl = false;
        boolean bl2 = false;
        for (FileObject fileObject3 : fileObject.getChildren()) {
            if (fileObject3.isFolder() && VisibilityQuery.getDefault().isVisible(fileObject3)) {
                CustomIconEditor.collectPackages(fileObject3, fileObject2, collection);
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2 || !bl) {
            collection.add(CustomIconEditor.getPackageName(fileObject, fileObject2));
        }
    }

    private static String getPackageName(FileObject fileObject, FileObject fileObject2) {
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        return "".equals(string) ? "<default>" : string.replace('/', '.');
    }

    private static ComboBoxModel createFileComboModel(FileObject fileObject) {
        TreeSet<IconFileItem> treeSet = new TreeSet<IconFileItem>();
        int n = 0;
        int n2 = 0;
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!IconEditor.isImageFile(fileObject2)) continue;
            IconFileItem iconFileItem = new IconFileItem(fileObject2);
            treeSet.add(iconFileItem);
            Dimension dimension = iconFileItem.getScaledSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        for (IconFileItem iconFileItem : treeSet) {
            iconFileItem.setEffectiveSize(n, n2);
        }
        Vector vector = new Vector(treeSet.size() + 1);
        vector.add(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor_FileCombo_Select"));
        vector.addAll(treeSet);
        return new DefaultComboBoxModel(vector);
    }

    private void selectClassPathFile() {
        ClassPathFileChooser classPathFileChooser = new ClassPathFileChooser(this.propertyEditor.getSourceFile(), new ClassPathFileChooser.Filter(){

            public boolean accept(FileObject fileObject) {
                return fileObject.isFolder() || IconEditor.isImageFileName(fileObject.getNameExt());
            }
        }, false, true);
        try {
            classPathFileChooser.setSelectedFile(this.selectedCPFile);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
        }
        classPathFileChooser.getDialog(NbBundle.getMessage(CustomIconEditor.class, (String)"CTL_OpenDialogName"), null).setVisible(true);
        if (classPathFileChooser.isConfirmed()) {
            this.setPackageRoot(classPathFileChooser.getSelectedPackageRoot());
            FileObject fileObject = classPathFileChooser.getSelectedFile();
            this.setPackage(fileObject.getParent());
            this.setPackageFile(fileObject);
            this.classPathRadio.setSelected(true);
            this.updateValue();
        }
    }

    private String getFileChooserDir() {
        if (lastDirectoryUsed == null && this.selectedPackage != null) {
            lastDirectoryUsed = FileUtil.toFile((FileObject)this.selectedPackage).getPath();
        }
        return lastDirectoryUsed;
    }

    private void selectExternalFile() {
        JFileChooser jFileChooser = new JFileChooser(this.getFileChooserDir());
        jFileChooser.setDialogTitle(NbBundle.getMessage(CustomIconEditor.class, (String)"CTL_OpenDialogName"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setControlButtonsAreShown(true);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || IconEditor.isImageFileName(file.getName());
            }

            public String getDescription() {
                return NbBundle.getMessage(CustomIconEditor.class, (String)"CTL_ImagesExtensionName");
            }
        });
        if (jFileChooser.showOpenDialog(this.getTopLevelAncestor()) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file != null) {
                try {
                    this.urlField.setText(file.toURL().toExternalForm());
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                }
                this.externalRadio.setSelected(true);
            }
            lastDirectoryUsed = file.getParent();
            this.setExternalFile(file);
            this.updateValue();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.previewLabel = new JLabel();
        this.classPathRadio = new JRadioButton();
        this.externalRadio = new JRadioButton();
        this.fileLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.urlLabel = new JLabel();
        this.browseExternalButton = new JButton();
        this.fileCombo = new JComboBox();
        this.packageCombo = new JComboBox();
        this.importButton = new JButton();
        this.noIconRadio = new JRadioButton();
        this.urlField = new JTextField();
        this.browseFileButton = new JButton();
        this.previewLabel.setHorizontalAlignment(0);
        this.scrollPane.setViewportView(this.previewLabel);
        this.buttonGroup1.add(this.classPathRadio);
        this.classPathRadio.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.classPathRadio.text"));
        this.classPathRadio.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.classPathRadio.toolTipText"));
        this.classPathRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classPathRadio.setMargin(new Insets(0, 0, 0, 0));
        this.classPathRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.classPathRadioActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.externalRadio);
        this.externalRadio.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.externalRadio.text"));
        this.externalRadio.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.externalRadio.toolTipText"));
        this.externalRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.externalRadio.setMargin(new Insets(0, 0, 0, 0));
        this.externalRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.externalRadioActionPerformed(actionEvent);
            }
        });
        this.fileLabel.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.fileLabel.text"));
        this.packageLabel.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.packageLabel.text"));
        this.urlLabel.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.urlLabel.text"));
        this.browseExternalButton.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseExternalButton.text"));
        this.browseExternalButton.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseExternalButton.toolTipText"));
        this.browseExternalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.browseExternalButtonActionPerformed(actionEvent);
            }
        });
        this.fileCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.fileComboActionPerformed(actionEvent);
            }
        });
        this.packageCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.packageComboActionPerformed(actionEvent);
            }
        });
        this.importButton.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.importButton.text"));
        this.importButton.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.importButton.toolTipText"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.importButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.noIconRadio);
        this.noIconRadio.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.noIconRadio.text"));
        this.noIconRadio.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.noIconRadio.toolTipText"));
        this.noIconRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noIconRadio.setMargin(new Insets(0, 0, 0, 0));
        this.noIconRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.noIconRadioActionPerformed(actionEvent);
            }
        });
        this.urlField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.urlFieldActionPerformed(actionEvent);
            }
        });
        this.browseFileButton.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseFileButton.text"));
        this.browseFileButton.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseFileButton.toolTipText"));
        this.browseFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomIconEditor.this.browseFileButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.scrollPane, -1, 421, Short.MAX_VALUE).add(1, (Component)this.classPathRadio).add(1, (Component)this.externalRadio).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileLabel).add((Component)this.packageLabel).add((Component)this.urlLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.urlField, -1, 292, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseExternalButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.fileCombo, 0, 292, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseFileButton)).add((Component)this.importButton).add((Component)this.packageCombo, 0, 345, Short.MAX_VALUE))).add(1, (Component)this.noIconRadio)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.classPathRadio).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.packageLabel).add((Component)this.packageCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileLabel).add((Component)this.fileCombo, -2, -1, -2).add((Component)this.browseFileButton)).add(11, 11, 11).add((Component)this.externalRadio).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseExternalButton).add((Component)this.urlLabel).add((Component)this.urlField, -2, -1, -2)).addPreferredGap(0).add((Component)this.importButton).add(11, 11, 11).add((Component)this.noIconRadio).add(11, 11, 11).add((Component)this.scrollPane, -1, 64, Short.MAX_VALUE)));
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        ClassPath classPath;
        FileObject fileObject;
        File[] fileArray;
        fileArray = this.selectedExternalFile != null ? (fileArray = new File[]{this.selectedExternalFile}) : null;
        FileObject fileObject2 = this.propertyEditor.getSourceFile();
        ImportImageWizard.lastDirectoryUsed = this.getFileChooserDir();
        FileObject[] fileObjectArray = new ImportImageWizard(fileArray, this.selectedPackage, fileObject2).show();
        lastDirectoryUsed = ImportImageWizard.lastDirectoryUsed;
        FileObject fileObject3 = fileObject = fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
        if (fileObject != null && (classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source")).contains(fileObject)) {
            this.setPackageRoot(classPath.findOwnerRoot(fileObject));
            this.selectedPackage = null;
            this.setPackage(fileObject.getParent());
            this.setPackageFile(fileObject);
            this.classPathRadio.setSelected(true);
            this.updateValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urlFieldActionPerformed(ActionEvent actionEvent) {
        String string = this.urlField.getText();
        if (this.selectedPackage != null) {
            this.propertyEditor.setCurrentFolder(this.selectedPackage);
        }
        this.ignoreNull = true;
        try {
            this.propertyEditor.setAsText(string);
        }
        finally {
            this.ignoreNull = false;
        }
        if (this.propertyEditor.getValue() instanceof IconEditor.NbImageIcon) {
            this.setValue((IconEditor.NbImageIcon)this.propertyEditor.getValue());
            this.switchFromCPToExternal();
        } else if (!"".equals(string.trim())) {
            this.urlField.setText(string);
            this.urlField.setSelectionStart(0);
            this.urlField.setSelectionEnd(string.length());
            Toolkit.getDefaultToolkit().beep();
        }
        this.externalRadio.setSelected(true);
    }

    private void classPathRadioActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    private void externalRadioActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    private void noIconRadioActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    private void fileComboActionPerformed(ActionEvent actionEvent) {
        if (!this.ignoreCombo) {
            Object object = this.fileCombo.getSelectedItem();
            if (object instanceof IconFileItem) {
                this.selectedCPFile = ((IconFileItem)object).file;
                this.classPathRadio.setSelected(true);
            } else {
                this.selectedCPFile = null;
            }
            this.updateValue();
        }
    }

    private void browseExternalButtonActionPerformed(ActionEvent actionEvent) {
        this.selectExternalFile();
    }

    private void browseFileButtonActionPerformed(ActionEvent actionEvent) {
        this.selectClassPathFile();
    }

    private void packageComboActionPerformed(ActionEvent actionEvent) {
        if (!this.ignoreCombo) {
            String string = this.packageCombo.getSelectedItem().toString();
            this.selectedPackage = this.packageRoot.getFileObject(string.replace('.', '/'));
            if (this.selectedPackage == null) {
                this.selectedPackage = this.packageRoot;
            }
            this.fileCombo.setModel(CustomIconEditor.createFileComboModel(this.selectedPackage));
        }
    }

    private class FileDropHandler
    extends TransferHandler {
        private FileDropHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            File file;
            if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            List list = null;
            try {
                list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return false;
            }
            if (list.size() > 0 && (file = (File)list.get(0)) != null && IconEditor.isImageFileName(file.getName())) {
                if (CustomIconEditor.this.setExternalAsCPFile(file)) {
                    CustomIconEditor.this.classPathRadio.setSelected(true);
                } else {
                    CustomIconEditor.this.selectedExternalFile = file;
                    CustomIconEditor.this.selectedURL = null;
                    CustomIconEditor.this.externalRadio.setSelected(true);
                    try {
                        CustomIconEditor.this.urlField.setText(file.toURL().toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                    }
                }
                CustomIconEditor.this.updateValue();
                return true;
            }
            return false;
        }
    }

    private class IconComboRenderer
    extends DefaultListCellRenderer {
        private IconComboRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object != null ? object.toString() : object, n, bl, bl2);
            this.setIcon(object instanceof IconFileItem ? (IconFileItem)object : null);
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Icon icon = this.getIcon();
            if (icon != null && !CustomIconEditor.this.fileCombo.isPopupVisible()) {
                this.setIcon(null);
            } else {
                icon = null;
            }
            super.paintComponent(graphics);
            if (icon != null) {
                this.setIcon(icon);
            }
        }
    }

    private static class IconFileItem
    implements Comparable,
    Icon {
        private FileObject file;
        private ImageIcon icon;
        private boolean scaled;
        private int maxW;
        private int maxH;
        private static final int MAX_W = 32;
        private static final int MAX_H = 32;
        private static final long SIZE_LIMIT = 50000L;

        IconFileItem(FileObject fileObject) {
            this.file = fileObject;
            try {
                BufferedImage bufferedImage = fileObject.getSize() < 50000L ? ImageIO.read(fileObject.getURL()) : null;
                this.icon = bufferedImage != null ? new ImageIcon(bufferedImage) : null;
            }
            catch (IOException iOException) {
                Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, iOException);
            }
        }

        public String toString() {
            return this.file.getNameExt();
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.icon == null) {
                return;
            }
            int n3 = this.icon.getIconWidth();
            int n4 = this.icon.getIconHeight();
            if (!this.scaled) {
                if (n3 > this.maxW || n4 > this.maxH) {
                    Dimension dimension = this.getScaledSize();
                    n3 = dimension.width;
                    n4 = dimension.height;
                    this.icon.setImage(this.icon.getImage().getScaledInstance(n3, n4, 2));
                }
                this.scaled = true;
            }
            this.icon.paintIcon(component, graphics, n + (this.maxW - n3) / 2, n2 + (this.maxH - n4) / 2);
        }

        public int getIconWidth() {
            return this.maxW;
        }

        public int getIconHeight() {
            return this.maxH;
        }

        Dimension getScaledSize() {
            if (this.icon == null) {
                return new Dimension(0, 0);
            }
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            if (n > 32 || n2 > 32) {
                float f = (float)n / (float)n2;
                if (n > n2) {
                    n = 32;
                    n2 = Math.round(32.0f / f);
                } else {
                    n2 = 32;
                    n = Math.round(32.0f * f);
                }
            }
            return new Dimension(n, n2);
        }

        void setEffectiveSize(int n, int n2) {
            this.maxW = n > 0 ? n : 32;
            this.maxH = n2 > 0 ? n2 : 32;
        }
    }
}

