/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties;

import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.CustomErrorMessageProvider;

public class Color
implements CssPropertyValueAcceptor,
CustomErrorMessageProvider {
    private static final String[] COLORS = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "orange", "purple", "red", "silver", "teal", "white", "yellow]", "inherit"};
    private String errorMsg = null;

    public String id() {
        return "color";
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean accepts(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (string.startsWith("#")) {
            String string2 = string.substring(1);
            if (string2.length() != 3 && string2.length() != 6) {
                this.errorMsg = "Unexpected length of hexadecimal color definition";
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= string2.length()) {
                    return true;
                }
                char c = string2.charAt(n);
                if (!(Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                    this.errorMsg = "Unexpected character '" + c + "' in haxadecimal color value";
                    return false;
                }
                ++n;
            }
        }
        int n = 0;
        while (true) {
            if (n >= COLORS.length) {
                this.errorMsg = "Invalid color name";
                return false;
            }
            if (COLORS[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
    }

    public String customErrorMessage() {
        return this.errorMsg;
    }
}

