/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.AccessorImpl;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VCSContext {
    public static final VCSContext EMPTY = new VCSContext(null, VCSContext.emptySet(), VCSContext.emptySet());
    private static Reference<VCSContext> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private final Lookup elements;
    private final Set<File> unfilteredRootFiles;
    private final Set<File> rootFiles;
    private final Set<File> exclusions;
    private Set<File> computedFilesCached;
    private FileFilter fileFilterCached;

    static VCSContext forFiles(Set<File> set) {
        return new VCSContext(null, set, VCSContext.emptySet());
    }

    public static synchronized VCSContext forNodes(Node[] nodeArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (Arrays.equals(contextNodesCached.get(), nodeArray) && (object4 = contextCached.get()) != null) {
            return object4;
        }
        object4 = new HashSet(nodeArray.length);
        HashSet<File> hashSet = new HashSet<File>(nodeArray.length);
        HashSet<File> hashSet2 = new HashSet<File>(5);
        for (int i = 0; i < nodeArray.length; ++i) {
            object3 = nodeArray[i];
            object2 = (File)object3.getLookup().lookup(File.class);
            if (object2 != null) {
                hashSet.add((File)object2);
                continue;
            }
            Project object5 = (Project)object3.getLookup().lookup(Project.class);
            if (object5 != null) {
                VCSContext.addProjectFiles(hashSet, hashSet2, object5);
                continue;
            }
            VCSContext.addFileObjects((Node)object3, hashSet);
        }
        ArrayList<File> arrayList = new ArrayList<File>(hashSet.size());
        object3 = new HashSet(2);
        for (File file : hashSet) {
            object = VersioningManager.getInstance().getOwner(file);
            if (object == null) {
                arrayList.add(file);
                continue;
            }
            object3.add(object);
        }
        if (object3.size() != 0) {
            if (object3.size() == 1) {
                for (File file : arrayList) {
                    object = hashSet2.iterator();
                    while (object.hasNext()) {
                        File file2 = (File)object.next();
                        if (!Utils.isAncestorOrEqual(file, file2)) continue;
                        object.remove();
                    }
                }
                hashSet.removeAll(arrayList);
            } else {
                hashSet2.clear();
                hashSet.clear();
            }
        }
        object2 = new VCSContext(nodeArray, hashSet, hashSet2);
        contextCached = new WeakReference<Object>(object2);
        contextNodesCached = new WeakReference<Node[]>(nodeArray);
        return object2;
    }

    public synchronized Set<File> computeFiles(FileFilter fileFilter) {
        if (this.computedFilesCached == null || fileFilter != this.fileFilterCached) {
            this.computedFilesCached = VCSContext.substract(this.rootFiles, this.exclusions, fileFilter);
            this.fileFilterCached = fileFilter;
        }
        return this.computedFilesCached;
    }

    public Lookup getElements() {
        return this.elements;
    }

    public Set<File> getFiles() {
        return this.unfilteredRootFiles;
    }

    public Set<File> getRootFiles() {
        return this.rootFiles;
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public boolean contains(File file) {
        block0: for (File file2 : this.rootFiles) {
            if (!Utils.isAncestorOrEqual(file2, file)) continue;
            for (File file3 : this.exclusions) {
                if (!Utils.isAncestorOrEqual(file3, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static void addProjectFiles(Collection<File> collection, Collection<File> collection2, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) continue;
            collection.add(file);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                try {
                    if (file2 == null || !fileObject2.isValid() || sourceGroup.contains(fileObject2) || SharabilityQuery.getSharability((File)file2) == 2) continue;
                    collection2.add(file2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger logger = Logger.getLogger(VCSContext.class.getName());
                    logger.log(Level.WARNING, "addProjectFiles: IAE");
                    logger.log(Level.WARNING, "rootFO: " + fileObject);
                    if (fileObject != sourceGroup.getRootFolder()) {
                        logger.log(Level.WARNING, "root FO has changed");
                    }
                    String string = "[";
                    for (FileObject fileObject3 : fileObjectArray) {
                        string = string + "\"" + fileObject3.getPath() + "\", ";
                    }
                    string = string + "]";
                    logger.log(Level.WARNING, "srcRootFo.getChildren(): " + string);
                    if (!fileObject2.isValid()) {
                        logger.log(Level.WARNING, fileObject2 + " does not exist ");
                    }
                    if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
                        logger.log(Level.WARNING, fileObject2 + " is not under " + fileObject);
                    }
                    logger.log(Level.WARNING, null, illegalArgumentException);
                }
            }
        }
    }

    private static void addFileObjects(Node node, Set<File> set) {
        Collection collection = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (collection.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : collection) {
                File file = FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder());
                if (file == null) continue;
                arrayList.add(new FlatFolder(file.getAbsolutePath()));
            }
        } else {
            Collection collection2 = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (collection2.size() > 0) {
                arrayList.addAll(VCSContext.toFileCollection(collection2));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<File> collection3 = VCSContext.toFileCollection(dataObject.files());
                    arrayList.addAll(collection3);
                }
            }
        }
        set.addAll(arrayList);
    }

    private static Collection<File> toFileCollection(Collection<? extends FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        for (FileObject fileObject : collection) {
            hashSet.add(FileUtil.toFile((FileObject)fileObject));
        }
        hashSet.remove(null);
        return hashSet;
    }

    private VCSContext(Node[] nodeArray, Set<File> set, Set<File> set2) {
        this.elements = nodeArray != null ? Lookups.fixed((Object[])nodeArray) : Lookups.fixed((Object[])new Node[0]);
        HashSet<File> hashSet = new HashSet<File>(set);
        HashSet<File> hashSet2 = new HashSet<File>(set2);
        this.unfilteredRootFiles = Collections.unmodifiableSet(new HashSet<File>(hashSet));
        while (this.normalize(hashSet, hashSet2)) {
        }
        this.rootFiles = Collections.unmodifiableSet(hashSet);
        this.exclusions = Collections.unmodifiableSet(hashSet2);
    }

    private boolean normalize(Set<File> set, Set<File> set2) {
        for (File file : set) {
            Iterator<File> iterator = set2.iterator();
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (!Utils.isAncestorOrEqual(file2, file)) continue;
                iterator.remove();
                this.exclusionRemoved(set2, file2, file);
                return true;
            }
        }
        this.removeDuplicates(set);
        this.removeDuplicates(set2);
        return false;
    }

    private void exclusionRemoved(Set<File> set, File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (Utils.isAncestorOrEqual(file2, file3)) continue;
            set.add(file3);
        }
    }

    private static Set<File> substract(Set<File> set, Set<File> set2, FileFilter fileFilter) {
        HashSet<File> hashSet = new HashSet<File>(set);
        HashSet<File> hashSet2 = new HashSet<File>();
        for (File file : set2) {
            assert (file != null);
            do {
                File file2 = file.getParentFile();
                if (!hashSet2.contains(file.getParentFile())) {
                    VCSContext.addSiblings(hashSet, file, fileFilter);
                    hashSet2.add(file2);
                }
                file = file2;
                hashSet.remove(file);
            } while (!set.contains(file));
        }
        hashSet.removeAll(set2);
        return hashSet;
    }

    private static void addSiblings(Set<File> set, File file, FileFilter fileFilter) {
        File[] fileArray;
        if (file.getParentFile() == null) {
            return;
        }
        for (File file2 : fileArray = file.getParentFile().listFiles()) {
            if (!fileFilter.accept(file2)) continue;
            set.add(file2);
        }
        set.remove(file);
    }

    private static final Set<File> emptySet() {
        return Collections.emptySet();
    }

    private void removeDuplicates(Set<File> set) {
        ArrayList<File> arrayList = new ArrayList<File>();
        block0: for (File file : set) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (Utils.isAncestorOrEqual(file2, file) && (file.isFile() || !VersioningSupport.isFlat(file2))) continue block0;
                if (!Utils.isAncestorOrEqual(file, file2) || !file2.isFile() && VersioningSupport.isFlat(file)) continue;
                iterator.remove();
            }
            arrayList.add(file);
        }
        set.clear();
        set.addAll(arrayList);
    }

    static {
        Accessor.VCSContextAccessor = new AccessorImpl();
    }
}

