/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.openide.util.NbBundle;

public class ClassNotFoundRule
extends PHPRule {
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "class.not.found";
    }

    public void visit(ClassDeclaration classDeclaration) {
        Identifier identifier = classDeclaration.getSuperClass();
        this.check(identifier);
    }

    public void visit(ClassInstanceCreation classInstanceCreation) {
        Expression expression = classInstanceCreation.getClassName().getName();
        this.check(expression);
    }

    private void check(Expression expression) {
        String string;
        if (expression instanceof Identifier && !"self".equalsIgnoreCase(string = ((Identifier)expression).getName()) && this.context.index.getClasses(null, string, QuerySupport.Kind.EXACT).isEmpty()) {
            this.addHint(expression);
        }
    }

    public String getDescription() {
        return NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundHintDispName");
    }

    private void addHint(ASTNode aSTNode) {
        OffsetRange offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.parserResult.getSnapshot().getSource().getFileObject(), offsetRange, null, 500);
        this.addResult(hint);
    }

    public boolean getDefaultEnabled() {
        return false;
    }
}

