/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignVariableHint
implements Rule.AstRule {
    public String getId() {
        return "assign.variable.hint";
    }

    public String getDescription() {
        return NbBundle.getMessage(AssignVariableHint.class, (String)"AssignVariableHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AssignVariableHint.class, (String)"AssignVariableHintDisplayName");
    }

    public boolean showInTasklist() {
        return false;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    void check(RuleContext ruleContext, List<Hint> list) {
        PHPParseResult pHPParseResult = (PHPParseResult)ruleContext.parserResult;
        if (pHPParseResult.getProgram() == null) {
            return;
        }
        BaseDocument baseDocument = ruleContext.doc;
        int n = ruleContext.caretOffset;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = n > 0 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)n) : -1;
            n3 = n2 != -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : -1;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        if (n2 != -1 && n3 != -1 && n > n2) {
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(baseDocument, n2, n3);
            pHPParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix introduceFix = introduceFixVisitor.getIntroduceFix();
            if (introduceFix != null) {
                list.add(new Hint((Rule)this, this.getDisplayName(), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), introduceFix.getOffsetRange(), Collections.singletonList(introduceFix), 500));
            }
        }
    }

    public Set<? extends Object> getKinds() {
        return Collections.singleton("introduce.hint");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    private static boolean isInside(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private static boolean isBefore(int n, int n2) {
        return n <= n2;
    }

    private static String firstToLower(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        return string2;
    }

    private class FunctionInvocationVariableFix
    extends IntroduceFix {
        FunctionInvocationVariableFix(BaseDocument baseDocument, FunctionInvocation functionInvocation) {
            super(baseDocument, functionInvocation);
        }

        protected String getVariableName() {
            FunctionInvocation functionInvocation = (FunctionInvocation)this.node;
            String string = CodeUtils.extractFunctionName(functionInvocation);
            return this.getVariableName(string);
        }
    }

    private class MethodInvocationVariableFix
    extends IntroduceFix {
        MethodInvocationVariableFix(BaseDocument baseDocument, MethodInvocation methodInvocation) {
            super(baseDocument, methodInvocation);
        }

        protected String getVariableName() {
            MethodInvocation methodInvocation = (MethodInvocation)this.node;
            String string = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            return this.getVariableName(string);
        }
    }

    private class StaticMethodInvocationVariableFix
    extends IntroduceFix {
        StaticMethodInvocationVariableFix(BaseDocument baseDocument, StaticMethodInvocation staticMethodInvocation) {
            super(baseDocument, staticMethodInvocation);
        }

        protected String getVariableName() {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)this.node;
            String string = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            return this.getVariableName(string);
        }
    }

    private class InstanceCreationVariableFix
    extends IntroduceFix {
        InstanceCreationVariableFix(BaseDocument baseDocument, ClassInstanceCreation classInstanceCreation) {
            super(baseDocument, classInstanceCreation);
        }

        protected String getVariableName() {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.node;
            String string = CodeUtils.extractClassName(classInstanceCreation.getClassName());
            return this.getVariableName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;
        List<Variable> variables;

        public IntroduceFix(BaseDocument baseDocument, ASTNode aSTNode) {
            this.doc = baseDocument;
            this.node = aSTNode;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public void setVariables(List<Variable> list) {
            this.variables = list;
        }

        public String getDescription() {
            return AssignVariableHint.this.getDescription();
        }

        public void implement() throws Exception {
            int n = this.getTextOffset();
            String string = this.getVariableName();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, String.format("$%s = ", string), true, 0);
            editList.apply();
            JTextComponent jTextComponent = GsfUtilities.getOpenPane();
            if (jTextComponent != null) {
                int n2 = n + 1;
                int n3 = n2 + string.length();
                jTextComponent.select(n2, n3);
            }
        }

        protected int getTextOffset() {
            return this.node.getStartOffset();
        }

        abstract String getVariableName();

        String adjustName(String string) {
            if (string == null) {
                return null;
            }
            String string2 = null;
            if (string.startsWith("get") && string.length() > 3) {
                string2 = string.substring(3);
            }
            if (string.startsWith("is") && string.length() > 2) {
                string2 = string.substring(2);
            }
            if (string2 != null) {
                return AssignVariableHint.firstToLower(string2);
            }
            return string;
        }

        String getVariableName(String string) {
            String string2 = string = (string = this.adjustName(AssignVariableHint.firstToLower(string))) != null ? string : "variable";
            int n = -1;
            boolean bl = true;
            block0: while (bl) {
                if (n != -1) {
                    string2 = String.format("%s%d", string, n);
                }
                bl = false;
                for (Variable variable : this.variables) {
                    String string3 = CodeUtils.extractVariableName(variable);
                    if (string3 == null || !variable.isDollared() || !string2.equals(string3 = string3.substring(1))) continue;
                    ++n;
                    bl = true;
                    continue block0;
                }
            }
            return string2;
        }
    }

    private class IntroduceFixVisitor
    extends DefaultVisitor {
        private int lineBegin;
        private int lineEnd;
        private BaseDocument doc;
        private IntroduceFix fix;
        private List<Variable> variables;

        IntroduceFixVisitor(BaseDocument baseDocument, int n, int n2) {
            this.doc = baseDocument;
            this.lineBegin = n;
            this.lineEnd = n2;
            this.variables = new ArrayList<Variable>();
        }

        public void scan(ASTNode aSTNode) {
            if (aSTNode != null && (AssignVariableHint.isBefore(aSTNode.getStartOffset(), this.lineEnd) || this.fix != null)) {
                super.scan(aSTNode);
            }
        }

        public void visit(ExpressionStatement expressionStatement) {
            if (AssignVariableHint.isInside(expressionStatement.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Expression expression = expressionStatement.getExpression();
                if (expression instanceof ClassInstanceCreation) {
                    this.fix = new InstanceCreationVariableFix(this.doc, (ClassInstanceCreation)expression);
                } else if (expression instanceof MethodInvocation) {
                    this.fix = new MethodInvocationVariableFix(this.doc, (MethodInvocation)expression);
                } else if (expression instanceof FunctionInvocation) {
                    this.fix = new FunctionInvocationVariableFix(this.doc, (FunctionInvocation)expression);
                } else if (expression instanceof StaticMethodInvocation) {
                    this.fix = new StaticMethodInvocationVariableFix(this.doc, (StaticMethodInvocation)expression);
                }
            }
            super.visit(expressionStatement);
        }

        public void visit(Variable variable) {
            this.variables.add(variable);
            super.visit(variable);
        }

        public IntroduceFix getIntroduceFix() {
            if (this.fix != null) {
                this.fix.setVariables(this.variables);
            }
            return this.fix;
        }
    }
}

