/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PHPSQLStatement {
    private final String generatedStatement;
    private int statementOffset;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();

    public static PHPSQLStatement computeSQLStatement(final Document document, final int n) {
        final PHPSQLStatement[] pHPSQLStatementArray = new PHPSQLStatement[]{null};
        document.render(new Runnable(){

            public void run() {
                TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(document, n);
                if (tokenSequence == null) {
                    return;
                }
                PHPSQLStatement pHPSQLStatement = new PHPSQLStatement(tokenSequence, n);
                if (pHPSQLStatement.getStatement() != null) {
                    pHPSQLStatementArray[0] = pHPSQLStatement;
                }
            }
        });
        return pHPSQLStatementArray[0];
    }

    public static boolean couldBeSQL(TokenSequence tokenSequence) {
        String string = ((Object)tokenSequence.token().text()).toString();
        if (string.startsWith("\"") || string.startsWith("'")) {
            string = string.substring(1);
        }
        return (string = string.toLowerCase().trim()).startsWith("select") || string.startsWith("insert") || string.startsWith("update") || string.startsWith("delete");
    }

    private PHPSQLStatement(TokenSequence tokenSequence, int n) {
        this.generatedStatement = this.generateSQLStatement((TokenSequence<PHPTokenId>)tokenSequence, n);
    }

    public int getStatementOffset() {
        return this.statementOffset;
    }

    public String getStatement() {
        return this.generatedStatement;
    }

    public int generatedToSourcePos(int n) {
        CodeBlockData codeBlockData = this.getCodeBlockAtGeneratedOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.generatedStart;
        int n3 = codeBlockData.sourceStart + n2;
        if (n3 <= codeBlockData.sourceEnd) {
            return n3;
        }
        return codeBlockData.sourceEnd;
    }

    public int sourceToGeneratedPos(int n) {
        CodeBlockData codeBlockData = this.getCodeBlockAtSourceOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = n - codeBlockData.sourceStart;
        int n4 = codeBlockData.generatedStart + n3;
        n2 = n4 <= codeBlockData.generatedEnd ? n4 : codeBlockData.generatedEnd;
        return n2;
    }

    private String generateSQLStatement(TokenSequence<PHPTokenId> tokenSequence, int n) {
        this.statementOffset = StringFinder.findStringBegin(tokenSequence, n);
        if (this.statementOffset < 0) {
            return null;
        }
        int n2 = StringFinder.findStringEnd(tokenSequence, n);
        if (n2 < 0) {
            return null;
        }
        if (n2 <= this.statementOffset || n < this.statementOffset || n > n2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        tokenSequence.move(this.statementOffset);
        tokenSequence.moveNext();
        if (!PHPSQLStatement.couldBeSQL(tokenSequence)) {
            return null;
        }
        do {
            String string = ((Object)tokenSequence.token().text()).toString();
            block0 : switch ((PHPTokenId)tokenSequence.token().id()) {
                case PHP_ENCAPSED_AND_WHITESPACE: {
                    bl2 = false;
                    if (bl) {
                        this.addUnknownCodeBlock(tokenSequence, stringBuffer);
                        break;
                    }
                    this.addCodeBlock(tokenSequence, string, stringBuffer);
                    break;
                }
                case PHP_CONSTANT_ENCAPSED_STRING: {
                    if (this.lastBlockIsUnknown() && !bl2) {
                        this.addUnknownCodeBlock(tokenSequence, stringBuffer);
                        break;
                    }
                    if (bl) {
                        this.addUnknownCodeBlock(tokenSequence, stringBuffer);
                        break;
                    }
                    bl2 = false;
                    if ("\"".equals(string) || "'".equals(string)) {
                        this.skip(tokenSequence);
                        break;
                    }
                    if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
                        this.addCodeBlock(tokenSequence, " " + string.substring(1, string.length() - 1) + " ", stringBuffer);
                        break;
                    }
                    if (string.startsWith("\"") || string.startsWith("'")) {
                        this.addCodeBlock(tokenSequence, " " + string.substring(1), stringBuffer);
                        break;
                    }
                    this.addCodeBlock(tokenSequence, string, stringBuffer);
                    break;
                }
                case PHP_HEREDOC_TAG: 
                case PHP_NOWDOC_TAG: {
                    bl2 = false;
                }
                case PHP_CLOSETAG: 
                case WHITESPACE: {
                    this.skip(tokenSequence);
                    break;
                }
                default: {
                    switch ((PHPTokenId)tokenSequence.token().id()) {
                        case PHP_TOKEN: {
                            if (string.equals("${") || string.equals("$")) {
                                bl = true;
                            } else if (string.equals(".")) {
                                bl2 = true;
                                this.skip(tokenSequence);
                                break block0;
                            }
                            bl2 = false;
                            break;
                        }
                        case PHP_CURLY_CLOSE: {
                            bl2 = false;
                            bl = false;
                        }
                    }
                    this.addUnknownCodeBlock(tokenSequence, stringBuffer);
                }
            }
        } while (tokenSequence.moveNext() && tokenSequence.offset() < n2);
        return stringBuffer.toString();
    }

    private boolean lastBlockIsUnknown() {
        CodeBlockData codeBlockData = this.getLastCodeBlock();
        return codeBlockData != null && codeBlockData.isUnknown;
    }

    private void addCodeBlock(TokenSequence tokenSequence, String string, StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = tokenSequence.offset();
        int n3 = n2 + tokenSequence.token().length();
        int n4 = string.length() + n;
        CodeBlockData codeBlockData = new CodeBlockData(n2, n3, n, n4, string.equals("__UNKNOWN__"));
        this.codeBlocks.add(codeBlockData);
        stringBuffer.append(string);
    }

    private void skip(TokenSequence tokenSequence) {
        CodeBlockData codeBlockData = this.getLastCodeBlock();
        if (codeBlockData != null) {
            codeBlockData.sourceEnd = tokenSequence.offset() + tokenSequence.token().length();
        } else {
            CodeBlockData codeBlockData2 = new CodeBlockData(tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length(), 0, 0, false);
            this.codeBlocks.add(codeBlockData2);
        }
    }

    private CodeBlockData getLastCodeBlock() {
        if (this.codeBlocks.size() > 0) {
            return this.codeBlocks.get(this.codeBlocks.size() - 1);
        }
        return null;
    }

    private void addUnknownCodeBlock(TokenSequence tokenSequence, StringBuffer stringBuffer) {
        CodeBlockData codeBlockData = this.getLastCodeBlock();
        if (codeBlockData != null && codeBlockData.isUnknown) {
            this.skip(tokenSequence);
        } else {
            this.addCodeBlock(tokenSequence, "__UNKNOWN__", stringBuffer);
        }
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.generatedStart > n || codeBlockData.generatedEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.sourceStart > n || codeBlockData.sourceEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringFinder {
        private StringFinder() {
        }

        static int findStringBegin(TokenSequence<PHPTokenId> tokenSequence, int n) {
            int n2 = StringFinder.findStringTerminationOffset(tokenSequence, n, StringDirection.BACKWARD);
            if (n2 == -1) {
                return -1;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return -1;
            }
            String string = ((Object)tokenSequence.token().text()).toString();
            if (string.equals("\"") || string.equals("'") || tokenSequence.token().id() == PHPTokenId.PHP_HEREDOC_TAG) {
                tokenSequence.moveNext();
            }
            return tokenSequence.offset();
        }

        static int findStringEnd(TokenSequence<PHPTokenId> tokenSequence, int n) {
            int n2 = StringFinder.findStringTerminationOffset(tokenSequence, n, StringDirection.FORWARD);
            if (n2 == -1) {
                return -1;
            }
            tokenSequence.move(n2);
            tokenSequence.movePrevious();
            String string = ((Object)tokenSequence.token().text()).toString();
            if (string.equals("\"") || string.equals("'") || tokenSequence.token().id() == PHPTokenId.PHP_HEREDOC_TAG) {
                tokenSequence.movePrevious();
            }
            return tokenSequence.offset() + tokenSequence.token().length();
        }

        /*
         * Exception decompiling
         */
        private static int findStringTerminationOffset(TokenSequence<PHPTokenId> var0, int var1_1, StringDirection var2_2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 7[CASE]], but top level block is 31[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static int getOffset(TokenSequence tokenSequence, StringDirection stringDirection) {
            if (stringDirection == StringDirection.BACKWARD) {
                return tokenSequence.offset();
            }
            return tokenSequence.offset() + tokenSequence.token().length();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum StringDirection {
            FORWARD,
            BACKWARD;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum StringState {
            STARTING,
            VARSUB_STRING,
            CONCATENATING,
            MAYBE_SUBSTRING_TERM,
            SUBSTRING_TERM;

        }
    }

    private class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;
        private boolean isUnknown;

        public CodeBlockData(int n, int n2, int n3, int n4, boolean bl) {
            this.sourceStart = n;
            this.generatedStart = n3;
            this.sourceEnd = n2;
            this.generatedEnd = n4;
            this.isUnknown = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CodeBlockData[");
            stringBuilder.append("\n  SOURCE(" + this.sourceStart + "," + this.sourceEnd + ")");
            stringBuilder.append(",\n  SQL(" + this.generatedStart + "," + this.generatedEnd + ")");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

