/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.php.editor.parser.GSFPHPError;
import org.netbeans.modules.php.editor.parser.GSFPHPParser;
import org.netbeans.modules.php.editor.parser.ParserErrorHandler;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHP5ErrorHandler
implements ParserErrorHandler {
    private static final Logger LOGGER = Logger.getLogger(PHP5ErrorHandler.class.getName());
    private final List<SyntaxError> syntaxErrors;
    private final GSFPHPParser.Context context;
    GSFPHPParser outer;

    public PHP5ErrorHandler(GSFPHPParser.Context context, GSFPHPParser gSFPHPParser) {
        this.outer = gSFPHPParser;
        this.context = context;
        this.syntaxErrors = new ArrayList<SyntaxError>();
    }

    @Override
    public void handleError(ParserErrorHandler.Type type, short[] sArray, Symbol symbol, Symbol symbol2) {
        if (type == ParserErrorHandler.Type.SYNTAX_ERROR) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Syntax error:");
                LOGGER.finest("Current [" + symbol.left + ", " + symbol.right + "](" + Utils.getASTScannerTokenName(symbol.sym) + "): " + symbol.value);
                LOGGER.finest("Previous [" + symbol2.left + ", " + symbol2.right + "] (" + Utils.getASTScannerTokenName(symbol2.sym) + "):" + symbol2.value);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Expected tokens:");
                for (int i = 0; i < sArray.length; i += 2) {
                    stringBuffer.append(" ").append(Utils.getASTScannerTokenName(sArray[i]));
                }
                LOGGER.finest(stringBuffer.toString());
            }
            this.syntaxErrors.add(new SyntaxError(sArray, symbol, symbol2));
        } else {
            String string = null;
            if (symbol != null) {
                String string2 = this.getTokenTextForm(symbol.sym);
                string = string2 != null ? "Unexpected " + string2 : "Unexpected " + Utils.getASTScannerTokenName(symbol.sym);
            }
            if (string == null) {
                string = "Parser error";
            }
            GSFPHPError gSFPHPError = new GSFPHPError(string, this.context.getSnapshot().getSource().getFileObject(), symbol.left, symbol.right, Severity.ERROR, null);
        }
    }

    public List<Error> displayFatalError() {
        FatalError fatalError = new FatalError();
        return Arrays.asList(fatalError);
    }

    public List<Error> displaySyntaxErrors(Program program) {
        ArrayList<Error> arrayList = new ArrayList<Error>();
        for (SyntaxError syntaxError : this.syntaxErrors) {
            ASTNode aSTNode = null;
            if (program != null) {
                aSTNode = org.netbeans.modules.php.editor.parser.api.Utils.getNodeAtOffset(program, ((SyntaxError)syntaxError).currentToken.left);
                if (!(aSTNode instanceof ASTError) && !((aSTNode = org.netbeans.modules.php.editor.parser.api.Utils.getNodeAtOffset(program, ((SyntaxError)syntaxError).previousToken.right)) instanceof ASTError)) {
                    aSTNode = null;
                }
                if (aSTNode != null) {
                    LOGGER.finest("ASTError [" + aSTNode.getStartOffset() + ", " + aSTNode.getEndOffset() + "]");
                } else {
                    LOGGER.finest("ASTError was not found");
                }
            }
            Error error = this.defaultSyntaxErrorHandling(syntaxError, aSTNode);
            arrayList.add(error);
        }
        return arrayList;
    }

    private Error defaultSyntaxErrorHandling(SyntaxError syntaxError, ASTNode aSTNode) {
        Object object;
        int n;
        Object object2;
        GSFPHPError gSFPHPError = null;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n2 = syntaxError.getCurrentToken().left;
        int n3 = syntaxError.getCurrentToken().right;
        if (syntaxError.getCurrentToken().sym == 0) {
            bl = true;
            string = NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_EOF");
            n2 = n3 - 1;
        } else if (syntaxError.getCurrentToken().sym == 12) {
            bl = true;
            string = "String";
            n3 = n2 + ((String)syntaxError.getCurrentToken().value).trim().length();
        } else {
            object2 = (String)syntaxError.getCurrentToken().value;
            boolean bl2 = bl = object2 != null && ((String)object2).trim().length() > 0;
            if (bl) {
                string = ((String)object2).trim();
                n3 = n2 + string.length();
            }
        }
        object2 = new ArrayList();
        for (n = 0; n < syntaxError.getExpectedTokens().length; n += 2) {
            object = this.getTokenTextForm(syntaxError.getExpectedTokens()[n]);
            if (object == null) continue;
            object2.add(object);
        }
        stringBuffer.append(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_Message"));
        stringBuffer.append(':');
        if (bl) {
            stringBuffer.append(' ').append(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_Unexpected"));
            stringBuffer.append(": ");
            stringBuffer.append(string);
        }
        if (object2.size() > 0) {
            stringBuffer.append('\n').append(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"SE_Expected"));
            stringBuffer.append(": ");
            n = 0;
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (n != 0) {
                    stringBuffer.append(", ");
                } else {
                    n = 1;
                }
                stringBuffer.append(string2);
            }
        }
        if (aSTNode != null) {
            n2 = aSTNode.getStartOffset();
            n3 = aSTNode.getEndOffset();
            String string3 = this.context.getSource().substring(n2, n3);
            int n4 = string3.length() - 1;
            while ((string3.charAt(n4) == '\n' || string3.charAt(n4) == '\r' || string3.charAt(n4) == '\t' || string3.charAt(n4) == ' ') && --n4 >= 0) {
            }
            if ((n4 = string3.lastIndexOf(10, n4)) > 0) {
                n2 = n2 + n4 + 1;
            }
        }
        gSFPHPError = new GSFPHPError(stringBuffer.toString(), this.context.getSnapshot().getSource().getFileObject(), n2, n3, Severity.ERROR, new Object[]{syntaxError});
        return gSFPHPError;
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    private String getTokenTextForm(int n) {
        String string = null;
        switch (n) {
            case 6: {
                string = "identifier";
                break;
            }
            case 8: {
                string = "variable";
                break;
            }
            case 115: {
                string = "++";
                break;
            }
            case 116: {
                string = "--";
                break;
            }
            case 99: {
                string = "===";
                break;
            }
            case 100: {
                string = "!==";
                break;
            }
            case 97: {
                string = "==";
                break;
            }
            case 98: {
                string = "!=";
                break;
            }
            case 101: {
                string = "<=+";
                break;
            }
            case 102: {
                string = ">=+";
                break;
            }
            case 79: {
                string = "+=";
                break;
            }
            case 80: {
                string = "-=";
                break;
            }
            case 81: {
                string = "*=";
                break;
            }
            case 82: {
                string = "/=";
                break;
            }
            case 83: {
                string = ".=";
                break;
            }
            case 84: {
                string = "%=";
                break;
            }
            case 88: {
                string = "<<=";
                break;
            }
            case 89: {
                string = ">>=";
                break;
            }
            case 85: {
                string = "&=";
                break;
            }
            case 86: {
                string = "|+";
                break;
            }
            case 87: {
                string = "^=";
                break;
            }
            case 92: {
                string = "||";
                break;
            }
            case 93: {
                string = "&&";
                break;
            }
            case 74: {
                string = "OR";
                break;
            }
            case 76: {
                string = "AND";
                break;
            }
            case 75: {
                string = "XOR";
                break;
            }
            case 105: {
                string = "<<";
                break;
            }
            case 106: {
                string = ">>";
                break;
            }
            case 91: {
                string = "';'";
                break;
            }
            case 139: {
                string = "':'";
                break;
            }
            case 73: {
                string = "','";
                break;
            }
            case 114: {
                string = "'.'";
                break;
            }
            case 125: {
                string = "[";
                break;
            }
            case 126: {
                string = "]";
                break;
            }
            case 137: {
                string = "(";
                break;
            }
            case 138: {
                string = ")";
                break;
            }
            case 94: {
                string = "|";
                break;
            }
            case 95: {
                string = "^";
                break;
            }
            case 96: {
                string = "&";
                break;
            }
            case 107: {
                string = "+";
                break;
            }
            case 108: {
                string = "-";
                break;
            }
            case 110: {
                string = "/";
                break;
            }
            case 109: {
                string = "*";
                break;
            }
            case 78: {
                string = "=";
                break;
            }
            case 111: {
                string = "%";
                break;
            }
            case 112: {
                string = "!";
                break;
            }
            case 113: {
                string = "~";
                break;
            }
            case 140: {
                string = "$";
                break;
            }
            case 103: {
                string = "<";
                break;
            }
            case 104: {
                string = ">";
                break;
            }
            case 90: {
                string = "?";
                break;
            }
            case 124: {
                string = "@";
                break;
            }
            case 2: {
                string = "exit";
                break;
            }
            case 33: {
                string = "function";
                break;
            }
            case 34: {
                string = "const";
                break;
            }
            case 35: {
                string = "return";
                break;
            }
            case 3: {
                string = "if";
                break;
            }
            case 129: {
                string = "elseif";
                break;
            }
            case 128: {
                string = "endif";
                break;
            }
            case 130: {
                string = "else";
                break;
            }
            case 16: {
                string = "while";
                break;
            }
            case 17: {
                string = "endwhile";
                break;
            }
            case 15: {
                string = "do";
                break;
            }
            case 18: {
                string = "for";
                break;
            }
            case 19: {
                string = "endfor";
                break;
            }
            case 20: {
                string = "foreach";
                break;
            }
            case 21: {
                string = "endforeach";
                break;
            }
            case 26: {
                string = "as";
                break;
            }
            case 27: {
                string = "switch";
                break;
            }
            case 28: {
                string = "endswitch";
                break;
            }
            case 29: {
                string = "case";
                break;
            }
            case 30: {
                string = "default";
                break;
            }
            case 31: {
                string = "break";
                break;
            }
            case 32: {
                string = "continue";
                break;
            }
            case 13: {
                string = "echo";
                break;
            }
            case 77: {
                string = "print";
                break;
            }
            case 46: {
                string = "class";
                break;
            }
            case 36: {
                string = "try";
                break;
            }
            case 37: {
                string = "catch";
                break;
            }
            case 38: {
                string = "throw";
                break;
            }
            case 24: {
                string = "instanceof";
                break;
            }
            case 47: {
                string = "interface";
                break;
            }
            case 49: {
                string = "implements";
                break;
            }
            case 132: {
                string = "abstract";
                break;
            }
            case 133: {
                string = "final";
                break;
            }
            case 134: {
                string = "private";
                break;
            }
            case 135: {
                string = "protected";
                break;
            }
            case 136: {
                string = "public";
                break;
            }
            case 48: {
                string = "extends";
                break;
            }
            case 127: {
                string = "new";
                break;
            }
            case 70: {
                string = "eval";
                break;
            }
            case 68: {
                string = "include";
                break;
            }
            case 69: {
                string = "include_once";
                break;
            }
            case 71: {
                string = "require";
                break;
            }
            case 72: {
                string = "require_once";
                break;
            }
            case 39: {
                string = "use";
                break;
            }
            case 40: {
                string = "global";
                break;
            }
            case 43: {
                string = "isset";
                break;
            }
            case 44: {
                string = "empty";
                break;
            }
            case 131: {
                string = "static";
                break;
            }
            case 42: {
                string = "unset";
                break;
            }
            case 52: {
                string = "array";
                break;
            }
            case 41: {
                string = "var";
                break;
            }
            case 22: {
                string = "declare";
                break;
            }
            case 23: {
                string = "enddeclare";
                break;
            }
            case 50: {
                string = "->";
                break;
            }
            case 65: {
                string = "::";
                break;
            }
            case 64: {
                string = "}";
                break;
            }
            case 63: {
                string = "{";
                break;
            }
            case 51: {
                string = "=>";
                break;
            }
            case 61: {
                string = "${";
            }
        }
        return string;
    }

    private class FatalError
    extends GSFPHPError {
        FatalError() {
            super(NbBundle.getMessage(PHP5ErrorHandler.class, (String)"MSG_FatalError"), PHP5ErrorHandler.this.context.getSnapshot().getSource().getFileObject(), 0, PHP5ErrorHandler.this.context.getSource().length(), Severity.ERROR, null);
        }

        public boolean isLineError() {
            return false;
        }
    }

    public static class SyntaxError {
        private final short[] expectedTokens;
        private final Symbol currentToken;
        private final Symbol previousToken;

        public SyntaxError(short[] sArray, Symbol symbol, Symbol symbol2) {
            this.expectedTokens = sArray;
            this.currentToken = symbol;
            this.previousToken = symbol2;
        }

        public Symbol getCurrentToken() {
            return this.currentToken;
        }

        public Symbol getPreviousToken() {
            return this.previousToken;
        }

        public short[] getExpectedTokens() {
            return this.expectedTokens;
        }
    }
}

