/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.options.MarkOccurencesSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesFinderImpl
extends OccurrencesFinder {
    private int offset;
    private Map<OffsetRange, ColoringAttributes> range2Attribs;

    public void setCaretPosition(int n) {
        this.offset = n;
        this.range2Attribs = new HashMap<OffsetRange, ColoringAttributes>();
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void cancel() {
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        Preferences preferences = MarkOccurencesSettings.getCurrentNode();
        if (preferences.getBoolean(MarkOccurencesSettings.ON_OFF, true)) {
            for (OffsetRange offsetRange : OccurrencesFinderImpl.compute((ParserResult)result, GsfUtilities.getLastKnownCaretOffset((Snapshot)result.getSnapshot(), (EventObject)schedulerEvent))) {
                this.range2Attribs.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
            }
        }
    }

    static Collection<OffsetRange> compute(ParserResult parserResult, int n) {
        TreeSet<OffsetRange> treeSet;
        block4: {
            OccurencesSupport occurencesSupport;
            block3: {
                treeSet = new TreeSet<OffsetRange>(new Comparator<OffsetRange>(){

                    @Override
                    public int compare(OffsetRange offsetRange, OffsetRange offsetRange2) {
                        return offsetRange.compareTo(offsetRange2);
                    }
                });
                Model model = ModelFactory.getModel(parserResult);
                occurencesSupport = model.getOccurencesSupport(n);
                Occurence occurence = occurencesSupport.getOccurence();
                if (occurence == null) break block3;
                ModelElement modelElement = occurence.getDeclaration();
                if (modelElement == null || modelElement.getPhpKind().equals((Object)PhpKind.INCLUDE)) break block4;
                Collection<Occurence> collection = occurence.getAllOccurences();
                for (Occurence occurence2 : collection) {
                    treeSet.add(occurence2.getOccurenceRange());
                }
                break block4;
            }
            CodeMarker codeMarker = occurencesSupport.getCodeMarker();
            if (codeMarker != null) {
                List<? extends CodeMarker> list = codeMarker.getAllMarkers();
                for (CodeMarker codeMarker2 : list) {
                    treeSet.add(codeMarker2.getOffsetRange());
                }
            }
        }
        return treeSet;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }
}

