/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VariableNameImpl
extends ScopeImpl
implements VariableName {
    private boolean globallyVisible;

    VariableNameImpl(IndexScope indexScope, IndexedVariable indexedVariable) {
        this((Scope)indexScope, indexedVariable.getName(), (Union2<String, FileObject>)Union2.createFirst((Object)indexedVariable.getFilenameUrl()), new OffsetRange(indexedVariable.getOffset(), indexedVariable.getOffset() + indexedVariable.getName().length()), true);
    }

    VarAssignmentImpl createElement(Scope scope, OffsetRange offsetRange, OffsetRange offsetRange2, Assignment assignment, Map<String, AssignmentImpl> map) {
        VarAssignmentImpl varAssignmentImpl = new VarAssignmentImpl(this, scope, offsetRange, offsetRange2, assignment, map);
        this.addElement(varAssignmentImpl);
        return varAssignmentImpl;
    }

    VariableNameImpl(Scope scope, Program program, Variable variable, boolean bl) {
        this(scope, VariableNameImpl.toName(variable), scope.getFile(), VariableNameImpl.toOffsetRange(variable), bl);
    }

    VariableNameImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, boolean bl) {
        super(scope, string, union2, offsetRange, PhpKind.VARIABLE);
        this.globallyVisible = bl;
    }

    static String toName(Variable variable) {
        return CodeUtils.extractVariableName(variable);
    }

    static OffsetRange toOffsetRange(Variable variable) {
        Expression expression = variable.getName();
        while (expression instanceof Variable) {
            Variable variable2;
            while (expression instanceof ArrayAccess) {
                variable2 = (ArrayAccess)expression;
                expression = ((ArrayAccess)variable2).getName();
            }
            if (!(expression instanceof Variable)) continue;
            variable2 = (Variable)expression;
            expression = variable2.getName();
        }
        return new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
    }

    public List<? extends VarAssignmentImpl> getAssignments() {
        return this.getElements();
    }

    public AssignmentImpl findAssignment(int n) {
        VarAssignmentImpl varAssignmentImpl = null;
        List<? extends VarAssignmentImpl> list = this.getAssignments();
        if (list.size() == 1) {
            varAssignmentImpl = (VarAssignmentImpl)list.iterator().next();
        } else {
            for (VarAssignmentImpl varAssignmentImpl2 : list) {
                if (!varAssignmentImpl2.getBlockRange().containsInclusive(n) || varAssignmentImpl != null && varAssignmentImpl.getOffset() > varAssignmentImpl2.getOffset() || varAssignmentImpl2.getOffset() >= n) continue;
                varAssignmentImpl = varAssignmentImpl2;
            }
        }
        return varAssignmentImpl;
    }

    @Override
    public String getNormalizedName() {
        Scope scope = this.getInScope();
        if (scope instanceof MethodScope) {
            String string = this.representsThis() ? "" : scope.getName();
            scope = scope.getInScope();
            return scope != null && !this.isGloballyVisible() ? scope.getName() + string + this.getName() : this.getName();
        }
        return scope != null && !this.isGloballyVisible() ? scope.getName() + this.getName() : this.getName();
    }

    @Override
    public Collection<? extends TypeScope> getTypes(int n) {
        List list = Collections.emptyList();
        if (this.representsThis()) {
            MethodScope methodScope = (MethodScope)this.getInScope();
            return Collections.singletonList(methodScope.getTypeScope());
        }
        AssignmentImpl assignmentImpl = this.findAssignment(n);
        return assignmentImpl != null ? assignmentImpl.getTypes() : list;
    }

    @Override
    public boolean isGloballyVisible() {
        String string = this.getName();
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        return this.globallyVisible || PredefinedSymbols.SUPERGLOBALS.contains(string);
    }

    void setGloballyVisible(boolean bl) {
        this.globallyVisible = bl;
    }

    @Override
    public boolean representsThis() {
        Scope scope = this.getInScope();
        return scope instanceof MethodScope && this.getName().equals("$this");
    }
}

