/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.PHPElement;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModelElementImpl
extends PHPElement
implements ModelElement {
    private PhpKind kind;
    private String name;
    private OffsetRange offsetRange;
    private Union2<String, FileObject> file;
    private PhpModifiers modifiers;
    private Scope inScope;

    ModelElementImpl(Scope scope, ASTNodeInfo aSTNodeInfo, PhpModifiers phpModifiers) {
        this(scope, aSTNodeInfo.getName(), scope.getFile(), aSTNodeInfo.getRange(), aSTNodeInfo.getPhpKind(), phpModifiers);
    }

    ModelElementImpl(Scope scope, IndexedElement indexedElement, PhpKind phpKind) {
        this(scope, indexedElement.getName(), (Union2<String, FileObject>)Union2.createFirst((Object)indexedElement.getFilenameUrl()), new OffsetRange(indexedElement.getOffset(), indexedElement.getOffset() + indexedElement.getName().length()), phpKind, new PhpModifiers(indexedElement.getFlags()));
    }

    ModelElementImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, PhpKind phpKind) {
        this(scope, string, union2, offsetRange, phpKind, PhpModifiers.EMPTY);
    }

    ModelElementImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, PhpKind phpKind, PhpModifiers phpModifiers) {
        if (string == null || union2 == null || phpKind == null || phpModifiers == null) {
            throw new IllegalArgumentException("null for name | fo | kind: " + string + " | " + union2 + " | " + (Object)((Object)phpKind));
        }
        assert (union2.hasFirst() || union2.hasSecond());
        this.inScope = scope;
        this.name = string;
        this.offsetRange = offsetRange;
        this.kind = phpKind;
        this.file = union2;
        this.modifiers = phpModifiers;
        if (scope instanceof ScopeImpl) {
            if (this instanceof AssignmentImpl) {
                if (scope instanceof VariableName) {
                    ((ScopeImpl)scope).addElement(this);
                }
            } else {
                ((ScopeImpl)scope).addElement(this);
            }
        }
    }

    @Override
    public final String getIn() {
        Scope scope = this.getInScope();
        return scope != null ? scope.getName() : null;
    }

    @Override
    public final Scope getInScope() {
        return this.inScope;
    }

    @Override
    @NonNull
    public final String getMimeType() {
        return super.getMimeType();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        return this.getName().toLowerCase();
    }

    @Override
    public final String getCamelCaseName() {
        return ModelElementImpl.toCamelCase(this.getName());
    }

    static String toCamelCase(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = string.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            cArray[n] = c;
            ++n;
        }
        return String.valueOf(String.valueOf(cArray, 0, n));
    }

    static boolean nameKindMatch(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    static boolean nameKindMatchForVariable(String string, QuerySupport.Kind kind, String ... stringArray) {
        return ModelElementImpl.nameKindMatch(false, string, kind, stringArray);
    }

    static boolean nameKindMatch(String string, QuerySupport.Kind kind, String ... stringArray) {
        return ModelElementImpl.nameKindMatch(true, string, kind, stringArray);
    }

    private static boolean nameKindMatch(boolean bl, String string, QuerySupport.Kind kind, String ... stringArray) {
        block8: for (String string2 : stringArray) {
            switch (kind) {
                case CAMEL_CASE: {
                    if (!ModelElementImpl.toCamelCase(string).startsWith(string2)) continue block8;
                    return true;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue block8;
                    return true;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    string = string.toLowerCase();
                }
                case REGEXP: {
                    Pattern pattern = Pattern.compile(string2);
                    if (!ModelElementImpl.nameKindMatch(pattern, string)) continue block8;
                    return true;
                }
                case EXACT: {
                    boolean bl2;
                    boolean bl3 = bl2 = bl ? string.equalsIgnoreCase(string2) : string.equals(string2);
                    if (!bl2) continue block8;
                    return true;
                }
                case PREFIX: {
                    if (!string.startsWith(string2)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public final ElementKind getKind() {
        switch (this.getPhpKind()) {
            case CLASS: {
                return ElementKind.CLASS;
            }
            case CLASS_CONSTANT: {
                return ElementKind.CONSTANT;
            }
            case CONSTANT: {
                return ElementKind.CONSTANT;
            }
            case FIELD: {
                return ElementKind.FIELD;
            }
            case FUNCTION: {
                return ElementKind.METHOD;
            }
            case IFACE: {
                return ElementKind.CLASS;
            }
            case METHOD: {
                return ElementKind.METHOD;
            }
            case VARIABLE: {
                return ElementKind.VARIABLE;
            }
        }
        return ElementKind.OTHER;
    }

    @Override
    public PhpKind getPhpKind() {
        return this.kind;
    }

    @Override
    public int getOffset() {
        return this.getNameRange().getStart();
    }

    @Override
    public Union2<String, FileObject> getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @CheckForNull
    public FileObject getFileObject() {
        FileObject fileObject = null;
        Object object = ModelElementImpl.class;
        synchronized (ModelElementImpl.class) {
            if (this.file != null) {
                fileObject = this.file.hasSecond() ? (FileObject)this.file.second() : null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (fileObject != null) return fileObject;
            assert (this.file.hasFirst());
            object = (String)this.file.first();
            fileObject = PHPIndex.getFileObject((String)object);
            Class<ModelElementImpl> clazz = ModelElementImpl.class;
            synchronized (ModelElementImpl.class) {
                if (fileObject == null) return fileObject;
                this.file = Union2.createSecond((Object)fileObject);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return fileObject;
            }
        }
    }

    @Override
    public Set<Modifier> getModifiers() {
        assert (this.modifiers != null);
        HashSet<Modifier> hashSet = new HashSet<Modifier>();
        if (this.modifiers.isPublic()) {
            hashSet.add(Modifier.PUBLIC);
        }
        if (this.modifiers.isProtected()) {
            hashSet.add(Modifier.PROTECTED);
        }
        if (this.modifiers.isPrivate()) {
            hashSet.add(Modifier.PRIVATE);
        }
        if (this.modifiers.isStatic()) {
            hashSet.add(Modifier.STATIC);
        }
        return hashSet;
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    public final boolean isScope() {
        return this instanceof ScopeImpl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPhpKind().toString()).append(" ").append(this.getName());
        return stringBuilder.toString();
    }

    @Override
    public PHPElement getPHPElement() {
        return this;
    }

    @Override
    public OffsetRange getNameRange() {
        return this.offsetRange;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ModelElementImpl modelElementImpl = (ModelElementImpl)object;
        if (this.kind != modelElementImpl.kind) {
            return false;
        }
        return this.getNormalizedName().equals(modelElementImpl.getNormalizedName());
    }

    public int hashCode() {
        int n = 3;
        n = 89 * n + (this.kind != null ? this.kind.hashCode() : 0);
        n = 89 * n + (this.getNormalizedName() != null ? this.getNormalizedName().hashCode() : 0);
        return n;
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult parserResult) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

