/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldElementImpl
extends ScopeImpl
implements FieldElement {
    private String returnType;
    private String className;

    FieldElementImpl(Scope scope, String string, SingleFieldDeclarationInfo singleFieldDeclarationInfo) {
        super(scope, singleFieldDeclarationInfo, singleFieldDeclarationInfo.getAccessModifiers(), null);
        this.returnType = string;
        assert (scope instanceof TypeScope);
        this.className = scope.getName();
    }

    FieldElementImpl(Scope scope, String string, PhpDocTypeTagInfo phpDocTypeTagInfo) {
        super(scope, phpDocTypeTagInfo, phpDocTypeTagInfo.getAccessModifiers(), null);
        this.returnType = string;
        assert (scope instanceof TypeScope);
        this.className = scope.getName();
    }

    FieldElementImpl(Scope scope, IndexedConstant indexedConstant) {
        super(scope, indexedConstant, PhpKind.FIELD);
        String string = indexedConstant.getIn();
        this.className = string != null ? string : scope.getName();
    }

    private FieldElementImpl(Scope scope, String string, Union2<String, FileObject> union2, OffsetRange offsetRange, PhpModifiers phpModifiers, String string2) {
        super(scope, string, union2, offsetRange, PhpKind.FIELD, phpModifiers);
        this.returnType = string2;
    }

    static String toName(SingleFieldDeclaration singleFieldDeclaration) {
        return VariableNameImpl.toName(singleFieldDeclaration.getName());
    }

    static OffsetRange toOffsetRange(SingleFieldDeclaration singleFieldDeclaration) {
        return VariableNameImpl.toOffsetRange(singleFieldDeclaration.getName());
    }

    static PhpModifiers toAccessModifiers(FieldsDeclaration fieldsDeclaration) {
        return new PhpModifiers(fieldsDeclaration.getModifier());
    }

    public Collection<? extends TypeScope> getReturnTypes() {
        return this.returnType != null && this.returnType.length() > 0 ? CachingSupport.getTypes(this.returnType.split("\\|")[0], this) : Collections.emptyList();
    }

    @Override
    public String getNormalizedName() {
        return this.className + super.getNormalizedName();
    }

    @Override
    public Collection<? extends TypeScope> getTypes(int n) {
        AssignmentImpl assignmentImpl = this.findAssignment(n);
        return assignmentImpl != null ? assignmentImpl.getTypes() : this.getReturnTypes();
    }

    public Collection<? extends FieldAssignmentImpl> getAssignments() {
        return FieldElementImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return true;
            }
        });
    }

    public AssignmentImpl findAssignment(int n) {
        FieldAssignmentImpl fieldAssignmentImpl = null;
        Collection<? extends FieldAssignmentImpl> collection = this.getAssignments();
        if (collection.size() == 1) {
            fieldAssignmentImpl = collection.iterator().next();
        } else {
            for (FieldAssignmentImpl fieldAssignmentImpl2 : collection) {
                if (!fieldAssignmentImpl2.getBlockRange().containsInclusive(n) || fieldAssignmentImpl != null && fieldAssignmentImpl.getOffset() > fieldAssignmentImpl2.getOffset() || fieldAssignmentImpl2.getOffset() >= n) continue;
                fieldAssignmentImpl = fieldAssignmentImpl2;
            }
        }
        return fieldAssignmentImpl;
    }
}

