/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassScopeImpl
extends TypeScopeImpl
implements ClassScope {
    private Union2<String, List<ClassScopeImpl>> superClass;

    @Override
    void addElement(ModelElementImpl modelElementImpl) {
        assert (modelElementImpl instanceof MethodScope || modelElementImpl instanceof FieldElement || modelElementImpl instanceof ClassConstantElement) : modelElementImpl.getPhpKind();
        super.addElement(modelElementImpl);
    }

    ClassScopeImpl(Scope scope, ClassDeclarationInfo classDeclarationInfo) {
        super(scope, classDeclarationInfo);
        Identifier identifier = classDeclarationInfo.getSuperClass();
        String string = identifier != null ? identifier.getName() : null;
        this.superClass = Union2.createFirst((Object)string);
    }

    ClassScopeImpl(IndexScope indexScope, IndexedClass indexedClass) {
        super((Scope)indexScope, indexedClass);
        this.superClass = Union2.createFirst((Object)indexedClass.getSuperClass());
    }

    @NonNull
    public List<? extends ClassScope> getSuperClasses() {
        List<Object> list = null;
        List<Object> list2 = list = this.superClass.hasSecond() ? (List)this.superClass.second() : null;
        if (list == null) {
            assert (this.superClass.hasFirst());
            String string = (String)this.superClass.first();
            if (string != null) {
                list = CachingSupport.getClasses(string, this);
                assert (list != null);
            }
        }
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public String toString() {
        Collection collection;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        Collection collection2 = this.getSuperClasses();
        ClassScope classScope = (ClassScope)ModelUtils.getFirst(collection2);
        if (classScope != null) {
            stringBuilder.append(" extends ").append(classScope.getName());
        }
        if ((collection = this.getSuperInterfaces()).size() > 0) {
            stringBuilder.append(" implements ");
            for (InterfaceScope interfaceScope : collection) {
                stringBuilder.append(interfaceScope.getName()).append(" ");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Collection<? extends FieldElement> getDeclaredFields() {
        return this.findDeclaredFields(new int[0]);
    }

    @Override
    public Collection<? extends FieldElement> findDeclaredFields(final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            return indexScope.findFields((ClassScope)this, nArray);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.FIELD) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends FieldElement> findDeclaredFields(final String string, final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            return indexScope.findFields((ClassScope)this, string, nArray);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.FIELD) && ModelElementImpl.nameKindMatch(modelElement.getName(), QuerySupport.Kind.EXACT, string) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends FieldElement> findDeclaredFields(final QuerySupport.Kind kind, final String string, final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            return indexScopeImpl.findFields(kind, this, string, nArray);
        }
        return ClassScopeImpl.filter(null, new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.FIELD) && ModelElementImpl.nameKindMatch(modelElement.getName(), kind, string) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        HashSet<? extends MethodScope> hashSet = new HashSet<MethodScope>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        PHPIndex pHPIndex = indexScope.getIndex();
        ClassScope classScope = (ClassScope)ModelUtils.getFirst(this.getSuperClasses());
        ArrayList<? extends InterfaceScope> arrayList = new ArrayList<InterfaceScope>();
        arrayList.addAll(this.getSuperInterfaces());
        while (classScope != null) {
            Collection<IndexedFunction> collection = pHPIndex.getMethods(null, classScope.getName(), "", QuerySupport.Kind.PREFIX, 5);
            Iterator object = collection.iterator();
            while (object.hasNext()) {
                IndexedFunction indexedFunction = (IndexedFunction)object.next();
                hashSet.add(new MethodScopeImpl((Scope)((ClassScopeImpl)classScope), indexedFunction, PhpKind.METHOD));
            }
            arrayList.addAll(classScope.getSuperInterfaces());
            classScope = ModelUtils.getFirst(classScope.getSuperClasses());
        }
        for (InterfaceScope interfaceScope : arrayList) {
            hashSet.addAll(interfaceScope.getMethods());
        }
        return hashSet;
    }

    @Override
    public Collection<? extends MethodScope> getMethods() {
        HashSet<MethodScope> hashSet = new HashSet<MethodScope>();
        hashSet.addAll(this.getDeclaredMethods());
        hashSet.addAll(this.getInheritedMethods());
        return hashSet;
    }

    public List<? extends FieldElement> getFields() {
        ArrayList<? extends FieldElement> arrayList = new ArrayList<FieldElement>();
        arrayList.addAll(this.getDeclaredFields());
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        PHPIndex pHPIndex = indexScope.getIndex();
        ClassScope classScope = (ClassScope)ModelUtils.getFirst(this.getSuperClasses());
        while (classScope != null) {
            Collection<IndexedConstant> collection = pHPIndex.getFields(null, classScope.getName(), "", QuerySupport.Kind.PREFIX, 5);
            for (IndexedConstant indexedConstant : collection) {
                arrayList.add(new FieldElementImpl((ClassScopeImpl)classScope, indexedConstant));
            }
            classScope = ModelUtils.getFirst(classScope.getSuperClasses());
        }
        return arrayList;
    }

    public List<? extends FieldElement> findInheritedFields(String string) {
        assert (string.startsWith("$"));
        ArrayList<? extends FieldElement> arrayList = new ArrayList<FieldElement>();
        arrayList.addAll(this.findDeclaredFields(string, new int[0]));
        if (arrayList.isEmpty()) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            PHPIndex pHPIndex = indexScope.getIndex();
            ClassScope classScope = this;
            while (classScope != null && arrayList.isEmpty()) {
                if ((classScope = ModelUtils.getFirst(classScope.getSuperClasses())) == null) continue;
                String string2 = string.startsWith("$") ? string.substring(1) : string;
                Collection<IndexedConstant> collection = pHPIndex.getFields(null, classScope.getName(), string2, QuerySupport.Kind.PREFIX, 5);
                for (IndexedConstant indexedConstant : collection) {
                    arrayList.add(new FieldElementImpl((ClassScopeImpl)classScope, indexedConstant));
                }
            }
        }
        return arrayList;
    }

    public List<? extends ClassScope> getSuperClassesChain() {
        HashSet<ClassScope> hashSet = new HashSet<ClassScope>();
        return new ArrayList<ClassScope>(ClassScopeImpl.collectSuperClassesChain(hashSet, this));
    }

    private static Set<ClassScope> collectSuperClassesChain(Set<ClassScope> set, ClassScope classScope) {
        set.add(classScope);
        Collection<? extends ClassScope> collection = classScope.getSuperClasses();
        for (ClassScope classScope2 : collection) {
            ClassScopeImpl.collectSuperClassesChain(set, classScope2);
        }
        return set;
    }

    @Override
    public String getNormalizedName() {
        return super.getNormalizedName() + this.getSuperClassName();
    }

    @NonNull
    String getSuperClassName() {
        ClassScope classScope;
        List list = null;
        List list2 = list = this.superClass.hasSecond() ? (List)this.superClass.second() : null;
        if (list == null) {
            assert (this.superClass.hasFirst());
            String string = (String)this.superClass.first();
            if (string != null) {
                return string;
            }
        } else if (list.size() > 0 && (classScope = (ClassScope)ModelUtils.getFirst(list)) != null) {
            return classScope.getName();
        }
        return "";
    }
}

