/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterInfoSupport {
    private ModelVisitor modelVisitor;
    private Document document;
    private int offset;
    private static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE);

    ParameterInfoSupport(ModelVisitor modelVisitor, Document document, int n) {
        this.modelVisitor = modelVisitor;
        this.document = document;
        this.offset = n;
    }

    public ParameterInfo getParameterInfo() {
        ParameterInfo parameterInfo = ParameterInfoSupport.parametersNodeImpl(this.offset, this.modelVisitor.getCompilationInfo());
        if (parameterInfo == ParameterInfo.NONE) {
            parameterInfo = this.parametersTokenImpl();
        }
        return parameterInfo;
    }

    private ParameterInfo parametersTokenImpl() {
        ModelElement modelElement;
        Object object;
        String string;
        FileScope fileScope = this.modelVisitor.getModelScope();
        VariableScope variableScope = this.modelVisitor.getNearestVariableScope(this.offset);
        if (fileScope == null || variableScope == null) {
            return ParameterInfo.NONE;
        }
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(this.document, this.offset);
        if (ParameterInfoSupport.moveToOffset(tokenSequence, this.offset)) {
            return ParameterInfo.NONE;
        }
        int n = 0;
        int n2 = -1;
        State state = State.PARAMS;
        int n3 = 0;
        int n4 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && tokenSequence.movePrevious() && ParameterInfoSupport.skipWhitespaces(tokenSequence)) {
            string = tokenSequence.token();
            if (!CTX_DELIMITERS.contains(string.id())) {
                switch (state) {
                    case METHOD: 
                    case START: {
                        State state2 = state = state.equals((Object)State.METHOD) ? State.STOP : State.INVALID;
                        if (ParameterInfoSupport.isReference((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, "@mtd:");
                            state = State.REFERENCE;
                            break;
                        }
                        if (ParameterInfoSupport.isStaticReference((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, "@mtd:");
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        if (!state.equals((Object)State.STOP)) break;
                        stringBuilder.insert(0, "@fn:");
                        break;
                    }
                    case REFERENCE: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isRightBracket((Token<PHPTokenId>)string)) {
                            ++n4;
                            state = State.PARAMS;
                            break;
                        }
                        if (ParameterInfoSupport.isString((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, ((Object)string.text()).toString());
                            state = State.FIELD;
                            break;
                        }
                        if (!ParameterInfoSupport.isVariable((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, ((Object)string.text()).toString());
                        state = State.VARBASE;
                        break;
                    }
                    case STATIC_REFERENCE: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isString((Token<PHPTokenId>)string)) {
                            stringBuilder.insert(0, ((Object)string.text()).toString());
                            state = State.CLASSNAME;
                            break;
                        }
                        if (!ParameterInfoSupport.isSelf((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, ParameterInfoSupport.buildStaticClassName(variableScope, ((Object)string.text()).toString()));
                        state = State.CLASSNAME;
                        break;
                    }
                    case PARAMS: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isWhiteSpace((Token<PHPTokenId>)string)) {
                            state = State.PARAMS;
                        } else if (ParameterInfoSupport.isComma((Token<PHPTokenId>)string)) {
                            if (stringBuilder.length() == 0) {
                                ++n;
                            }
                            state = State.PARAMS;
                        } else if (ParameterInfoSupport.isVariable((Token<PHPTokenId>)string)) {
                            state = State.PARAMS;
                        } else if (CTX_DELIMITERS.contains(string.id())) {
                            state = State.INVALID;
                        } else if (ParameterInfoSupport.isLeftBracket((Token<PHPTokenId>)string)) {
                            ++n3;
                        } else if (ParameterInfoSupport.isRightBracket((Token<PHPTokenId>)string)) {
                            ++n4;
                        }
                        if (n3 != n4) break;
                        state = State.FUNCTION;
                        break;
                    }
                    case FUNCTION: {
                        state = State.INVALID;
                        if (!ParameterInfoSupport.isString((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, ((Object)string.text()).toString());
                        if (n2 == -1) {
                            n2 = tokenSequence.offset();
                        }
                        state = State.METHOD;
                        break;
                    }
                    case FIELD: {
                        state = State.INVALID;
                        if (!ParameterInfoSupport.isReference((Token<PHPTokenId>)string)) break;
                        stringBuilder.insert(0, "@fld:");
                        state = State.REFERENCE;
                        break;
                    }
                    case VARBASE: {
                        state = State.INVALID;
                        if (ParameterInfoSupport.isStaticReference((Token<PHPTokenId>)string)) {
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        state = State.VARIABLE;
                    }
                    case VARIABLE: {
                        stringBuilder.insert(0, "@var:");
                    }
                    case CLASSNAME: {
                        state = State.STOP;
                    }
                }
                continue;
            }
            if (!state.equals((Object)State.METHOD)) continue;
            state = State.STOP;
            object = (PHPTokenId)string.id();
            if (object != null && PHPTokenId.PHP_NEW.equals(object)) {
                stringBuilder.insert(0, "@constuct:");
                break;
            }
            stringBuilder.insert(0, "@fn:");
            break;
        }
        if (state.equals((Object)State.STOP) && !(object = VariousUtils.getElemenst(fileScope, variableScope, string = stringBuilder.toString(), this.offset)).isEmpty() && (modelElement = object.peek()) instanceof FunctionScope) {
            return new ParameterInfo(ParameterInfoSupport.toParamNames((FunctionScope)modelElement), n, this.offset);
        }
        return ParameterInfo.NONE;
    }

    private static String buildStaticClassName(Scope scope, String string) {
        if (scope instanceof MethodScope) {
            ClassScope classScope;
            MethodScope methodScope = (MethodScope)scope;
            ClassScope classScope2 = (ClassScope)methodScope.getInScope();
            if ("self".equals(string)) {
                string = classScope2.getName();
            } else if ("parent".equals(string) && (classScope = ModelUtils.getFirst(classScope2.getSuperClasses())) != null) {
                string = classScope.getName();
            }
        }
        return string;
    }

    private static boolean skipWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && ParameterInfoSupport.isWhiteSpace((Token<PHPTokenId>)token)) {
            boolean bl = tokenSequence.movePrevious();
            token = tokenSequence.token();
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int n) {
        return tokenSequence == null || tokenSequence.move(n) < 0;
    }

    private static boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "$".contentEquals(token.text());
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ",".contentEquals(token.text());
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR);
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private static boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    private static ParameterInfo parametersNodeImpl(final int n, final ParserResult parserResult) {
        final ParameterInfo[] parameterInfoArray = new ParameterInfo[1];
        DefaultVisitor defaultVisitor = new DefaultVisitor(){

            @Override
            public void scan(ASTNode aSTNode) {
                OffsetRange offsetRange;
                if (aSTNode != null && parameterInfoArray[0] == null && (offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset())).containsInclusive(n)) {
                    super.scan(aSTNode);
                }
            }

            @Override
            public void visit(ClassInstanceCreation classInstanceCreation) {
                if (parameterInfoArray[0] == null) {
                    ASTNodeInfo<ClassInstanceCreation> aSTNodeInfo = ASTNodeInfo.create(classInstanceCreation);
                    parameterInfoArray[0] = this.createParameterInfo(aSTNodeInfo, classInstanceCreation.ctorParams());
                    super.visit(classInstanceCreation);
                }
            }

            @Override
            public void visit(FunctionInvocation functionInvocation) {
                if (parameterInfoArray[0] == null) {
                    ASTNodeInfo<FunctionInvocation> aSTNodeInfo = ASTNodeInfo.create(functionInvocation);
                    parameterInfoArray[0] = this.createParameterInfo(aSTNodeInfo, functionInvocation.getParameters());
                    super.visit(functionInvocation);
                }
            }

            private ParameterInfo createParameterInfo(ASTNodeInfo aSTNodeInfo, List<Expression> list) {
                int n3 = -1;
                Object t = aSTNodeInfo.getOriginalNode();
                int n2 = aSTNodeInfo.getRange().getEnd();
                OffsetRange offsetRange = new OffsetRange(n2, ((ASTNode)t).getEndOffset());
                if (offsetRange.containsInclusive(n)) {
                    ModelElement modelElement;
                    Object object;
                    n3 = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        object = list.get(i);
                        offsetRange = new OffsetRange(((ASTNode)object).getStartOffset(), ((ASTNode)object).getEndOffset());
                        if (offsetRange.containsInclusive(n)) {
                            n3 = i;
                            continue;
                        }
                        offsetRange = new OffsetRange(((ASTNode)object).getEndOffset(), ((ASTNode)t).getEndOffset());
                        if (!offsetRange.containsInclusive(n)) continue;
                        n3 = i + 1;
                    }
                    Model model = ModelFactory.getModel(parserResult);
                    object = model.getOccurencesSupport((aSTNodeInfo.getRange().getStart() + n2) / 2);
                    Occurence occurence = ((OccurencesSupport)object).getOccurence();
                    if (occurence != null && (modelElement = occurence.getDeclaration()) instanceof FunctionScope && occurence.getAllDeclarations().size() == 1) {
                        FunctionScope functionScope = (FunctionScope)modelElement;
                        return new ParameterInfo(ParameterInfoSupport.toParamNames(functionScope), n3, n2);
                    }
                }
                return null;
            }
        };
        Program program = Utils.getRoot(parserResult);
        if (program != null) {
            defaultVisitor.scan(program);
            if (parameterInfoArray[0] != null) {
                return parameterInfoArray[0];
            }
        }
        return ParameterInfo.NONE;
    }

    @CheckForNull
    private static List<String> toParamNames(FunctionScope functionScope) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<? extends Parameter> list = functionScope.getParameters();
        for (Parameter parameter : list) {
            if (parameter.isMandatory()) {
                arrayList.add(parameter.getName());
                continue;
            }
            arrayList.add(parameter.getName() + "=" + parameter.getDefaultValue());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START,
        METHOD,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        REFERENCE,
        STATIC_REFERENCE,
        FUNCTION,
        FIELD,
        VARIABLE,
        CLASSNAME,
        STOP;

    }
}

