/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    private ModelUtils() {
    }

    @NonNull
    public static Collection<? extends TypeScope> typeOfVariableBase(Model model, VariableBase variableBase) {
        String string;
        List<Object> list = Collections.emptyList();
        VariableScope variableScope = model.getVariableScope(variableBase.getStartOffset());
        if (variableScope != null && (string = VariousUtils.extractTypeFroVariableBase(variableBase)) != null) {
            FileScope fileScope = ModelUtils.getFileScope(variableScope);
            list = VariousUtils.getType(fileScope, variableScope, string, variableBase.getStartOffset(), true);
        }
        return list;
    }

    @CheckForNull
    public static <T extends ModelElement> T getFirst(Collection<? extends T> collection) {
        if (collection instanceof List) {
            return (T)(collection.size() > 0 ? (ModelElement)((List)collection).get(0) : null);
        }
        return (T)(collection.size() > 0 ? (ModelElement)collection.iterator().next() : null);
    }

    @CheckForNull
    public static <T extends Occurence> T getFirst(Collection<? extends T> collection) {
        if (collection instanceof List) {
            return (T)(collection.size() > 0 ? (Occurence)((List)collection).get(0) : null);
        }
        return (T)(collection.size() > 0 ? (Occurence)collection.iterator().next() : null);
    }

    @CheckForNull
    public static <T extends ModelElement> T getLast(List<? extends T> list) {
        return (T)(list.size() > 0 ? (ModelElement)list.get(list.size() - 1) : null);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> collection, String ... stringArray) {
        return ModelUtils.filter(collection, QuerySupport.Kind.EXACT, stringArray);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> collection, final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(collection, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T t) {
                return stringArray.length == 0 || ModelUtils.nameKindMatch(t.getName(), kind, stringArray);
            }
        });
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<? extends T> collection, FileObject fileObject) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : collection) {
            if (modelElement.getFileObject() != fileObject) continue;
            arrayList.add(modelElement);
        }
        return arrayList;
    }

    @NonNull
    public static <T extends ModelElement> T getFirst(Collection<T> collection, String ... stringArray) {
        return ModelUtils.getFirst(ModelUtils.filter(collection, QuerySupport.Kind.EXACT, stringArray));
    }

    @NonNull
    public static <T extends ModelElement> T getFirst(Collection<T> collection, final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.getFirst(ModelUtils.filter(collection, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T t) {
                return stringArray.length == 0 || ModelUtils.nameKindMatch(t.getName(), kind, stringArray);
            }
        }));
    }

    @NonNull
    public static <T extends ModelElement> T getFirst(Collection<? extends T> collection, FileObject fileObject) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : collection) {
            if (modelElement.getFileObject() != fileObject) continue;
            arrayList.add(modelElement);
        }
        return (T)ModelUtils.getFirst(arrayList);
    }

    @NonNull
    public static <T extends ModelElement> Collection<? extends T> merge(Collection<? extends T> ... collectionArray) {
        ArrayList<? extends T> arrayList = new ArrayList<T>();
        for (Collection<? extends T> collection : collectionArray) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    @CheckForNull
    public static FileScope getFileScope(ModelElement modelElement) {
        FileScope fileScope;
        FileScope fileScope2 = fileScope = modelElement instanceof FileScope ? (FileScope)modelElement : null;
        while (fileScope == null && modelElement != null) {
            fileScope = (FileScope)((modelElement = modelElement.getInScope()) instanceof FileScope ? modelElement : null);
        }
        return fileScope;
    }

    @NonNull
    public static IndexScope getIndexScope(ModelElement modelElement) {
        IndexScope indexScope = modelElement instanceof IndexScope ? (IndexScope)modelElement : null;
        ModelElement modelElement2 = modelElement;
        while (indexScope == null && modelElement2 != null) {
            indexScope = (IndexScope)((modelElement2 = modelElement2.getInScope()) instanceof IndexScope ? modelElement2 : null);
        }
        if (indexScope == null) {
            FileScope fileScope = ModelUtils.getFileScope(modelElement);
            assert (fileScope != null);
            indexScope = fileScope.getIndexScope();
        }
        return indexScope;
    }

    public static <T extends ModelElement> List<? extends T> filter(Collection<T> collection, ElementFilter<T> elementFilter) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : collection) {
            boolean bl = elementFilter.isAccepted(modelElement);
            if (!bl) continue;
            arrayList.add(modelElement);
        }
        return arrayList;
    }

    public static boolean nameKindMatch(String string, QuerySupport.Kind kind, String ... stringArray) {
        return ModelUtils.nameKindMatch(true, string, kind, stringArray);
    }

    private static boolean nameKindMatch(boolean bl, String string, QuerySupport.Kind kind, String ... stringArray) {
        block8: for (String string2 : stringArray) {
            switch (kind) {
                case CAMEL_CASE: {
                    if (!ModelUtils.toCamelCase(string).startsWith(string2)) continue block8;
                    return true;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue block8;
                    return true;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    string = string.toLowerCase();
                }
                case REGEXP: {
                    Pattern pattern = Pattern.compile(string2);
                    if (!ModelUtils.nameKindMatch(pattern, string)) continue block8;
                    return true;
                }
                case EXACT: {
                    boolean bl2;
                    boolean bl3 = bl2 = bl ? string.equalsIgnoreCase(string2) : string.equals(string2);
                    if (!bl2) continue block8;
                    return true;
                }
                case PREFIX: {
                    if (!string.startsWith(string2)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    private static String toCamelCase(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = string.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            cArray[n] = c;
            ++n;
        }
        return String.valueOf(String.valueOf(cArray, 0, n));
    }

    private static boolean nameKindMatch(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ElementFilter<T extends ModelElement> {
        public boolean isAccepted(T var1);
    }
}

