/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionSupport {
    private ModelVisitor modelVisitor;
    private Document document;
    private int offset;
    private static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE);

    CompletionSupport(ModelVisitor modelVisitor, Document document, int n) {
        this.modelVisitor = modelVisitor;
        this.document = document;
        this.offset = n;
    }

    public List<? extends TypeScope> getClassMemberType() {
        return this.getClassMemberTypegetType(this.offset);
    }

    private List<? extends TypeScope> getClassMemberTypegetType(int n) {
        String string;
        FileScope fileScope = this.modelVisitor.getModelScope();
        VariableScope variableScope = this.modelVisitor.getNearestVariableScope(n);
        List list = Collections.emptyList();
        if (fileScope == null || variableScope == null) {
            return list;
        }
        List list2 = list;
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(this.document, n);
        if (this.moveToOffset(tokenSequence, n)) {
            return list;
        }
        State state = State.START;
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && CompletionSupport.canContinueAfterSkipingWhitespaces(tokenSequence)) {
            string = tokenSequence.token();
            if (CTX_DELIMITERS.contains(string.id())) continue;
            switch (state) {
                case START: {
                    state = State.INVALID;
                    if (this.isReference((Token<PHPTokenId>)string)) {
                        state = State.REFERENCE;
                        break;
                    }
                    if (!this.isStaticReference((Token<PHPTokenId>)string)) break;
                    state = State.STATIC_REFERENCE;
                    break;
                }
                case REFERENCE: {
                    state = State.INVALID;
                    if (this.isLeftBracket((Token<PHPTokenId>)string)) {
                        ++n2;
                        state = State.PARAMS;
                        break;
                    }
                    if (this.isString((Token<PHPTokenId>)string)) {
                        stringBuilder.insert(0, ((Object)string.text()).toString());
                        state = State.FIELD;
                        break;
                    }
                    if (!this.isVariable((Token<PHPTokenId>)string)) break;
                    stringBuilder.insert(0, ((Object)string.text()).toString());
                    state = State.VARBASE;
                    break;
                }
                case STATIC_REFERENCE: {
                    state = State.INVALID;
                    if (this.isString((Token<PHPTokenId>)string)) {
                        stringBuilder.insert(0, ((Object)string.text()).toString());
                        state = State.CLASSNAME;
                        break;
                    }
                    if (!this.isSelf((Token<PHPTokenId>)string)) break;
                    stringBuilder.insert(0, CompletionSupport.buildStaticClassName(variableScope, ((Object)string.text()).toString()));
                    state = State.CLASSNAME;
                    break;
                }
                case PARAMS: {
                    state = State.INVALID;
                    if (CTX_DELIMITERS.contains(string.id())) {
                        state = State.INVALID;
                    } else if (this.isLeftBracket((Token<PHPTokenId>)string)) {
                        ++n2;
                    } else if (this.isRightBracket((Token<PHPTokenId>)string)) {
                        ++n3;
                    }
                    if (n2 != n3) break;
                    state = State.METHOD;
                    break;
                }
                case METHOD: {
                    state = State.INVALID;
                    if (!this.isString((Token<PHPTokenId>)string)) break;
                    stringBuilder.insert(0, ((Object)string.text()).toString());
                    stringBuilder.insert(0, "@mtd:");
                    state = State.START;
                    break;
                }
                case FIELD: {
                    state = State.INVALID;
                    if (!this.isReference((Token<PHPTokenId>)string)) break;
                    stringBuilder.insert(0, "@fld:");
                    state = State.REFERENCE;
                    break;
                }
                case VARBASE: {
                    state = State.INVALID;
                    if (this.isStaticReference((Token<PHPTokenId>)string)) {
                        state = State.STATIC_REFERENCE;
                        break;
                    }
                    state = State.VARIABLE;
                }
                case VARIABLE: {
                    stringBuilder.insert(0, "@var:");
                }
                case CLASSNAME: {
                    state = State.STOP;
                }
            }
        }
        if (state.equals((Object)State.STOP)) {
            string = stringBuilder.toString();
            return VariousUtils.getType(fileScope, variableScope, string, n, false);
        }
        return list2;
    }

    private static String buildStaticClassName(Scope scope, String string) {
        if (scope instanceof MethodScope) {
            ClassScope classScope;
            MethodScope methodScope = (MethodScope)scope;
            ClassScope classScope2 = (ClassScope)methodScope.getInScope();
            if ("self".equals(string)) {
                string = classScope2.getName();
            } else if ("parent".equals(string) && (classScope = ModelUtils.getFirst(classScope2.getSuperClasses())) != null) {
                string = classScope.getName();
            }
        }
        return string;
    }

    private static boolean canContinueAfterSkipingWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && token.id() == PHPTokenId.WHITESPACE) {
            boolean bl = tokenSequence.movePrevious();
            if (bl) continue;
            return false;
        }
        return tokenSequence.movePrevious();
    }

    private boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int n) {
        return tokenSequence == null || tokenSequence.move(n) < 0;
    }

    private boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "$".contentEquals(token.text());
    }

    private boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR);
    }

    private boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        REFERENCE,
        STATIC_REFERENCE,
        METHOD,
        FIELD,
        VARIABLE,
        CLASSNAME,
        STOP;

    }
}

