/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.lexer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.indent.PHPBracketCompleter;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexUtilities {
    private static final Set<PHPTokenId> INDENT_BEGIN_TOKENS = new HashSet<PHPTokenId>();
    private static final Set<PHPTokenId> INDENT_END_TOKENS = new HashSet<PHPTokenId>();

    private LexUtilities() {
    }

    @CheckForNull
    public static TokenSequence<PHPTokenId> getPHPTokenSequence(Document document, int n) {
        TokenSequence tokenSequence;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence2 = tokenSequence = tokenHierarchy == null ? null : tokenHierarchy.tokenSequence(PHPTokenId.language());
        if (tokenSequence == null) {
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            for (TokenSequence tokenSequence3 : list) {
                if (tokenSequence3.language() != PHPTokenId.language()) continue;
                tokenSequence = tokenSequence3;
                break;
            }
            if (tokenSequence == null) {
                list = tokenHierarchy.embeddedTokenSequences(n, false);
                for (TokenSequence tokenSequence3 : list) {
                    if (tokenSequence3.language() != PHPTokenId.language()) continue;
                    tokenSequence = tokenSequence3;
                    break;
                }
            }
        }
        return tokenSequence;
    }

    public static TokenSequence<? extends PHPTokenId> getPositionedSequence(BaseDocument baseDocument, int n) {
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence != null) {
            try {
                tokenSequence.move(n);
            }
            catch (AssertionError assertionError) {
                DataObject dataObject = (DataObject)baseDocument.getProperty((Object)"stream");
                if (dataObject != null) {
                    Exceptions.attachMessage((Throwable)((Object)assertionError), (String)FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()));
                }
                throw assertionError;
            }
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static Token<? extends PHPTokenId> getToken(BaseDocument baseDocument, int n) {
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null) {
            return tokenSequence.token();
        }
        return null;
    }

    public static char getTokenChar(BaseDocument baseDocument, int n) {
        Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token != null && token.text().length() > 0) {
            return token.text().charAt(0);
        }
        return '\u0000';
    }

    public static OffsetRange findFwd(BaseDocument baseDocument, TokenSequence<? extends PHPTokenId> tokenSequence, char c, char c2) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (LexUtilities.textEquals(token.text(), c)) {
                ++n;
                continue;
            }
            if (!LexUtilities.textEquals(token.text(), c2)) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument baseDocument, TokenSequence<? extends PHPTokenId> tokenSequence, char c, char c2) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (LexUtilities.textEquals(token.text(), c)) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                ++n;
                continue;
            }
            if (!LexUtilities.textEquals(token.text(), c2)) continue;
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBegin(BaseDocument baseDocument, TokenSequence<? extends PHPTokenId> tokenSequence) {
        return OffsetRange.NONE;
    }

    public static boolean isIndentBeginToken(PHPTokenId pHPTokenId) {
        return INDENT_BEGIN_TOKENS.contains((Object)pHPTokenId);
    }

    public static boolean isIndentEndToken(PHPTokenId pHPTokenId) {
        return INDENT_END_TOKENS.contains((Object)pHPTokenId);
    }

    public static int getBeginEndLineBalance(BaseDocument baseDocument, int n, boolean bl) {
        return 0;
    }

    public static int getLineBalance(BaseDocument baseDocument, int n, TokenId tokenId, TokenId tokenId2, PHPBracketCompleter.LineBalance lineBalance) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            int n5 = 0;
            do {
                Token token;
                TokenId tokenId3;
                if ((tokenId3 = (token = tokenSequence.token()).id()) == tokenId) {
                    if (lineBalance.equals((Object)PHPBracketCompleter.LineBalance.DOWN_FIRST)) {
                        if (n4 <= 0) continue;
                        ++n4;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                if (tokenId3 != tokenId2) continue;
                if (lineBalance.equals((Object)PHPBracketCompleter.LineBalance.UP_FIRST)) {
                    if (n4 <= 0) continue;
                    ++n5;
                    continue;
                }
                ++n5;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4 - n5;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument baseDocument, char c, char c2, int n) throws BadLocationException {
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, 0);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.moveIndex(0);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n2 = 0;
        do {
            Token token = tokenSequence.token();
            if (LexUtilities.textEquals(token.text(), c)) {
                ++n2;
                continue;
            }
            if (!LexUtilities.textEquals(token.text(), c2)) continue;
            --n2;
        } while (tokenSequence.moveNext());
        return n2;
    }

    public static boolean isCommentOnlyLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1) {
            return false;
        }
        Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n2);
        if (token != null) {
            return token.id() == PHPTokenId.PHP_LINE_COMMENT;
        }
        return false;
    }

    public static boolean textEquals(CharSequence charSequence, char ... cArray) {
        int n = charSequence.length();
        if (n == cArray.length) {
            for (int i = n - 1; i >= 0; --i) {
                if (charSequence.charAt(i) == cArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

