/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class PHPIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(PHPIndexer.class.getName());
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final FileSystem MEM_FS = FileUtil.createMemoryFileSystem();
    private static final Map<String, FileObject> EXT2FO = new HashMap<String, FileObject>();
    private static final Collection<String> INDEXABLE_EXTENSIONS = Arrays.asList("php", "php3", "php4", "php5", "phtml", "inc");
    static final String FIELD_BASE = "base";
    static final String FIELD_EXTEND = "extend";
    static final String FIELD_CLASS = "clz";
    static final String FIELD_IFACE = "iface";
    static final String FIELD_CONST = "const";
    static final String FIELD_CLASS_CONST = "clz.const";
    static final String FIELD_FIELD = "field";
    static final String FIELD_METHOD = "method";
    static final String FIELD_CONSTRUCTOR = "constructor";
    static final String FIELD_INCLUDE = "include";
    static final String FIELD_IDENTIFIER = "identifier_used";
    static final String FIELD_IDENTIFIER_DECLARATION = "identifier_declaration";
    static final String FIELD_VAR = "var";
    static final String FIELD_TOP_LEVEL = "top";
    static final String[] ALL_FIELDS = new String[]{"base", "extend", "clz", "iface", "const", "clz.const", "field", "method", "constructor", "include", "identifier_used", "identifier_declaration", "var", "top"};
    private static FileObject preindexedDb;

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return PHPIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    protected void index(Indexable indexable, Parser.Result result, Context context) {
        try {
            PHPParseResult pHPParseResult = (PHPParseResult)result;
            if (pHPParseResult.getProgram() == null) {
                return;
            }
            IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
            TreeAnalyzer treeAnalyzer = new TreeAnalyzer(indexable, pHPParseResult, indexingSupport);
            treeAnalyzer.analyze();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void indexClass(ClassDeclaration classDeclaration, IndexDocument indexDocument, Program program) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = classDeclaration.getName().getName();
        stringBuilder.append(string.toLowerCase() + ";");
        stringBuilder.append(string + ";");
        stringBuilder.append(classDeclaration.getStartOffset() + ";");
        String string2 = "";
        if (classDeclaration.getSuperClass() instanceof Identifier) {
            Identifier identifier = classDeclaration.getSuperClass();
            string2 = identifier.getName();
        }
        stringBuilder.append(string2 + ";");
        indexDocument.addPair(FIELD_CLASS, stringBuilder.toString(), true, true);
        indexDocument.addPair(FIELD_TOP_LEVEL, classDeclaration.getName().getName().toLowerCase(), true, true);
        boolean bl = false;
        for (Statement aSTNode : classDeclaration.getBody().getStatements()) {
            if (aSTNode instanceof MethodDeclaration) {
                object2 = (MethodDeclaration)aSTNode;
                object = CodeUtils.extractMethodName((MethodDeclaration)object2);
                if (PredefinedSymbols.MAGIC_METHODS.keySet().contains(object) && "__construct".equalsIgnoreCase((String)object)) {
                    bl = true;
                    PHPIndexer.indexConstructor(classDeclaration, ((MethodDeclaration)object2).getFunction(), ((BodyDeclaration)object2).getModifier(), indexDocument, program);
                }
                PHPIndexer.indexMethod(((MethodDeclaration)object2).getFunction(), ((BodyDeclaration)object2).getModifier(), indexDocument, program);
                continue;
            }
            if (aSTNode instanceof FieldsDeclaration) {
                object2 = (FieldsDeclaration)aSTNode;
                PHPIndexer.indexFieldsDeclaration((FieldsDeclaration)object2, indexDocument, program);
                continue;
            }
            if (!(aSTNode instanceof ClassConstantDeclaration)) continue;
            object2 = (ClassConstantDeclaration)aSTNode;
            for (Identifier identifier : ((ClassConstantDeclaration)object2).getNames()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(identifier.getName() + ";");
                stringBuilder2.append(((ASTNode)object2).getStartOffset() + ";");
                indexDocument.addPair(FIELD_CLASS_CONST, stringBuilder2.toString(), false, true);
            }
        }
        if (!bl) {
            bl = true;
            PHPIndexer.indexConstructor(classDeclaration, null, 1, indexDocument, program);
        }
        for (PHPDocVarTypeTag pHPDocVarTypeTag : Utils.getPropertyTags(program, classDeclaration)) {
            object2 = pHPDocVarTypeTag.getVariable().getValue();
            if (((String)object2).charAt(0) == '$') {
                object2 = ((String)object2).substring(1);
            }
            object = PHPIndexer.createFieldsDeclarationRecord((String)object2, pHPDocVarTypeTag.getTypes().get(0).getValue(), 1, pHPDocVarTypeTag.getStartOffset());
            indexDocument.addPair(FIELD_FIELD, (String)object, false, true);
        }
    }

    private static void indexInterface(InterfaceDeclaration interfaceDeclaration, IndexDocument indexDocument, Program program) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(interfaceDeclaration.getName().getName().toLowerCase() + ";");
        stringBuilder.append(interfaceDeclaration.getName().getName() + ";");
        stringBuilder.append(interfaceDeclaration.getStartOffset() + ";");
        Iterator<ASTNode> iterator = interfaceDeclaration.getInterfaes().iterator();
        while (iterator.hasNext()) {
            Identifier aSTNode = iterator.next();
            stringBuilder.append(aSTNode.getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(';');
        indexDocument.addPair(FIELD_IFACE, stringBuilder.toString(), true, true);
        indexDocument.addPair(FIELD_TOP_LEVEL, interfaceDeclaration.getName().getName().toLowerCase(), true, true);
        for (Statement statement : interfaceDeclaration.getBody().getStatements()) {
            Statement statement2;
            if (statement instanceof MethodDeclaration) {
                statement2 = (MethodDeclaration)statement;
                PHPIndexer.indexMethod(((MethodDeclaration)statement2).getFunction(), ((BodyDeclaration)statement2).getModifier(), indexDocument, program);
                continue;
            }
            if (statement instanceof FieldsDeclaration) {
                statement2 = (FieldsDeclaration)statement;
                PHPIndexer.indexFieldsDeclaration((FieldsDeclaration)statement2, indexDocument, program);
                continue;
            }
            if (!(statement instanceof ClassConstantDeclaration)) continue;
            statement2 = (ClassConstantDeclaration)statement;
            for (Identifier identifier : ((ClassConstantDeclaration)statement2).getNames()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(identifier.getName() + ";");
                stringBuilder2.append(statement2.getStartOffset() + ";");
                indexDocument.addPair(FIELD_CLASS_CONST, stringBuilder2.toString(), false, true);
            }
        }
    }

    private static void indexFieldsDeclaration(FieldsDeclaration fieldsDeclaration, IndexDocument indexDocument, Program program) {
        for (SingleFieldDeclaration singleFieldDeclaration : fieldsDeclaration.getFields()) {
            if (!(singleFieldDeclaration.getName().getName() instanceof Identifier)) continue;
            Identifier identifier = (Identifier)singleFieldDeclaration.getName().getName();
            String string = PHPIndexer.getFieldTypeFromPHPDoc(singleFieldDeclaration, program);
            String string2 = PHPIndexer.createFieldsDeclarationRecord(identifier.getName(), string, fieldsDeclaration.getModifier(), singleFieldDeclaration.getStartOffset());
            indexDocument.addPair(FIELD_FIELD, string2, false, true);
        }
    }

    private static String createFieldsDeclarationRecord(String string, String string2, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + ";");
        stringBuilder.append(n2 + ";");
        stringBuilder.append(n + ";");
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    private static void indexVarsInAssignment(Assignment assignment, IndexDocument indexDocument) {
        Expression expression;
        if (assignment.getLeftHandSide() instanceof Variable) {
            expression = (Variable)assignment.getLeftHandSide();
            String string = CodeUtils.extractVariableType(assignment);
            String string2 = CodeUtils.extractVariableName((Variable)expression);
            if (string2 != null) {
                String string3;
                String string4 = string3 = string2.startsWith("$") ? string2.substring(1) : string2;
                if (!PredefinedSymbols.isSuperGlobalName(string3)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2.toLowerCase() + ";" + string2 + ";");
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(";");
                    stringBuilder.append(expression.getStartOffset() + ";");
                    indexDocument.addPair(FIELD_VAR, stringBuilder.toString(), true, true);
                    indexDocument.addPair(FIELD_TOP_LEVEL, string2.toLowerCase(), true, true);
                }
            }
        }
        if (assignment.getRightHandSide() instanceof Assignment) {
            expression = (Assignment)assignment.getRightHandSide();
            PHPIndexer.indexVarsInAssignment((Assignment)expression, indexDocument);
        }
    }

    private static void indexConstant(Statement statement, IndexDocument indexDocument) {
        String string;
        Expression expression;
        Identifier identifier;
        FunctionInvocation functionInvocation;
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression2 = expressionStatement.getExpression();
        if (expression2 instanceof FunctionInvocation && (functionInvocation = (FunctionInvocation)expression2).getFunctionName().getName() instanceof Identifier && "define".equals((identifier = (Identifier)functionInvocation.getFunctionName().getName()).getName()) && functionInvocation.getParameters().size() >= 2 && (expression = functionInvocation.getParameters().get(0)) instanceof Scalar && PHPIndexer.isQuotedString(string = ((Scalar)expression).getStringValue())) {
            String string2 = PHPIndexer.dequote(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2.toLowerCase());
            stringBuilder.append(';');
            stringBuilder.append(string2);
            stringBuilder.append(';');
            stringBuilder.append(functionInvocation.getStartOffset());
            stringBuilder.append(';');
            indexDocument.addPair(FIELD_CONST, stringBuilder.toString(), true, true);
            indexDocument.addPair(FIELD_TOP_LEVEL, string2.toLowerCase(), true, true);
        }
    }

    private static void indexFunction(FunctionDeclaration functionDeclaration, IndexDocument indexDocument, Program program) {
        StringBuilder stringBuilder = new StringBuilder(functionDeclaration.getFunctionName().getName().toLowerCase() + ";");
        stringBuilder.append(PHPIndexer.getBaseSignatureForFunctionDeclaration(functionDeclaration, program));
        indexDocument.addPair(FIELD_BASE, stringBuilder.toString(), true, true);
        indexDocument.addPair(FIELD_TOP_LEVEL, functionDeclaration.getFunctionName().getName().toLowerCase(), true, true);
    }

    private static void indexConstructor(ClassDeclaration classDeclaration, FunctionDeclaration functionDeclaration, int n, IndexDocument indexDocument, Program program) {
        String string = CodeUtils.extractClassName(classDeclaration);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = functionDeclaration != null ? functionDeclaration.getFormalParameters().size() : 0;
        int n3 = functionDeclaration != null ? functionDeclaration.getStartOffset() : classDeclaration.getStartOffset();
        stringBuilder.append(PHPIndexer.getBaseSignatureForFunctionDeclaration(string, n2, n3, functionDeclaration, program));
        stringBuilder.append(n + ";");
        indexDocument.addPair(FIELD_CONSTRUCTOR, stringBuilder.toString(), false, true);
    }

    private static void indexMethod(FunctionDeclaration functionDeclaration, int n, IndexDocument indexDocument, Program program) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PHPIndexer.getBaseSignatureForFunctionDeclaration(functionDeclaration, program));
        stringBuilder.append(n + ";");
        indexDocument.addPair(FIELD_METHOD, stringBuilder.toString(), false, true);
    }

    private static String getBaseSignatureForFunctionDeclaration(FunctionDeclaration functionDeclaration, Program program) {
        String string = functionDeclaration.getFunctionName().getName();
        int n = functionDeclaration.getFormalParameters().size();
        int n2 = functionDeclaration != null ? functionDeclaration.getStartOffset() : 0;
        return PHPIndexer.getBaseSignatureForFunctionDeclaration(string, n, n2, functionDeclaration, program);
    }

    private static String getBaseSignatureForFunctionDeclaration(String string, int n, int n2, FunctionDeclaration functionDeclaration, Program program) {
        String string2;
        Object object;
        String[] stringArray;
        assert (functionDeclaration != null || n == 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + ";");
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            assert (functionDeclaration != null);
            stringArray = functionDeclaration.getFormalParameters().get(i);
            object = CodeUtils.getParamDisplayName((FormalParameter)stringArray);
            stringBuilder.append((String)object);
            if (i < n - 1) {
                stringBuilder.append(",");
            }
            if (stringArray.getDefaultValue() == null) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(',');
            }
            stringBuilder2.append(Integer.toString(i));
        }
        stringBuilder.append(';');
        stringBuilder.append(n2 + ";");
        stringBuilder.append(stringBuilder2 + ";");
        String string3 = string2 = functionDeclaration != null ? PHPIndexer.getReturnTypeFromPHPDoc(functionDeclaration, program) : null;
        if (string2 == null) {
            stringArray = new String[1];
            object = new DefaultVisitor(){

                public void visit(ReturnStatement returnStatement) {
                    Expression expression = returnStatement.getExpression();
                    if (expression instanceof ClassInstanceCreation) {
                        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                        stringArray[0] = CodeUtils.extractClassName(classInstanceCreation.getClassName());
                    }
                }
            };
            ((DefaultVisitor)object).scan(functionDeclaration);
            if (stringArray[0] != null) {
                string2 = stringArray[0];
            }
        }
        if (string2 != null && !"mixed".equalsIgnoreCase(string2)) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    private static String getReturnTypeFromPHPDoc(FunctionDeclaration functionDeclaration, Program program) {
        return PHPIndexer.getTypeFromPHPDoc(functionDeclaration, PHPDocTag.Type.RETURN, program);
    }

    private static String getFieldTypeFromPHPDoc(SingleFieldDeclaration singleFieldDeclaration, Program program) {
        return PHPIndexer.getTypeFromPHPDoc(singleFieldDeclaration, PHPDocTag.Type.VAR, program);
    }

    private static String getTypeFromPHPDoc(ASTNode aSTNode, PHPDocTag.Type type, Program program) {
        Comment comment = Utils.getCommentForNode(program, aSTNode);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
            for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                if (pHPDocTag.getKind() != type) continue;
                String[] stringArray = pHPDocTag.getValue().split("\\s+", 2);
                if (stringArray.length <= 0) break;
                String string = stringArray[0].split("\\;", 2)[0];
                return string;
            }
        }
        return null;
    }

    static boolean isQuotedString(String string) {
        if (string.length() < 2) {
            return false;
        }
        char c = string.charAt(0);
        return c == string.charAt(string.length() - 1) && c == '\'' || c == '\"';
    }

    static String dequote(String string) {
        assert (PHPIndexer.isQuotedString(string));
        return string.substring(1, string.length() - 1);
    }

    public File getPreindexedData() {
        return null;
    }

    public static void setPreindexedDb(FileObject fileObject) {
        preindexedDb = fileObject;
    }

    public FileObject getPreindexedDb() {
        return null;
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("jsstubs") == -1 && string.indexOf("/ruby2/") == -1 && string.indexOf("/gems/") == -1 && string.indexOf("lib/ruby/") == -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "php";
        public static final int VERSION = 2;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new PHPIndexer();
            }
            return null;
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 2;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            FileObject fileObject = snapshot.getSource().getFileObject();
            if (INDEXABLE_EXTENSIONS.contains(fileObject.getExt().toLowerCase())) {
                return true;
            }
            return this.isPhpFile(fileObject);
        }

        public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : collection) {
                    indexingSupport.removeDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }

        public void filesDirty(Collection<? extends Indexable> collection, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : collection) {
                    indexingSupport.markDirtyDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPhpFile(FileObject fileObject) {
            FileObject fileObject2 = null;
            String string = fileObject.getExt();
            Map map = EXT2FO;
            synchronized (map) {
                FileObject fileObject3 = fileObject2 = string != null ? (FileObject)EXT2FO.get(string) : null;
                if (fileObject2 == null) {
                    try {
                        fileObject2 = FileUtil.createData((FileObject)MEM_FS.getRoot(), (String)fileObject.getNameExt());
                        if (string != null && fileObject2 != null) {
                            EXT2FO.put(string, fileObject2);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            assert (fileObject2 != null);
            return "text/x-php5".equals(FileUtil.getMIMEType((FileObject)fileObject2, (String[])new String[]{"text/x-php5"}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexerVisitor
    extends DefaultTreePathVisitor {
        private final IndexingSupport support;
        private final Indexable indexable;
        private final Program root;
        private final List<IndexDocument> documents = new LinkedList<IndexDocument>();
        private final IndexDocument defaultDocument;
        private final IndexDocument identifierDocument;
        private final Map<String, IdentifierSignature> identifiers = new HashMap<String, IdentifierSignature>();

        public IndexerVisitor(IndexingSupport indexingSupport, Indexable indexable, Program program) {
            this.support = indexingSupport;
            this.indexable = indexable;
            this.root = program;
            this.defaultDocument = indexingSupport.createDocument(indexable);
            this.documents.add(this.defaultDocument);
            this.identifierDocument = indexingSupport.createDocument(indexable);
            this.documents.add(this.identifierDocument);
        }

        public List<? extends IndexDocument> getAllDocuments() {
            this.addIdentifierPairs();
            return this.documents;
        }

        private void addIdentifierPairs() {
            for (IdentifierSignature identifierSignature : this.identifiers.values()) {
                this.identifierDocument.addPair(PHPIndexer.FIELD_IDENTIFIER, identifierSignature.getSignature(), true, true);
            }
            this.identifiers.clear();
        }

        @Override
        public void visit(Scalar scalar) {
            if (scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(scalar.getStringValue())) {
                IdentifierSignature.add(scalar.getStringValue(), this.identifiers);
            }
            super.visit(scalar);
        }

        @Override
        public void visit(Identifier identifier) {
            IdentifierSignature.add(identifier, this.identifiers);
            super.visit(identifier);
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            PHPIndexer.indexClass(classDeclaration, indexDocument, this.root);
            ArrayList<IdentifierSignature> arrayList = new ArrayList<IdentifierSignature>();
            IdentifierSignature.add(classDeclaration, Utils.getPropertyTags(this.root, classDeclaration), arrayList);
            for (IdentifierSignature identifierSignature : arrayList) {
                this.identifierDocument.addPair(PHPIndexer.FIELD_IDENTIFIER_DECLARATION, identifierSignature.getSignature(), true, true);
            }
            super.visit(classDeclaration);
        }

        @Override
        public void visit(FunctionDeclaration functionDeclaration) {
            if (this.getPath().get(0) instanceof MethodDeclaration) {
                super.visit(functionDeclaration);
                return;
            }
            PHPIndexer.indexFunction(functionDeclaration, this.defaultDocument, this.root);
            super.visit(functionDeclaration);
        }

        @Override
        public void visit(ExpressionStatement expressionStatement) {
            PHPIndexer.indexConstant(expressionStatement, this.defaultDocument);
            super.visit(expressionStatement);
        }

        @Override
        public void visit(InterfaceDeclaration interfaceDeclaration) {
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            PHPIndexer.indexInterface(interfaceDeclaration, indexDocument, this.root);
            ArrayList<IdentifierSignature> arrayList = new ArrayList<IdentifierSignature>();
            IdentifierSignature.add(interfaceDeclaration, arrayList);
            for (IdentifierSignature identifierSignature : arrayList) {
                this.identifierDocument.addPair(PHPIndexer.FIELD_IDENTIFIER_DECLARATION, identifierSignature.getSignature(), true, true);
            }
            super.visit(interfaceDeclaration);
        }
    }

    private static class TreeAnalyzer {
        private final Indexable indexable;
        private final PHPParseResult result;
        private final IndexingSupport support;

        public TreeAnalyzer(Indexable indexable, PHPParseResult pHPParseResult, IndexingSupport indexingSupport) {
            this.indexable = indexable;
            this.result = pHPParseResult;
            this.support = indexingSupport;
        }

        public void analyze() throws IOException {
            Program program = this.result.getProgram();
            IndexerVisitor indexerVisitor = new IndexerVisitor(this.support, this.indexable, program);
            program.accept(indexerVisitor);
            indexerVisitor.addIdentifierPairs();
            List<? extends IndexDocument> list = indexerVisitor.getAllDocuments();
            assert (list.size() > 0);
            final IndexDocument indexDocument = list.get(0);
            String string = null;
            try {
                string = this.result.getSnapshot().getSource().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            if (string != null) {
                final String string2 = string.substring("file:".length());
                final StringBuilder stringBuilder = new StringBuilder();
                for (Statement statement : program.getStatements()) {
                    new DefaultTreePathVisitor(){

                        public void visit(Assignment assignment) {
                            List<ASTNode> list = this.getPath();
                            boolean bl = true;
                            for (ASTNode aSTNode : list) {
                                if (!(aSTNode instanceof FunctionDeclaration)) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                PHPIndexer.indexVarsInAssignment(assignment, indexDocument);
                            }
                            super.visit(assignment);
                        }

                        public void visit(Include include) {
                            String string;
                            Expression expression;
                            Include include2 = include;
                            Expression expression2 = include2.getExpression();
                            if (expression2 instanceof ParenthesisExpression) {
                                expression = (ParenthesisExpression)include2.getExpression();
                                expression2 = ((ParenthesisExpression)expression).getExpression();
                            }
                            if (expression2 instanceof Scalar && PHPIndexer.isQuotedString(string = ((Scalar)(expression = (Scalar)expression2)).getStringValue())) {
                                String string22 = PHPIndex.resolveRelativeURL(string2, PHPIndexer.dequote(string));
                                stringBuilder.append(string22 + ";");
                            }
                            super.visit(include);
                        }
                    }.scan(statement);
                }
                indexDocument.addPair(PHPIndexer.FIELD_INCLUDE, stringBuilder.toString(), false, true);
            }
            for (IndexDocument indexDocument2 : list) {
                this.support.addDocument(indexDocument2);
            }
        }
    }
}

