/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.index.PHPIndexer;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIndex {
    private static final Logger LOG = Logger.getLogger(PHPIndex.class.getName());
    public static final int ANY_ATTR = -1;
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";
    private static final String[] TOP_LEVEL_TERMS = new String[]{"base", "const", "clz", "var"};
    private final QuerySupport index;
    private WeakHashMap<PHPParseResult, HashMap<String, Collection<String>>> includesCache = new WeakHashMap();
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isReachableCache = new WeakHashMap();
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isSystemFileCache = new WeakHashMap();

    private PHPIndex(QuerySupport querySupport) {
        this.index = querySupport;
    }

    public static PHPIndex get(Collection<FileObject> collection) {
        try {
            return new PHPIndex(QuerySupport.forRoots((String)"php", (int)2, (FileObject[])collection.toArray(new FileObject[collection.size()])));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new PHPIndex(null);
        }
    }

    public static PHPIndex get(ParserResult parserResult) {
        return PHPIndex.get(QuerySupport.findRoots((FileObject)parserResult.getSnapshot().getSource().getFileObject(), Collections.singleton("classpath/php-source"), Collections.singleton("classpath/php-boot"), Collections.emptySet()));
    }

    public Collection<IndexedElement> getAllTopLevel(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedElement> arrayList = new ArrayList<IndexedElement>();
        ArrayList<IndexedFunction> arrayList2 = new ArrayList<IndexedFunction>();
        ArrayList<IndexedConstant> arrayList3 = new ArrayList<IndexedConstant>();
        ArrayList<IndexedClass> arrayList4 = new ArrayList<IndexedClass>();
        ArrayList<IndexedVariable> arrayList5 = new ArrayList<IndexedVariable>();
        Collection<? extends IndexResult> collection = this.search("top", string.toLowerCase(), QuerySupport.Kind.PREFIX, TOP_LEVEL_TERMS);
        this.findFunctions(collection, kind, string, arrayList2);
        this.findConstants(collection, kind, string, arrayList3);
        this.findClasses(collection, kind, string, arrayList4);
        this.findTopVariables(collection, kind, string, arrayList5);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList5);
        return arrayList;
    }

    protected void findClasses(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedClass> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("clz");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String string4 = signature.string(3);
                string4 = string4.length() == 0 ? null : string4;
                IndexedClass indexedClass = new IndexedClass(string3, null, this, indexResult.getUrl().toString(), string4, n, 0);
                collection2.add(indexedClass);
            }
        }
    }

    protected void findConstants(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedConstant> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("const");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.startsWith(string) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                IndexedConstant indexedConstant = new IndexedConstant(string3, null, this, indexResult.getUrl().toString(), n, 0, null);
                collection2.add(indexedConstant);
            }
        }
    }

    protected void findFunctions(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedFunction> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("base");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? !string3.startsWith(string) : kind == QuerySupport.Kind.EXACT && !string3.equalsIgnoreCase(string)) continue;
                int n = signature.integer(3);
                String string4 = signature.string(2);
                IndexedFunction indexedFunction = new IndexedFunction(string3, null, this, indexResult.getUrl().toString(), string4, n, 0, ElementKind.METHOD);
                int[] nArray = this.extractOptionalArgs(signature.string(4));
                indexedFunction.setOptionalArgs(nArray);
                collection2.add(indexedFunction);
                String string5 = signature.string(5);
                string5 = string5.length() == 0 ? null : string5;
                indexedFunction.setReturnType(string5);
            }
        }
    }

    protected void findTopVariables(Collection<? extends IndexResult> collection, QuerySupport.Kind kind, String string, Collection<IndexedVariable> collection2) {
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("var");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind != QuerySupport.Kind.PREFIX && kind != QuerySupport.Kind.CASE_INSENSITIVE_PREFIX ? kind == QuerySupport.Kind.EXACT && !string3.equals(string) : !string3.startsWith(string)) continue;
                String string4 = signature.string(2);
                string4 = string4.length() == 0 ? null : string4;
                int n = signature.integer(3);
                IndexedVariable indexedVariable = new IndexedVariable(string3, null, this, indexResult.getUrl().toString(), n, 0, string4);
                collection2.add(indexedVariable);
            }
        }
    }

    private Collection<? extends IndexResult> search(String string, String string2, QuerySupport.Kind kind, String ... stringArray) {
        try {
            Collection collection = this.index.query(string, string2, kind, stringArray);
            if (LOG.isLoggable(Level.FINE)) {
                String string3 = "PHPIndex.search(" + string + ", " + string2 + ", " + kind + ", " + (stringArray == null || stringArray.length == 0 ? "no terms" : Arrays.asList(stringArray)) + ")";
                LOG.fine(string3);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, null, new Throwable(string3));
                }
                for (IndexResult indexResult : collection) {
                    LOG.fine("Fields in " + indexResult + " (" + indexResult.getFile().getPath() + "):");
                    for (String string4 : PHPIndexer.ALL_FIELDS) {
                        String string5 = indexResult.getValue(string4);
                        if (string5 == null) continue;
                        LOG.fine(" <" + string4 + "> = <" + string5 + ">");
                    }
                    LOG.fine("----");
                }
                LOG.fine("====");
            }
            return collection;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptySet();
        }
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = PHPIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = PHPIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            URL uRL = new URL(string);
            return URLMapper.findFileObject((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-editor.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    public Collection<IndexedConstant> getAllClassConstants(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind) {
        TreeMap<String, IndexedConstant> treeMap = new TreeMap<String, IndexedConstant>();
        FileObject fileObject = pHPParseResult != null ? pHPParseResult.getSnapshot().getSource().getFileObject() : null;
        HashSet<String> hashSet = new HashSet<String>();
        for (String collection2 : this.getClassAncestors(pHPParseResult, string)) {
            for (IndexedConstant indexedConstant : this.getClassConstants(pHPParseResult, collection2, string2, kind)) {
                String string3 = indexedConstant.getName();
                if (treeMap.containsKey(string3) && !collection2.equals(string)) continue;
                treeMap.put(string3, indexedConstant);
                if (fileObject == null || !fileObject.equals(indexedConstant.getFileObject())) continue;
                hashSet.add(collection2);
            }
        }
        Collection<IndexedInterface> collection3 = this.getInterfaceTree(pHPParseResult, string);
        if (collection3 != null) {
            for (IndexedInterface indexedInterface : collection3) {
                for (IndexedConstant indexedConstant : this.getClassConstants(pHPParseResult, indexedInterface.getName(), string2, kind)) {
                    String string4 = indexedConstant.getName();
                    if (treeMap.containsKey(string4) && !indexedInterface.getName().equals(string)) continue;
                    treeMap.put(string4, indexedConstant);
                }
            }
        }
        Collection<IndexedConstant> collection = treeMap.values();
        this.filterClassMembers(collection, hashSet, fileObject);
        return collection;
    }

    public Collection<IndexedFunction> getAllMethods(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        Object object;
        TreeMap<String, IndexedFunction> treeMap = new TreeMap<String, IndexedFunction>();
        FileObject fileObject = pHPParseResult != null ? pHPParseResult.getSnapshot().getSource().getFileObject() : null;
        HashSet<String> hashSet = new HashSet<String>();
        for (String object22 : this.getClassAncestors(pHPParseResult, string)) {
            int n2 = object22.equals(string) ? n : n & 0xFFFFFFFD;
            for (IndexedFunction indexedFunction : this.getMethods(pHPParseResult, object22, string2, kind, n2)) {
                String string3 = indexedFunction.getName();
                if (treeMap.containsKey(string3) && !object22.equals(string)) continue;
                treeMap.put(string3, indexedFunction);
                try {
                    object = fileObject != null ? fileObject.getURL().toURI() : null;
                    if (object == null || !((URI)object).equals(URI.create(indexedFunction.getFilenameUrl()))) continue;
                    hashSet.add(object22);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
            }
        }
        Collection<IndexedInterface> collection = this.getInterfaceTree(pHPParseResult, string);
        if (collection != null) {
            for (IndexedInterface indexedInterface : collection) {
                String string4 = indexedInterface.getName();
                for (IndexedFunction indexedFunction : this.getMethods(pHPParseResult, string4, string2, kind, n)) {
                    object = indexedFunction.getName();
                    if (treeMap.containsKey(object) && !string4.equals(string)) continue;
                    treeMap.put((String)object, indexedFunction);
                }
            }
        }
        Collection<IndexedFunction> collection2 = treeMap.values();
        this.filterClassMembers(collection2, hashSet, fileObject);
        return collection2;
    }

    public Collection<IndexedConstant> getAllFields(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        TreeMap<String, IndexedConstant> treeMap = new TreeMap<String, IndexedConstant>();
        FileObject fileObject = pHPParseResult != null ? pHPParseResult.getSnapshot().getSource().getFileObject() : null;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : this.getClassAncestors(pHPParseResult, string)) {
            int n2 = string3.equals(string) ? n : n & 0xFFFFFFFD;
            for (IndexedConstant indexedConstant : this.getFields(pHPParseResult, string3, string2, kind, n2)) {
                String string4 = indexedConstant.getName();
                if (!treeMap.containsKey(string4) || string3.equals(string)) {
                    treeMap.put(string4, indexedConstant);
                }
                if (fileObject == null || indexedConstant == null || !fileObject.equals(indexedConstant.getFileObject())) continue;
                hashSet.add(string3);
            }
        }
        Collection collection = treeMap.values();
        this.filterClassMembers(collection, hashSet, fileObject);
        return collection;
    }

    private void filterClassMembers(Collection<? extends IndexedElement> collection, Set<String> set, FileObject fileObject) {
        if (collection.size() > 0 && set.size() > 0) {
            Iterator<? extends IndexedElement> iterator = collection.iterator();
            while (iterator.hasNext()) {
                IndexedElement indexedElement = iterator.next();
                if (!set.contains(indexedElement.getIn()) || fileObject.equals(indexedElement.getFileObject())) continue;
                iterator.remove();
            }
        }
    }

    @NonNull
    public Collection<String> getClassAncestors(PHPParseResult pHPParseResult, String string) {
        return this.getClassAncestors(pHPParseResult, string, new TreeSet<String>());
    }

    @NonNull
    private Collection<String> getClassAncestors(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (collection.contains(string)) {
            return Collections.emptyList();
        }
        collection.add(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<IndexedClass> collection2 = this.getClasses(pHPParseResult, string, QuerySupport.Kind.EXACT);
        if (collection2 != null) {
            for (IndexedClass object : collection2) {
                treeSet.add(object.getName());
                String string2 = object.getSuperClass();
                if (string2 == null) continue;
                linkedList.add(string2);
            }
        }
        for (String string3 : linkedList) {
            treeSet.addAll(this.getClassAncestors(pHPParseResult, string3, collection));
        }
        return treeSet;
    }

    public Collection<IndexedConstant> getClassConstants(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Map<String, IndexResult> map = this.getTypeSpecificSignatures(string, "clz.const", string2, kind);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            String string4 = signature.string(0);
            int n = signature.integer(1);
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, this, map.get(string3).getUrl().toString(), n, 0, null);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getConstructors(PHPParseResult pHPParseResult, String string) {
        QuerySupport.Kind kind = QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        String string2 = string;
        int n = -1;
        Map<String, IndexResult> map = this.getTypeSpecificSignatures(string, "constructor", string2, kind, true);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(5);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = signature.string(0);
            String string5 = signature.string(1);
            int n3 = signature.integer(2);
            IndexedFunction indexedFunction = new IndexedFunction(string4, string4, this, map.get(string3).getUrl().toString(), string5, n3, n2, ElementKind.METHOD);
            int[] nArray = this.extractOptionalArgs(signature.string(3));
            indexedFunction.setOptionalArgs(nArray);
            String string6 = signature.string(4);
            string6 = string6.length() == 0 ? null : string6;
            indexedFunction.setReturnType(string6);
            arrayList.add(indexedFunction);
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getMethods(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        Map<String, IndexResult> map = this.getTypeSpecificSignatures(string, "method", string2, kind);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(5);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = signature.string(0);
            String string5 = signature.string(1);
            int n3 = signature.integer(2);
            IndexedFunction indexedFunction = new IndexedFunction(string4, string, this, map.get(string3).getUrl().toString(), string5, n3, n2, ElementKind.METHOD);
            int[] nArray = this.extractOptionalArgs(signature.string(3));
            indexedFunction.setOptionalArgs(nArray);
            String string6 = signature.string(4);
            string6 = string6.length() == 0 ? null : string6;
            indexedFunction.setReturnType(string6);
            arrayList.add(indexedFunction);
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getFields(PHPParseResult pHPParseResult, String string, String string2, QuerySupport.Kind kind, int n) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Map<String, IndexResult> map = this.getTypeSpecificSignatures(string, "field", string2, kind);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(2);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = "$" + signature.string(0);
            int n3 = signature.integer(1);
            String string5 = signature.string(3);
            if (string5.length() == 0) {
                string5 = null;
            }
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, this, map.get(string3).getUrl().toString(), n3, n2, string5, ElementKind.FIELD);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    private Map<String, IndexResult> getTypeSpecificSignatures(String string, String string2, String string3, QuerySupport.Kind kind) {
        return this.getTypeSpecificSignatures(string, string2, string3, kind, false);
    }

    private Map<String, IndexResult> getTypeSpecificSignatures(String string, String string2, String string3, QuerySupport.Kind kind, boolean bl) {
        String[] stringArray;
        String[] stringArray2;
        HashMap<String, IndexResult> hashMap = new HashMap<String, IndexResult>();
        if (bl) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "clz";
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "clz";
            stringArray2 = stringArray4;
            stringArray4[1] = "iface";
        }
        for (String string4 : stringArray = stringArray2) {
            String[] stringArray5;
            String string5 = string.toLowerCase();
            if (bl) {
                String[] stringArray6 = new String[3];
                stringArray6[0] = string4;
                stringArray6[1] = string2;
                stringArray5 = stringArray6;
                stringArray6[2] = "constructor";
            } else {
                String[] stringArray7 = new String[3];
                stringArray7[0] = string4;
                stringArray7[1] = string2;
                stringArray5 = stringArray7;
                stringArray7[2] = "base";
            }
            Collection<? extends IndexResult> collection = this.search(string4, string5, QuerySupport.Kind.PREFIX, stringArray5);
            for (IndexResult indexResult : collection) {
                String[] stringArray8 = indexResult.getValues(string4);
                String[] stringArray9 = indexResult.getValues(string2);
                if (stringArray8 == null || stringArray9 == null) continue;
                String string6 = stringArray8.length > 0 ? PHPIndex.getSignatureItem(stringArray8[0], 1) : null;
                String string7 = string6 = string6 != null ? string6.toLowerCase() : null;
                if (bl ? !string6.startsWith(string.toLowerCase()) : !string.toLowerCase().equals(string6)) continue;
                for (String string8 : stringArray9) {
                    String string9 = PHPIndex.getSignatureItem(string8, 0);
                    if (string9 == null || !(kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && string9.toLowerCase().startsWith(string3.toLowerCase()) || kind == QuerySupport.Kind.PREFIX && string9.startsWith(string3)) && (kind != QuerySupport.Kind.EXACT || !string9.equals(string3))) continue;
                    hashMap.put(string8, indexResult);
                }
            }
        }
        return hashMap;
    }

    @CheckForNull
    static String getSignatureItem(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 == n) {
                for (int j = i; j < string.length(); ++j) {
                    c = string.charAt(j);
                    if (c != ';') continue;
                    return string.substring(i, j);
                }
            }
            if (c != ';') continue;
            ++n2;
        }
        return null;
    }

    public Collection<IndexedFunction> getFunctions(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        Collection<? extends IndexResult> collection = this.search("base", string.toLowerCase(), QuerySupport.Kind.PREFIX, "base");
        this.findFunctions(collection, kind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedVariable> getTopLevelVariables(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedVariable> arrayList = new ArrayList<IndexedVariable>();
        Collection<? extends IndexResult> collection = this.search("var", string.toLowerCase(), QuerySupport.Kind.PREFIX, "var");
        this.findTopVariables(collection, kind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedConstant> getConstants(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Collection<? extends IndexResult> collection = this.search("const", string.toLowerCase(), QuerySupport.Kind.PREFIX, "const");
        this.findConstants(collection, kind, string, arrayList);
        return arrayList;
    }

    public Set<FileObject> filesWithIdentifiers(String string) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Collection<? extends IndexResult> collection = this.search("identifier_used", string.toLowerCase(), QuerySupport.Kind.PREFIX, "base");
        for (IndexResult indexResult : collection) {
            URL uRL = indexResult.getUrl();
            FileObject fileObject = null;
            try {
                fileObject = "file".equals(uRL.getProtocol()) ? FileUtil.toFileObject((File)new File(uRL.toURI())) : URLMapper.findFileObject((URL)uRL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
            if (fileObject == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    public Set<String> typeNamesForIdentifier(String string, ElementKind elementKind, QuerySupport.Kind kind) {
        HashSet<String> hashSet = new HashSet<String>();
        Collection<? extends IndexResult> collection = this.search("identifier_declaration", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]);
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("identifier_declaration");
            if (stringArray == null) continue;
            block5: for (String string2 : stringArray) {
                IdentifierSignature identifierSignature = IdentifierSignature.createDeclaration(Signature.get(string2));
                if (!identifierSignature.isClassMember() && !identifierSignature.isIfaceMember() || identifierSignature.getTypeName() == null) continue;
                switch (kind) {
                    case CASE_INSENSITIVE_PREFIX: {
                        if (identifierSignature.getName().startsWith(string.toLowerCase())) break;
                        continue block5;
                    }
                    case PREFIX: {
                        if (identifierSignature.getName().startsWith(string)) break;
                        continue block5;
                    }
                    default: {
                        assert (false) : kind.toString();
                        continue block5;
                    }
                }
                if (elementKind == null) {
                    hashSet.add(identifierSignature.getTypeName());
                    continue;
                }
                if (elementKind.equals((Object)ElementKind.FIELD) && identifierSignature.isField()) {
                    hashSet.add(identifierSignature.getTypeName());
                    continue;
                }
                if (elementKind.equals((Object)ElementKind.METHOD) && identifierSignature.isMethod()) {
                    hashSet.add(identifierSignature.getTypeName());
                    continue;
                }
                if (!elementKind.equals((Object)ElementKind.CONSTANT) || !identifierSignature.isClassConstant()) continue;
                hashSet.add(identifierSignature.getTypeName());
            }
        }
        return hashSet;
    }

    public Collection<IndexedClass> getClasses(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedClass> arrayList = new ArrayList<IndexedClass>();
        Collection<? extends IndexResult> collection = this.search("clz", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]);
        this.findClasses(collection, kind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedInterface> getInterfaces(PHPParseResult pHPParseResult, String string, QuerySupport.Kind kind) {
        Collection<? extends IndexResult> collection = null;
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        collection = string != null && string.trim().length() > 0 ? this.search("iface", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]) : this.search("iface", string.toLowerCase(), QuerySupport.Kind.PREFIX, new String[0]);
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("iface");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (kind == QuerySupport.Kind.PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : kind == QuerySupport.Kind.EXACT && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String[] stringArray2 = signature.string(3).split(",");
                IndexedInterface indexedInterface = new IndexedInterface(string3, null, this, indexResult.getUrl().toString(), stringArray2, n, 0);
                arrayList.add(indexedInterface);
            }
        }
        return arrayList;
    }

    private Collection<IndexedInterface> getInterfaceTree(PHPParseResult pHPParseResult, String string) {
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>(Collections.singleton(string));
        while (!treeSet.isEmpty()) {
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (String string2 : treeSet) {
                for (IndexedInterface indexedInterface : this.getInterfaces(pHPParseResult, string2, QuerySupport.Kind.EXACT)) {
                    arrayList.add(indexedInterface);
                    arrayList2.add(indexedInterface.getName());
                    for (String string3 : indexedInterface.getInterfaces()) {
                        if (arrayList2.contains(string3)) continue;
                        treeSet2.add(string3);
                    }
                }
            }
            treeSet.clear();
            treeSet.addAll(treeSet2);
        }
        return arrayList;
    }

    public Collection<String> getDirectIncludes(PHPParseResult pHPParseResult, String string) {
        assert (!string.startsWith("file:"));
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<? extends IndexResult> collection = this.search("filename", "file:" + string, QuerySupport.Kind.EXACT, new String[0]);
        for (IndexResult indexResult : collection) {
            String[] stringArray = indexResult.getValues("include");
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                for (String string3 : string2.split(";")) {
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
        }
        return arrayList;
    }

    public Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string) {
        return this.getAllIncludes(pHPParseResult, string, new TreeSet<String>());
    }

    private Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        Collection<String> collection2;
        HashMap<String, Collection<String>> hashMap = this.includesCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            collection2 = hashMap.get(string);
            if (collection2 != null) {
                return collection2;
            }
        } else {
            hashMap = new HashMap();
            this.includesCache.put(pHPParseResult, hashMap);
        }
        collection2 = this.getAllIncludesImpl(pHPParseResult, string, collection);
        hashMap.put(string, collection2);
        return collection2;
    }

    private Collection<String> getAllIncludesImpl(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection<String> collection2 = this.getDirectIncludes(pHPParseResult, string);
        for (String string2 : collection2) {
            if (collection.contains(string2)) continue;
            collection.add(string2);
            treeSet.add(string2);
            treeSet.addAll(this.getAllIncludes(pHPParseResult, string2, collection));
        }
        return Collections.unmodifiableCollection(treeSet);
    }

    public boolean isReachable(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isReachableCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isReachableCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isReachableImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isReachableImpl(PHPParseResult pHPParseResult, String string) {
        if (this.isSystemFile(pHPParseResult, string)) {
            return true;
        }
        String string2 = null;
        try {
            string2 = pHPParseResult.getSnapshot().getSource().getFileObject().getURL().toExternalForm();
            if (string.equals(string2)) {
                return true;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        Collection<String> collection = this.getAllIncludes(pHPParseResult, PHPIndex.fileURLToAbsPath(string2));
        return collection.contains(PHPIndex.fileURLToAbsPath(string));
    }

    private boolean isSystemFile(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isSystemFileCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isSystemFileCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isSystemFileImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isSystemFileImpl(PHPParseResult pHPParseResult, String string) {
        try {
            File file = new File(new URI(string));
            if (!file.exists()) {
                return false;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject);
            if (fileType == PhpSourcePath.FileType.INTERNAL || fileType == PhpSourcePath.FileType.INCLUDE) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        return false;
    }

    private static String fileURLToAbsPath(String string) {
        assert (string.startsWith("file:")) : string + " doesn't start with 'file:'";
        return string.substring("file:".length());
    }

    static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = PHPIndex.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    private int[] extractOptionalArgs(String string) {
        if (string.length() == 0) {
            return new int[0];
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.format("*** couldnt parse '%s', part %d", string, i));
            }
        }
        return nArray;
    }
}

