/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSTransformer
extends DefaultTreePathVisitor {
    private String newLineReplacement = "\n";
    private Context context;
    private List<Replacement> replacements = new LinkedList<Replacement>();

    public WSTransformer(Context context) {
        this.context = context;
        String string = CodeStyle.get(context.document()).getOpeningBraceStyle();
        this.newLineReplacement = "ob.new_line".equals(string) ? "\n" : " ";
    }

    @Override
    public void visit(Block block) {
        if (block.isCurly()) {
            TokenSequence<PHPTokenId> tokenSequence = this.tokenSequence(block.getStartOffset());
            tokenSequence.move(block.getStartOffset());
            if (tokenSequence.moveNext() && tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                int n = tokenSequence.offset();
                int n2 = 0;
                if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                    n2 = tokenSequence.token().length();
                }
                Replacement replacement = new Replacement(n, n2, this.newLineReplacement);
                this.replacements.add(0, replacement);
            }
        }
        super.visit(block);
    }

    List<Replacement> getReplacements() {
        return this.replacements;
    }

    private TokenSequence<PHPTokenId> tokenSequence(int n) {
        return LexUtilities.getPHPTokenSequence(this.context.document(), n);
    }

    static class Replacement {
        private int offset;
        private int length;
        private String newString;

        public Replacement(int n, int n2, String string) {
            this.offset = n;
            this.length = n2;
            this.newString = string;
        }

        public int length() {
            return this.length;
        }

        public String newString() {
            return this.newString;
        }

        public int offset() {
            return this.offset;
        }
    }
}

