/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.IndentLevelCalculator;
import org.netbeans.modules.php.editor.indent.WSTransformer;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPFormatter
implements Formatter {
    private static final Logger LOG = Logger.getLogger(PHPFormatter.class.getName());
    private static final Set<PHPTokenId> IGNORE_BREAK_IN = new HashSet<PHPTokenId>(Arrays.asList(PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_DO));

    public PHPFormatter() {
        LOG.fine("PHP Formatter: " + this);
    }

    public boolean needsParserResult() {
        return true;
    }

    public void reindent(Context context) {
        String string = PHPFormatter.getMimeTypeAtOffset(context.document(), context.startOffset());
        if (!"text/x-php5".equals(string)) {
            return;
        }
        this.reindent(context, null, true);
    }

    public void reformat(Context context, ParserResult parserResult) {
        LOG.log(Level.FINE, "PHPFormatter snapshot: \n''{0}''\n", ((Object)parserResult.getSnapshot().getText()).toString());
        LinkedHashMap<Position, Integer> linkedHashMap = new LinkedHashMap<Position, Integer>();
        IndentLevelCalculator indentLevelCalculator = new IndentLevelCalculator(context.document(), linkedHashMap);
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        pHPParseResult.getProgram().accept(indentLevelCalculator);
        this.prettyPrint(context, parserResult);
        this.astReformat(context, linkedHashMap);
    }

    public int indentSize() {
        return CodeStyle.get((Document)null).getIndentSize();
    }

    public int hangingIndentSize() {
        return CodeStyle.get((Document)null).getContinuationIndentSize();
    }

    private int getFormatStableStart(BaseDocument baseDocument, int n) {
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId tokenId;
            if ((tokenId = (token = tokenSequence.token()).id()) != PHPTokenId.PHP_OPENTAG && tokenId != PHPTokenId.PHP_CLASS && tokenId != PHPTokenId.PHP_FUNCTION) continue;
            return tokenSequence.offset();
        } while (tokenSequence.movePrevious());
        return tokenSequence.offset();
    }

    public static int getTokenBalanceDelta(BaseDocument baseDocument, Token<? extends PHPTokenId> token, TokenSequence<? extends PHPTokenId> tokenSequence, boolean bl) {
        if (token.id() == PHPTokenId.PHP_VARIABLE) {
            if (token.length() == 1) {
                char c = token.text().charAt(0);
                if (c == '[') {
                    return 1;
                }
                if (c == ']') {
                    return -1;
                }
            }
        } else {
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                return 1;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                return -1;
            }
            if (token.id() == PHPTokenId.PHP_CASE || token.id() == PHPTokenId.PHP_DEFAULT) {
                return 1;
            }
            if (token.id() == PHPTokenId.PHP_BREAK) {
                return PHPFormatter.getIndentAfterBreak(baseDocument, tokenSequence);
            }
            if (token.id() == PHPTokenId.PHP_TOKEN) {
                if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                    return 1;
                }
                if (LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) {
                    return -1;
                }
            } else if (bl) {
                if (LexUtilities.isIndentBeginToken((PHPTokenId)token.id())) {
                    return 1;
                }
                if (LexUtilities.isIndentEndToken((PHPTokenId)token.id())) {
                    return -1;
                }
            }
        }
        return 0;
    }

    private static int getIndentAfterBreak(BaseDocument baseDocument, TokenSequence<? extends PHPTokenId> tokenSequence) {
        int n = tokenSequence.index();
        int n2 = tokenSequence.offset();
        int n3 = 0;
        int n4 = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN || LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                --n4;
                continue;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE || LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) {
                ++n4;
                continue;
            }
            if (n4 == -1 && IGNORE_BREAK_IN.contains(token.id())) {
                n3 = 0;
                break;
            }
            if (n4 != 0 || token.id() != PHPTokenId.PHP_CASE) continue;
            CodeStyle codeStyle = CodeStyle.get((Document)baseDocument);
            int n5 = codeStyle.getIndentSize();
            if (n5 <= 0) break;
            try {
                int n6 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)tokenSequence.offset());
                int n7 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n2);
                n3 = (n6 - n7) / n5;
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.FINE, "Incorrect offset?!", badLocationException);
            }
            break;
        }
        tokenSequence.moveIndex(n);
        tokenSequence.moveNext();
        return n3;
    }

    public static int getTokenBalance(BaseDocument baseDocument, int n, int n2, boolean bl) {
        int n3 = 0;
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        do {
            Token token = tokenSequence.token();
            n3 += PHPFormatter.getTokenBalanceDelta(baseDocument, (Token<? extends PHPTokenId>)token, tokenSequence, bl);
        } while (tokenSequence.moveNext() && tokenSequence.offset() < n2);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lineUnformattable(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenId tokenId;
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            int n3;
            int n4;
            Token token = LexUtilities.getToken(baseDocument, n2);
            TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n2);
            if (tokenSequence != null) {
                token = tokenSequence.token();
            }
            if (token == null) return true;
            TokenId tokenId2 = token.id();
            if (tokenId2 == PHPTokenId.PHP_COMMENT || tokenId2 == PHPTokenId.PHP_COMMENT_START || tokenId2 == PHPTokenId.PHP_COMMENT_END || tokenId2 == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE || tokenId2 == PHPTokenId.T_INLINE_HTML || tokenId2 == PHPTokenId.PHP_HEREDOC_TAG) {
                return true;
            }
            if (tokenId2 != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING || (n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset())) >= (n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2))) return false;
            return true;
        }
        Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token == null || (tokenId = token.id()) != PHPTokenId.PHP_COMMENT && tokenId != PHPTokenId.PHP_COMMENT_START && tokenId != PHPTokenId.PHP_COMMENT_END && tokenId != PHPTokenId.PHPDOC_COMMENT && tokenId != PHPTokenId.PHPDOC_COMMENT_START && tokenId != PHPTokenId.PHPDOC_COMMENT_END && tokenId != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && tokenId != PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE && tokenId != PHPTokenId.PHP_HEREDOC_TAG) return false;
        return true;
    }

    private Token<? extends PHPTokenId> getFirstToken(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            return LexUtilities.getToken(baseDocument, n2);
        }
        return null;
    }

    private boolean isEndIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends PHPTokenId> token = this.getFirstToken(baseDocument, n);
            if (token == null) {
                return false;
            }
            return LexUtilities.isIndentEndToken((PHPTokenId)token.id()) || LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']') || token.id() == PHPTokenId.PHP_CURLY_CLOSE;
        }
        return false;
    }

    private boolean isLineContinued(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if ((n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) == -1) {
            return false;
        }
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token token = tokenSequence.token();
        if (token != null) {
            TokenId tokenId = token.id();
            if (tokenSequence.offset() == n && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                return true;
            }
            if (token.length() == 1 && tokenId == PHPTokenId.PHP_TOKEN && ((Object)token.text()).toString().equals(",") && n2 == 0) {
                return true;
            }
            if (tokenId == PHPTokenId.PHP_TOKEN && (CharSequenceUtilities.textEquals((CharSequence)token.text(), (CharSequence)"or") || CharSequenceUtilities.textEquals((CharSequence)token.text(), (CharSequence)"and"))) {
                return true;
            }
        }
        return false;
    }

    private void prettyPrint(final Context context, final ParserResult parserResult) {
        final BaseDocument baseDocument = (BaseDocument)context.document();
        String string = CodeStyle.get((Document)baseDocument).getOpeningBraceStyle();
        if ("ob.preserve".equals(string)) {
            return;
        }
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                WSTransformer wSTransformer = new WSTransformer(context);
                PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
                pHPParseResult.getProgram().accept(wSTransformer);
                for (WSTransformer.Replacement replacement : wSTransformer.getReplacements()) {
                    if (replacement.offset() < context.startOffset() || replacement.offset() > context.endOffset()) continue;
                    try {
                        baseDocument.insertString(replacement.offset(), replacement.newString(), null);
                        if (replacement.length() <= 0) continue;
                        baseDocument.remove(replacement.offset() - replacement.length(), replacement.length());
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
    }

    private void reindent(final Context context, ParserResult parserResult, final boolean bl) {
        Document document = context.document();
        int n = context.startOffset();
        int n2 = context.endOffset();
        document.putProperty("HTML_FORMATTER_ACTS_ON_TOP_LEVEL", Boolean.TRUE);
        try {
            final BaseDocument baseDocument = (BaseDocument)document;
            if (n2 > baseDocument.getLength()) {
                n2 = baseDocument.getLength();
            }
            final int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n4 = 0;
            int n5 = 0;
            if (n > 0) {
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n - 1));
                n4 = this.getFormatStableStart(baseDocument, n6);
                n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n4);
            }
            final ArrayList<Integer> arrayList = new ArrayList<Integer>();
            final ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl2 = n != 0 || n2 != baseDocument.getLength();
            boolean bl3 = n2 == baseDocument.getLength() || bl;
            this.computeIndents(baseDocument, n5, n4, n2, parserResult, arrayList, arrayList2, bl2, bl3, bl);
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        assert (arrayList2.size() == arrayList.size());
                        for (int i = arrayList2.size() - 1; i >= 0; --i) {
                            int n = (Integer)arrayList2.get(i);
                            int n2 = (Integer)arrayList.get(i);
                            if (n2 >= n3) {
                                int n32;
                                if (n2 == n3 && i > 0) {
                                    n32 = (Integer)arrayList.get(i - 1);
                                    int n4 = (Integer)arrayList2.get(i - 1);
                                    int n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n32);
                                    if (n5 != n4 && (bl || !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n32) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n32))) {
                                        n = n5 + (n - n4);
                                    }
                                }
                                if ((n32 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n2)) == n || n < 0) continue;
                                context.modifyIndent(n2, n);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public void computeIndents(BaseDocument baseDocument, int n, int n2, int n3, ParserResult parserResult, List<Integer> list, List<Integer> list2, boolean bl, boolean bl2, boolean bl3) {
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            int n5 = n3;
            CodeStyle codeStyle = CodeStyle.get((Document)baseDocument);
            int n6 = codeStyle.getIndentSize();
            int n7 = codeStyle.getContinuationIndentSize();
            int n8 = 0;
            int n9 = 0;
            boolean bl4 = false;
            while (!bl2 && n4 < n5 || bl2 && n4 <= n5) {
                int n10;
                int n11;
                int n12;
                int n13 = n12 = bl4 ? n7 : 0;
                if (!bl3) {
                    Integer n14;
                    Map map = (Map)baseDocument.getProperty((Object)"AbstractIndenter.lineIndents");
                    n = map != null ? ((n14 = (Integer)map.get(Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4))) != null ? n14 : 0) : 0;
                }
                if ((n11 = this.lineUnformattable(baseDocument, n4) ? GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n4) : (this.isEndIndent(baseDocument, n4) ? (n8 - 1) * n6 + n12 + n : n8 * n6 + n12 + n)) < 0) {
                    n11 = 0;
                }
                if ((n10 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4)) != -1 || bl) {
                    list2.add(n11);
                    list.add(n4);
                }
                int n15 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4) + 1;
                if (n10 != -1) {
                    n8 += PHPFormatter.getTokenBalance(baseDocument, n10, n15, true);
                    bl4 = this.isLineContinued(baseDocument, n4, n9 += PHPFormatter.getTokenBalance(baseDocument, n10, n15, false));
                }
                n4 = n15;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static String getMimeTypeAtOffset(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.embeddedTokenSequences(n, false);
        if (list != null && list.size() > 0) {
            TokenSequence tokenSequence = (TokenSequence)list.get(list.size() - 1);
            return tokenSequence.language().mimeType();
        }
        return null;
    }

    private void astReformat(final Context context, final Map<Position, Integer> map) {
        Document document = context.document();
        int n = context.startOffset();
        int n2 = context.endOffset();
        document.putProperty("HTML_FORMATTER_ACTS_ON_TOP_LEVEL", Boolean.TRUE);
        try {
            final BaseDocument baseDocument = (BaseDocument)document;
            final Map map2 = (Map)baseDocument.getProperty((Object)"AbstractIndenter.lineIndents");
            if (n2 > baseDocument.getLength()) {
                n2 = baseDocument.getLength();
            }
            if ((n = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n)) < 0) {
                n = context.startOffset();
            }
            final int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    int n = 0;
                    try {
                        int n2;
                        int n32;
                        int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)(baseDocument.getLength() - 1));
                        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
                        for (Position position : map.keySet()) {
                            n32 = (Integer)map.get(position);
                            int n5 = position.getOffset();
                            n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n5);
                            int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n5);
                            int n7 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n5);
                            if (n7 >= n6) {
                                ++n2;
                            }
                            Integer n8 = (Integer)linkedHashMap.get(n2);
                            linkedHashMap.put(n2, n8 == null ? n32 : n8 + n32);
                        }
                        int n9 = 0;
                        for (int i = 0; i < n4; ++i) {
                            Integer n10;
                            n32 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                            Integer n11 = (Integer)linkedHashMap.get(i);
                            if (n11 != null) assert ((n9 += n11.intValue()) >= 0) : "currentIndent < 0";
                            if (PHPFormatter.this.lineUnformattable(baseDocument, n32)) continue;
                            n2 = 0;
                            if (map2 != null && (n10 = (Integer)map2.get(i)) != null) {
                                n2 = n10;
                            }
                            if (i == n3) {
                                n = n9 - GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n32) - n2;
                            }
                            if (n32 < context.startOffset() || n32 > context.endOffset()) continue;
                            int n12 = 0;
                            if (n9 + n2 > n) {
                                n12 = n9 + n2 - n;
                            }
                            GsfUtilities.setLineIndentation((BaseDocument)baseDocument, (int)n32, (int)n12);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }
}

