/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FmtOptions {
    public static final String expandTabToSpaces = "expand-tabs";
    public static final String tabSize = "tab-size";
    public static final String spacesPerTab = "spaces-per-tab";
    public static final String indentSize = "indent-shift-width";
    public static final String continuationIndentSize = "continuationIndentSize";
    public static final String reformatComments = "reformatComments";
    public static final String indentHtml = "indentHtml";
    public static final String rightMargin = "text-limit-width";
    public static final String openingBraceStyle = "openingBraceStyle";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String OBRACE_NEWLINE = "ob.new_line";
    public static final String OBRACE_SAMELINE = "ob.sameline_line";
    public static final String OBRACE_PRESERVE = "ob.preserve";
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String string) {
        return Integer.parseInt(defaults.get(string));
    }

    public static boolean getDefaultAsBoolean(String string) {
        return Boolean.parseBoolean(defaults.get(string));
    }

    public static String getDefaultAsString(String string) {
        return defaults.get(string);
    }

    private static void createDefaults() {
        String[][] stringArrayArray = new String[][]{{expandTabToSpaces, TRUE}, {tabSize, "8"}, {indentSize, "4"}, {continuationIndentSize, "4"}, {reformatComments, FALSE}, {indentHtml, TRUE}, {rightMargin, "80"}, {openingBraceStyle, OBRACE_SAMELINE}};
        defaults = new HashMap<String, String>();
        for (String[] stringArray : stringArrayArray) {
            defaults.put(stringArray[0], stringArray[1]);
        }
    }

    public static boolean isInteger(String string) {
        String string2 = defaults.get(string);
        try {
            Integer.parseInt(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static {
        FmtOptions.createDefaults();
    }

    public static interface CodeStyleProducer {
        public CodeStyle create(Preferences var1);
    }

    public static final class ProxyPreferences
    extends AbstractPreferences {
        private final Preferences[] delegates;

        public ProxyPreferences(Preferences ... preferencesArray) {
            super(null, "");
            this.delegates = preferencesArray;
        }

        protected void putSpi(String string, String string2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String getSpi(String string) {
            for (Preferences preferences : this.delegates) {
                String string2 = preferences.get(string, null);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        protected void removeSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            HashSet<String> hashSet = new HashSet<String>();
            for (Preferences preferences : this.delegates) {
                hashSet.addAll(Arrays.asList(preferences.keys()));
            }
            return hashSet.toArray(new String[hashSet.size()]);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        protected void putSpi(String string, String string2) {
            this.map.put(string, string2);
        }

        protected String getSpi(String string) {
            return (String)this.map.get(string);
        }

        protected void removeSpi(String string) {
            this.map.remove(string);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] stringArray = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(stringArray);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategorySupport
    implements ActionListener,
    DocumentListener,
    PreviewProvider,
    PreferencesCustomizer {
        public static final String OPTION_ID = "org.netbeans.modules.php.editor.indent.FormatingOptions.ID";
        private static final int LOAD = 0;
        private static final int STORE = 1;
        private static final int ADD_LISTENERS = 2;
        private static final ComboItem[] bracePlacement = new ComboItem[]{new ComboItem("ob.new_line", "LBL_bp_NEWLINE"), new ComboItem("ob.sameline_line", "LBL_bp_SAMELINE"), new ComboItem("ob.preserve", "LBL_bp_PRESERVE")};
        private final String previewText;
        private final String id;
        protected final JPanel panel;
        private final List<JComponent> components = new LinkedList<JComponent>();
        private JEditorPane previewPane;
        private final Preferences preferences;
        private final Preferences previewPrefs;

        protected CategorySupport(Preferences preferences, String string, JPanel jPanel, String string2, String[] ... stringArray) {
            this.preferences = preferences;
            this.id = string;
            this.panel = jPanel;
            this.previewText = string2 != null ? string2 : NbBundle.getMessage(FmtOptions.class, (String)"SAMPLE_Default");
            this.scan(jPanel, this.components);
            PreviewPreferences previewPreferences = new PreviewPreferences();
            for (String[] stringArray2 : stringArray) {
                ((Preferences)previewPreferences).put(stringArray2[0], stringArray2[1]);
            }
            this.previewPrefs = new ProxyPreferences(preferences, previewPreferences);
            this.loadFrom(preferences);
            this.addListeners();
        }

        protected void addListeners() {
            this.scan(2, null);
        }

        protected void loadFrom(Preferences preferences) {
            this.scan(0, preferences);
        }

        protected void storeTo(Preferences preferences) {
            this.scan(1, preferences);
        }

        protected void notifyChanged() {
            this.storeTo(this.preferences);
            this.refreshPreview();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.notifyChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.notifyChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.notifyChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.notifyChanged();
        }

        public JComponent getPreviewComponent() {
            if (this.previewPane == null) {
                this.previewPane = new JEditorPane();
                this.previewPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtOptions.class, (String)"AN_Preview"));
                this.previewPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtOptions.class, (String)"AD_Preview"));
                this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-php5"));
                this.previewPane.setEditable(false);
            }
            return this.previewPane;
        }

        public void refreshPreview() {
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public String getDisplayName() {
            return this.panel.getName();
        }

        public String getId() {
            return this.id;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        private void performOperation(int n, JComponent jComponent, String string, Preferences preferences) {
            switch (n) {
                case 0: {
                    this.loadData(jComponent, string, preferences);
                    break;
                }
                case 1: {
                    this.storeData(jComponent, string, preferences);
                    break;
                }
                case 2: {
                    this.addListener(jComponent);
                }
            }
        }

        private void scan(int n, Preferences preferences) {
            for (JComponent jComponent : this.components) {
                Object object = jComponent.getClientProperty(OPTION_ID);
                if (object instanceof String) {
                    this.performOperation(n, jComponent, (String)object, preferences);
                    continue;
                }
                if (!(object instanceof String[])) continue;
                for (String string : (String[])object) {
                    this.performOperation(n, jComponent, string, preferences);
                }
            }
        }

        private void scan(Container container, List<JComponent> list) {
            for (Component component : container.getComponents()) {
                JComponent jComponent;
                Object object;
                if (component instanceof JComponent && ((object = (jComponent = (JComponent)component).getClientProperty(OPTION_ID)) instanceof String || object instanceof String[])) {
                    list.add(jComponent);
                }
                if (!(component instanceof Container)) continue;
                this.scan((Container)component, list);
            }
        }

        private void loadData(JComponent jComponent, String string, Preferences preferences) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.setText(preferences.get(string, FmtOptions.getDefaultAsString(string)));
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                boolean bl = FmtOptions.getDefaultAsBoolean(string);
                jCheckBox.setSelected(preferences.getBoolean(string, bl));
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                String string2 = preferences.get(string, FmtOptions.getDefaultAsString(string));
                ComboBoxModel comboBoxModel = this.createModel(string2);
                jComboBox.setModel(comboBoxModel);
                ComboItem comboItem = CategorySupport.whichItem(string2, comboBoxModel);
                jComboBox.setSelectedItem(comboItem);
            }
        }

        private void storeData(JComponent jComponent, String string, Preferences preferences) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                String string2 = jTextField.getText();
                if (FmtOptions.isInteger(string)) {
                    try {
                        int n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                if (!string.equals(FmtOptions.tabSize) && !string.equals(FmtOptions.spacesPerTab) && !string.equals(FmtOptions.indentSize) && FmtOptions.getDefaultAsString(string).equals(string2)) {
                    preferences.remove(string);
                } else {
                    preferences.put(string, string2);
                }
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                if (!string.equals(FmtOptions.expandTabToSpaces) && FmtOptions.getDefaultAsBoolean(string) == jCheckBox.isSelected()) {
                    preferences.remove(string);
                } else {
                    preferences.putBoolean(string, jCheckBox.isSelected());
                }
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                String string3 = ((ComboItem)jComboBox.getSelectedItem()).value;
                if (FmtOptions.getDefaultAsString(string).equals(string3)) {
                    preferences.remove(string);
                } else {
                    preferences.put(string, string3);
                }
            }
        }

        private void addListener(JComponent jComponent) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.addActionListener(this);
                jTextField.getDocument().addDocumentListener(this);
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                jCheckBox.addActionListener(this);
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                jComboBox.addActionListener(this);
            }
        }

        private ComboBoxModel createModel(String string) {
            for (ComboItem comboItem : bracePlacement) {
                if (!string.equals(comboItem.value)) continue;
                return new DefaultComboBoxModel<ComboItem>(bracePlacement);
            }
            return null;
        }

        private static ComboItem whichItem(String string, ComboBoxModel comboBoxModel) {
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                ComboItem comboItem = (ComboItem)comboBoxModel.getElementAt(i);
                if (!string.equals(comboItem.value)) continue;
                return comboItem;
            }
            return null;
        }

        private static class ComboItem {
            String value;
            String displayName;

            public ComboItem(String string, String string2) {
                this.value = string;
                this.displayName = NbBundle.getMessage(FmtOptions.class, (String)string2);
            }

            public String toString() {
                return this.displayName;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Factory
        implements PreferencesCustomizer.Factory {
            private final String id;
            private final Class<? extends JPanel> panelClass;
            private final String previewText;
            private final String[][] forcedOptions;

            public Factory(String string, Class<? extends JPanel> clazz, String string2, String[] ... stringArray) {
                this.id = string;
                this.panelClass = clazz;
                this.previewText = string2;
                this.forcedOptions = stringArray;
            }

            public PreferencesCustomizer create(Preferences preferences) {
                try {
                    return new CategorySupport(preferences, this.id, this.panelClass.newInstance(), this.previewText, this.forcedOptions);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }
}

