/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.actions.PopupUtil;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportModulePanel
extends JPanel {
    private final String ident;
    private ParserResult info;
    private DefaultListModel model;
    private final int position;
    public JLabel ctrlLabel;
    public JLabel importPreviewLabel;
    public JLabel jLabel1;
    public JList jList1;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;

    public ImportModulePanel(String string, List<String> list, List<String> list2, Font font, ParserResult parserResult, int n) {
        this.ident = string;
        this.info = parserResult;
        this.position = n;
        this.createModel(list, list2);
        this.initComponents();
        this.setBackground(this.jList1.getBackground());
        if (this.model.size() > 0) {
            int n2;
            this.jList1.setModel(this.model);
            this.setFocusable(false);
            this.setNextFocusableComponent(this.jList1);
            this.jScrollPane1.setBackground(this.jList1.getBackground());
            this.setBackground(this.jList1.getBackground());
            if (font != null) {
                this.jList1.setFont(font);
            }
            if ((n2 = this.jList1.getModel().getSize()) > 0) {
                this.jList1.setSelectedIndex(0);
            }
            this.jList1.setVisibleRowCount(n2 > 8 ? 8 : n2);
            this.jList1.setCellRenderer(new Renderer(this.jList1));
            this.jList1.grabFocus();
        } else {
            this.remove(this.jScrollPane1);
            JLabel jLabel = new JLabel(NbBundle.getMessage(ImportModulePanel.class, (String)"NoModsFound"));
            if (font != null) {
                jLabel.setFont(font);
            }
            jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
            jLabel.setEnabled(false);
            jLabel.setBackground(this.jList1.getBackground());
            this.add(jLabel);
        }
        this.setA11Y();
        this.updatePreview(null);
    }

    private void setA11Y() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_ACSD"));
        this.jList1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_JList1_ACN"));
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_JList1_ACSD"));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.ctrlLabel = new JLabel();
        this.importPreviewLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setBorder(BorderFactory.createLineBorder(new Color(64, 64, 64)));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.jList1.setSelectionMode(0);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ImportModulePanel.this.listMouseReleased(mouseEvent);
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ImportModulePanel.this.updatePreview(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ImportModulePanel.this.listKeyReleased(keyEvent);
                ImportModulePanel.this.updatePreview(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setLabelFor(this.jList1);
        this.jLabel1.setText(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportChoices"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jLabel1.setOpaque(true);
        this.add((Component)this.jLabel1, "First");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.ctrlLabel.setText(NbBundle.getMessage(ImportModulePanel.class, (String)"LBL_PackageImport"));
        this.importPreviewLabel.setText(" ");
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.ctrlLabel, -1, 390, Short.MAX_VALUE).add((Component)this.importPreviewLabel, -1, 390, Short.MAX_VALUE).add(2, (Component)this.jSeparator1, -1, 390, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.ctrlLabel).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.importPreviewLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Last");
    }

    private void listMouseReleased(MouseEvent mouseEvent) {
        boolean bl = (mouseEvent.getModifiers() & 8) > 0;
        boolean bl2 = (mouseEvent.getModifiers() & 1) > 0;
        this.importModule(this.getSelected(), bl, bl2);
    }

    private void listKeyReleased(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (keyStroke.getKeyCode() == 10 || keyStroke.getKeyCode() == 32) {
            boolean bl = (keyEvent.getModifiers() & 8) > 0;
            boolean bl2 = (keyEvent.getModifiers() & 1) > 0;
            this.importModule(this.getSelected(), bl, bl2);
        }
    }

    private void updatePreview(KeyEvent keyEvent) {
        Object e = this.jList1.getSelectedValue();
        if (e != null) {
            String string = "<html><code><b>" + ((TypeDescription)e).qualifiedName + "</b></code></html>";
            this.importPreviewLabel.setText(string);
        }
    }

    public String getSelected() {
        TypeDescription typeDescription = (TypeDescription)this.jList1.getSelectedValue();
        return typeDescription == null ? null : typeDescription.qualifiedName;
    }

    private void createModel(List<String> list, List<String> list2) {
        ArrayList<TypeDescription> arrayList = new ArrayList<TypeDescription>(list.size());
        for (String object : list) {
            arrayList.add(new TypeDescription(object, false));
        }
        for (String string : list2) {
            arrayList.add(new TypeDescription(string, true));
        }
        Collections.sort(arrayList);
        this.model = new DefaultListModel();
        for (TypeDescription typeDescription : arrayList) {
            this.model.addElement(typeDescription);
        }
    }

    private void importModule(String string, boolean bl, boolean bl2) {
        EditList editList;
        PopupUtil.hidePopup();
        int n = bl ? this.position : -1;
        BaseDocument baseDocument = (BaseDocument)this.info.getSnapshot().getSource().getDocument(false);
        if (!bl) {
            editList = LexUtilities.getPHPTokenSequence((Document)baseDocument, this.position);
            editList.move(this.position);
            while (editList.movePrevious()) {
                Token token = editList.token();
                if (!((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPENTAG)) continue;
                n = editList.offset();
            }
        }
        if (n != -1) {
            editList = new EditList(baseDocument);
            try {
                int n2 = bl ? Utilities.getRowStart((BaseDocument)baseDocument, (int)this.position) : Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                string = bl ? string + "\n" : "\n" + string;
                editList.replace(n2, 0, string, true, 0);
                editList.setFormatAll(true);
                editList.apply();
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDescription
    implements Comparable<TypeDescription> {
        private boolean isDenied;
        private final ElementKind kind;
        private final String qualifiedName;

        public TypeDescription(String string, boolean bl) {
            this.isDenied = bl;
            this.kind = ElementKind.MODULE;
            this.qualifiedName = string;
        }

        @Override
        public int compareTo(TypeDescription typeDescription) {
            if (this.isDenied && !typeDescription.isDenied) {
                return 1;
            }
            if (!this.isDenied && typeDescription.isDenied) {
                return -1;
            }
            return this.qualifiedName.compareTo(typeDescription.qualifiedName);
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static int DARKER_COLOR_COMPONENT;
        private static int LIGHTER_COLOR_COMPONENT;
        private Color denidedColor = new Color(128, 128, 128);
        private Color fgColor;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;

        public Renderer(JList jList) {
            this.setFont(jList.getFont());
            this.fgColor = jList.getForeground();
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setForeground(this.fgSelectionColor);
                this.setBackground(this.bgSelectionColor);
            } else {
                this.setForeground(this.fgColor);
                this.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof TypeDescription) {
                TypeDescription typeDescription = (TypeDescription)object;
                this.setText(typeDescription.qualifiedName);
                if (typeDescription.isDenied) {
                    this.setForeground(this.denidedColor);
                }
                this.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/editor/resources/interface.png")));
            } else {
                this.setText(object.toString());
            }
            return this;
        }

        static {
            LIGHTER_COLOR_COMPONENT = DARKER_COLOR_COMPONENT = 5;
        }
    }
}

