/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPDocCommentTokenId;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPDOCCodeCompletion {
    private static final String[] TAGS = new String[]{"abstract", "access", "author", "category", "copyright", "deprecated", "example", "final", "filesource", "global", "ignore", "internal", "license", "link", "method", "name", "package", "param", "property", "property-read", "property-write", "return", "see", "since", "static", "staticvar", "subpackage", "todo", "tutorial", "uses", "var", "version"};
    private static final Map<String, String> CUSTOM_TEMPLATES = new TreeMap<String, String>();
    private static String docURLBase;
    private static Collection<PHPDocCommentTokenId> TYPE_TOKENS;

    static boolean isTypeCtx(PHPCompletionItem.CompletionRequest completionRequest) {
        Document document = completionRequest.info.getSnapshot().getSource().getDocument(false);
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(document, completionRequest.anchor);
        if (tokenSequence != null) {
            tokenSequence.move(completionRequest.anchor);
            tokenSequence.moveNext();
            TokenSequence tokenSequence2 = tokenSequence.embedded(PHPDocCommentTokenId.language());
            tokenSequence2.move(completionRequest.anchor);
            if (tokenSequence2.movePrevious() && TYPE_TOKENS.contains(tokenSequence2.token().id())) {
                int n = tokenSequence2.offset() + tokenSequence2.token().length();
                try {
                    String string = document.getText(n, completionRequest.anchor - n);
                    if (string.charAt(string.length() - 1) == '|') {
                        string = string.trim();
                        for (int i = 0; i < string.length(); ++i) {
                            if (!Character.isWhitespace(string.charAt(i))) continue;
                            return false;
                        }
                        return true;
                    }
                    for (int i = 0; i < string.length(); ++i) {
                        if (Character.isWhitespace(string.charAt(i))) continue;
                        return false;
                    }
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        }
        return false;
    }

    public static void complete(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        if (completionRequest.prefix.length() != 0 && !completionRequest.prefix.startsWith("@")) {
            return;
        }
        String string = completionRequest.prefix.length() == 0 ? completionRequest.prefix : completionRequest.prefix.substring(1);
        for (String string2 : TAGS) {
            if (!string2.startsWith(string)) continue;
            PHPDOCCodeCompletionItem pHPDOCCodeCompletionItem = new PHPDOCCodeCompletionItem(completionRequest, string2);
            list.add(pHPDOCCodeCompletionItem);
        }
    }

    public static String getDoc(String string) {
        String string2 = String.format("%s%s.desc", docURLBase, string);
        try {
            URL uRL = new URL(string2);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[1000];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n > 0);
            inputStream.close();
            String string3 = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
            return string3;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        TYPE_TOKENS = Arrays.asList(PHPDocCommentTokenId.PHPDOC_RETURN, PHPDocCommentTokenId.PHPDOC_VAR, PHPDocCommentTokenId.PHPDOC_PARAM, PHPDocCommentTokenId.PHPDOC_PROPERTY, PHPDocCommentTokenId.PHPDOC_PROPERTY_READ, PHPDocCommentTokenId.PHPDOC_PROPERTY_WRITE);
        File file = InstalledFileLocator.getDefault().locate("docs/phpdocdesc.zip", null, true);
        if (file != null) {
            try {
                URL uRL = file.toURL();
                uRL = FileUtil.getArchiveRoot((URL)uRL);
                docURLBase = uRL.toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PHPDOCCodeCompletionItem
    implements CompletionProposal {
        private String tag;
        private PHPCompletionItem.CompletionRequest request;
        private PHPDOCTagElement elem;

        public PHPDOCCodeCompletionItem(PHPCompletionItem.CompletionRequest completionRequest, String string) {
            this.tag = string;
            this.request = completionRequest;
            this.elem = new PHPDOCTagElement(string);
        }

        public int getAnchorOffset() {
            return this.request.anchor;
        }

        public ElementHandle getElement() {
            return this.elem;
        }

        public String getName() {
            return "@" + this.tag;
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.getName());
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return "";
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public ImageIcon getIcon() {
            return null;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return (String)CUSTOM_TEMPLATES.get(this.tag);
        }
    }
}

