/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PHPCompletionItem
implements CompletionProposal {
    private static final String PHP_KEYWORD_ICON = "org/netbeans/modules/php/editor/resources/php16Key.png";
    protected static ImageIcon keywordIcon = null;
    protected final CompletionRequest request;
    private final ElementHandle element;

    PHPCompletionItem(ElementHandle elementHandle, CompletionRequest completionRequest) {
        this.request = completionRequest;
        this.element = elementHandle;
        keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)PHP_KEYWORD_ICON));
    }

    public int getAnchorOffset() {
        return this.request.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getSortText() {
        IndexedElement indexedElement;
        if (this.getElement() instanceof IndexedElement && (indexedElement = (IndexedElement)this.getElement()).isResolved()) {
            return "-" + this.getName();
        }
        return this.getName();
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        htmlFormatter.appendText(this.getName());
        return htmlFormatter.getText();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        Set set = Collections.emptySet();
        ElementHandle elementHandle = this.getElement();
        return elementHandle != null ? elementHandle.getModifiers() : set;
    }

    public boolean isSmart() {
        if (this.getElement() instanceof IndexedElement) {
            IndexedElement indexedElement = (IndexedElement)this.getElement();
            String string = indexedElement.getFilenameUrl();
            return string != null && string.equals(this.request.currentlyEditedFileURL);
        }
        return false;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        if (this.element.getIn() != null) {
            htmlFormatter.appendText(this.element.getIn());
            return htmlFormatter.getText();
        }
        if (this.element instanceof IndexedElement) {
            IndexedElement indexedElement = (IndexedElement)this.element;
            if (indexedElement.isPlatform()) {
                return NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform");
            }
            String string = indexedElement.getFilenameUrl();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
        }
        return null;
    }

    public static ImageIcon getInterfaceIcon() {
        return InterfaceItem.icon();
    }

    static class CompletionRequest {
        public int anchor;
        public PHPParseResult result;
        public ParserResult info;
        public String prefix;
        public String currentlyEditedFileURL;
        PHPIndex index;

        CompletionRequest() {
        }
    }

    public static class FunctionDeclarationItem
    extends FunctionItem {
        private boolean isIface;

        public FunctionDeclarationItem(IndexedFunction indexedFunction, CompletionRequest completionRequest, int n, boolean bl) {
            super(indexedFunction, completionRequest, n);
            this.isIface = bl;
        }

        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getFunction().getModifiersString();
            if (string.length() != 0) {
                string = string.replace("abstract", "").trim();
                stringBuilder.append(string);
            }
            stringBuilder.append(" ").append("function");
            stringBuilder.append(this.getNameAndFunctionBodyForTemplate());
            return stringBuilder.toString();
        }

        protected String getNameAndFunctionBodyForTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getFunction().getFunctionSignature();
            stringBuilder.append(" ").append(string);
            stringBuilder.append(" ").append("{\n");
            stringBuilder.append(this.getFunctionBodyForTemplate());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        protected String getFunctionBodyForTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isIface) {
                stringBuilder.append("${cursor};\n");
            } else {
                String string = this.getFunction().getFunctionSignature();
                stringBuilder.append("${cursor}parent::" + string.replace("&$", "$") + ";\n");
            }
            return stringBuilder.toString();
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.getLhsHtml(htmlFormatter));
            stringBuilder.append(' ').append(NbBundle.getMessage(PHPCompletionItem.class, (String)"Generate"));
            return stringBuilder.toString();
        }

        public boolean isSmart() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FunctionItem
    extends PHPCompletionItem {
        private int optionalArgCount = 0;

        FunctionItem(IndexedFunction indexedFunction, CompletionRequest completionRequest, int n) {
            super(indexedFunction, completionRequest);
            this.optionalArgCount = n;
        }

        public IndexedFunction getFunction() {
            return (IndexedFunction)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append("(");
            List<String> list = this.getInsertParams();
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                stringBuilder.append("${php-cc-");
                stringBuilder.append(Integer.toString(i));
                stringBuilder.append(" default=\"");
                if (string.startsWith("&")) {
                    string = string.substring(1);
                }
                stringBuilder.append(string);
                stringBuilder.append("\"}");
                if (i >= list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            if (this.emphasisName()) {
                htmlFormatter.emphasis(true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.emphasis(false);
            } else {
                htmlFormatter.appendText(this.getName());
            }
            htmlFormatter.name(elementKind, false);
            htmlFormatter.appendHtml("(");
            htmlFormatter.parameters(true);
            this.appendParamsStr(htmlFormatter);
            htmlFormatter.parameters(false);
            htmlFormatter.appendHtml(")");
            return htmlFormatter.getText();
        }

        protected boolean emphasisName() {
            return this.getFunction().isResolved();
        }

        public List<String> getInsertParams() {
            LinkedList<String> linkedList = new LinkedList<String>();
            String[] stringArray = this.getFunction().getParameters().toArray(new String[0]);
            boolean[] blArray = new boolean[stringArray.length];
            int[] nArray = this.getFunction().getOptionalArgs();
            int n = 0;
            int n2 = this.optionalArgCount;
            while (n < nArray.length) {
                if (n2 <= 0) {
                    blArray[nArray[n]] = true;
                }
                ++n;
                --n2;
            }
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                if (blArray[n]) continue;
                linkedList.add(string);
            }
            return linkedList;
        }

        @Override
        public String getSortText() {
            int n = this.optionalArgCount;
            return this.getName() + n;
        }

        private void appendParamsStr(HtmlFormatter htmlFormatter) {
            String[] stringArray = this.getFunction().getParameters().toArray(new String[0]);
            int[] nArray = this.getFunction().getOptionalArgs();
            boolean[] blArray = new boolean[stringArray.length];
            boolean[] blArray2 = new boolean[stringArray.length];
            int n = 0;
            int n2 = this.optionalArgCount;
            while (n < nArray.length) {
                blArray2[nArray[n]] = true;
                if (n2 <= 0) {
                    blArray[nArray[n]] = true;
                }
                ++n;
                --n2;
            }
            n = 1;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (blArray[n2]) continue;
                String string = stringArray[n2];
                if (string.startsWith("&")) {
                    string = string.substring(1);
                }
                if (n != 0) {
                    n = 0;
                } else {
                    htmlFormatter.appendText(", ");
                }
                if (blArray2[n2]) {
                    htmlFormatter.appendText(string);
                    continue;
                }
                htmlFormatter.emphasis(true);
                htmlFormatter.appendText(string);
                htmlFormatter.emphasis(false);
            }
        }
    }

    static class NewClassItem
    extends FunctionItem {
        public NewClassItem(IndexedFunction indexedFunction, CompletionRequest completionRequest, int n) {
            super(indexedFunction, completionRequest, n);
        }

        public String getName() {
            String string = this.getElement().getIn();
            return string != null ? string : super.getName();
        }

        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    static class MagicMethodItem
    extends FunctionDeclarationItem {
        public MagicMethodItem(IndexedFunction indexedFunction, CompletionRequest completionRequest) {
            super(indexedFunction, completionRequest, 0, false);
        }

        public boolean isSmart() {
            return false;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            return super.getLhsHtml(htmlFormatter);
        }

        protected boolean emphasisName() {
            return false;
        }

        protected String getFunctionBodyForTemplate() {
            return "${cursor};\n";
        }
    }

    static class MagicMethodNameItem
    extends MagicMethodItem {
        public MagicMethodNameItem(IndexedFunction indexedFunction, CompletionRequest completionRequest) {
            super(indexedFunction, completionRequest);
        }

        public String getCustomInsertTemplate() {
            return super.getNameAndFunctionBodyForTemplate();
        }
    }

    static class ReturnItem
    extends KeywordItem {
        public ReturnItem(CompletionRequest completionRequest) {
            super("return", completionRequest);
        }

        public String getCustomInsertTemplate() {
            return "return ${cursor};";
        }
    }

    static class SpecialFunctionItem
    extends KeywordItem {
        public SpecialFunctionItem(String string, CompletionRequest completionRequest) {
            super(string, completionRequest);
        }

        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append(" '${cursor}';");
            return stringBuilder.toString();
        }
    }

    static class ClassConstantItem
    extends VariableItem {
        ClassConstantItem(IndexedConstant indexedConstant, CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }
    }

    static class UnUniqueVaraibaleItems
    extends VariableItem {
        public UnUniqueVaraibaleItems(IndexedConstant indexedConstant, CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.type(true);
            htmlFormatter.appendText("?");
            htmlFormatter.type(false);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return "";
        }
    }

    static class VariableItem
    extends PHPCompletionItem {
        private boolean insertDollarPrefix = true;

        VariableItem(IndexedConstant indexedConstant, CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            String string = ((IndexedConstant)this.getElement()).getTypeName();
            if (string == null) {
                string = "?";
            }
            htmlFormatter.type(true);
            htmlFormatter.appendText(string);
            htmlFormatter.type(false);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        public String getName() {
            String string = super.getName();
            if (!this.insertDollarPrefix && string.startsWith("$")) {
                return string.substring(1);
            }
            return string;
        }

        void doNotInsertDollarPrefix() {
            this.insertDollarPrefix = false;
        }
    }

    static class InterfaceItem
    extends PHPCompletionItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";
        private static ImageIcon INTERFACE_ICON = null;

        InterfaceItem(IndexedInterface indexedInterface, CompletionRequest completionRequest) {
            super(indexedInterface, completionRequest);
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        private static ImageIcon icon() {
            if (INTERFACE_ICON == null) {
                INTERFACE_ICON = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return INTERFACE_ICON;
        }

        public ImageIcon getIcon() {
            return InterfaceItem.icon();
        }
    }

    static class ClassItem
    extends PHPCompletionItem {
        private boolean endWithDoubleColon;

        ClassItem(IndexedClass indexedClass, CompletionRequest completionRequest) {
            this(indexedClass, completionRequest, false);
        }

        ClassItem(IndexedClass indexedClass, CompletionRequest completionRequest, boolean bl) {
            super(indexedClass, completionRequest);
            this.endWithDoubleColon = bl;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        public String getCustomInsertTemplate() {
            if (this.endWithDoubleColon) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getName());
                stringBuilder.append("::${cursor}");
                return stringBuilder.toString();
            }
            return super.getCustomInsertTemplate();
        }
    }

    static class ConstantItem
    extends PHPCompletionItem {
        private IndexedConstant constant = null;

        ConstantItem(IndexedConstant indexedConstant, CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
            this.constant = indexedConstant;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            IndexedConstant indexedConstant = (IndexedConstant)this.getElement();
            htmlFormatter.name(this.getKind(), true);
            if (indexedConstant.isResolved()) {
                htmlFormatter.emphasis(true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.emphasis(false);
            } else {
                htmlFormatter.appendText(this.getName());
            }
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.GLOBAL;
        }
    }

    static class SuperGlobalItem
    extends PHPCompletionItem {
        private String name;

        public SuperGlobalItem(CompletionRequest completionRequest, String string) {
            super(new PredefinedSymbolElement(string), completionRequest);
            this.name = string;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.emphasis(true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.emphasis(false);
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public String getName() {
            return "$" + this.name;
        }

        public String getCustomInsertTemplate() {
            return super.getCustomInsertTemplate();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform"));
            return htmlFormatter.getText();
        }

        public String getDocumentation() {
            return null;
        }

        public ImageIcon getIcon() {
            return keywordIcon;
        }
    }

    static class KeywordItem
    extends PHPCompletionItem {
        private String description = null;
        private String keyword = null;
        private static final List<String> CLS_KEYWORDS = Arrays.asList(PHPCodeCompletion.PHP_CLASS_KEYWORDS);

        KeywordItem(String string, CompletionRequest completionRequest) {
            super(null, completionRequest);
            this.keyword = string;
        }

        public String getName() {
            return this.keyword;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.name(this.getKind(), true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(this.getKind(), false);
            return htmlFormatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ImageIcon getIcon() {
            return keywordIcon;
        }

        public boolean isSmart() {
            return CLS_KEYWORDS.contains(this.getName()) ? true : super.isSmart();
        }

        public String getCustomInsertTemplate() {
            StringBuilder stringBuilder = new StringBuilder();
            CompletionContextFinder.KeywordCompletionType keywordCompletionType = PHPCodeCompletion.PHP_KEYWORDS.get(this.getName());
            if (keywordCompletionType == null) {
                return null;
            }
            switch (keywordCompletionType) {
                case SIMPLE: {
                    stringBuilder.append(this.getName());
                    break;
                }
                case ENDS_WITH_SPACE: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" (${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" {${cursor}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    stringBuilder.append(this.getName());
                    stringBuilder.append(" ${cursor}:");
                    break;
                }
                default: {
                    assert (false) : keywordCompletionType.toString();
                    break;
                }
            }
            return stringBuilder.toString();
        }
    }
}

