/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CCDocHtmlFormatter;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.PHPDocParamTagData;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class DocRenderer {
    private static final String TD_STYLE = "style=\"text-aling:left; border-width: 1px;padding: 1px;border-style: solid;border-color: gray;padding:3px\" ";
    private static final String TABLE_STYLE = "style=\"border-style:solid; border-color: black; border-width: 1px; width: 100%; border-collapse: collapse;\"";
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());

    DocRenderer() {
    }

    static String document(ParserResult parserResult, ElementHandle elementHandle) {
        if (elementHandle instanceof PHPDOCTagElement) {
            PHPDOCTagElement pHPDOCTagElement = (PHPDOCTagElement)elementHandle;
            return pHPDOCTagElement.getDoc();
        }
        if (elementHandle instanceof PredefinedSymbolElement) {
            PredefinedSymbolElement predefinedSymbolElement = (PredefinedSymbolElement)elementHandle;
            return predefinedSymbolElement.getDoc();
        }
        if (elementHandle instanceof IndexedElement) {
            return DocRenderer.documentIndexedElement(parserResult, (IndexedElement)elementHandle);
        }
        return null;
    }

    private static String documentIndexedElement(ParserResult parserResult, IndexedElement indexedElement) {
        Object object;
        Project project;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        CCDocHtmlFormatter cCDocHtmlFormatter = new CCDocHtmlFormatter();
        String string = null;
        if (indexedElement.isPlatform()) {
            string = NbBundle.getMessage(DocRenderer.class, (String)"PHPPlatform");
        } else {
            object2 = indexedElement.getFileObject();
            if (object2 != null) {
                project = FileOwnerQuery.getOwner((FileObject)object2);
                if (project != null) {
                    object = ProjectUtils.getSources((Project)project);
                    for (SourceGroup sourceGroup : object.getSourceGroups("PHPSOURCE")) {
                        String string2 = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)object2);
                        if (string2 == null) continue;
                        string = string2;
                        break;
                    }
                    if (string == null) {
                        string = object2.getPath();
                    }
                } else {
                    string = indexedElement.getFilenameUrl();
                }
            }
        }
        if (string != null) {
            cCDocHtmlFormatter.appendHtml(String.format("<div align=\"right\"><font size=-1>%s</font></div>", string));
        }
        object2 = new StringBuilder();
        if (indexedElement.getOffset() > -1) {
            project = indexedElement.getFileObject();
            if (project == null) {
                return null;
            }
            object = new PHPDocExtractor(cCDocHtmlFormatter, (StringBuilder)object2, indexedElement);
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)project)), (UserTask)object);
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        if (((StringBuilder)object2).length() > 0) {
            stringBuilder.append((CharSequence)object2);
        } else {
            stringBuilder.append(NbBundle.getMessage(DocRenderer.class, (String)"PHPDocNotFound"));
        }
        return cCDocHtmlFormatter.getText() + stringBuilder.toString();
    }

    private static class PHPDocExtractor
    extends UserTask {
        private CCDocHtmlFormatter header;
        private StringBuilder phpDoc;
        private IndexedElement indexedElement;

        public PHPDocExtractor(CCDocHtmlFormatter cCDocHtmlFormatter, StringBuilder stringBuilder, IndexedElement indexedElement) {
            this.header = cCDocHtmlFormatter;
            this.phpDoc = stringBuilder;
            this.indexedElement = indexedElement;
        }

        public void cancel() {
        }

        private void doFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            String string = CodeUtils.extractFunctionName(functionDeclaration);
            this.header.appendHtml("<font size=\"+1\">");
            this.header.name(ElementKind.METHOD, true);
            this.header.appendText(string);
            this.header.name(ElementKind.METHOD, false);
            this.header.appendHtml("</font>");
            this.header.parameters(true);
            this.header.appendText("(");
            int n = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < n; ++i) {
                FormalParameter formalParameter = functionDeclaration.getFormalParameters().get(i);
                if (formalParameter.getParameterType() != null) {
                    this.header.type(true);
                    this.header.appendText(formalParameter.getParameterType().getName() + " ");
                    this.header.type(false);
                }
                this.header.appendText(CodeUtils.getParamDisplayName(formalParameter));
                if (formalParameter.getDefaultValue() != null) {
                    this.header.type(true);
                    this.header.appendText("=");
                    if (formalParameter.getDefaultValue() instanceof Scalar) {
                        Scalar scalar = (Scalar)formalParameter.getDefaultValue();
                        this.header.appendText(scalar.getStringValue());
                    }
                    this.header.type(false);
                }
                if (i + 1 >= n) continue;
                this.header.appendText(", ");
            }
            this.header.appendText(")");
            this.header.parameters(false);
        }

        private void extractPHPDoc(PHPDocBlock pHPDocBlock) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = new StringBuilder();
            this.phpDoc.append(pHPDocBlock.getDescription());
            this.phpDoc.append("<br />\n");
            block5: for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                switch (pHPDocTag.getKind()) {
                    case PARAM: {
                        PHPDocParamTagData pHPDocParamTagData = new PHPDocParamTagData(pHPDocTag.getValue());
                        String string = String.format("<tr><td valign=\"top\" %s>%s</td><td valign=\"top\" %s><b>%s</b></td><td valign=\"top\" %s>%s</td></tr>\n", DocRenderer.TD_STYLE, pHPDocParamTagData.type, DocRenderer.TD_STYLE, pHPDocParamTagData.name, DocRenderer.TD_STYLE, pHPDocParamTagData.description);
                        stringBuilder.append(string);
                        break;
                    }
                    case LINK: {
                        String string = String.format("<a href=\"%s\">%s</a><br>\n", pHPDocTag.getValue(), pHPDocTag.getValue());
                        stringBuilder2.append(string);
                        break;
                    }
                    case RETURN: {
                        String[] stringArray = pHPDocTag.getValue().split("\\s+", 2);
                        if (stringArray.length <= 0) continue block5;
                        String string = stringArray[0];
                        stringBuilder3.append(String.format("<b>%s:</b> %s<br><br>", NbBundle.getMessage(DocRenderer.class, (String)"Type"), string));
                        if (stringArray.length <= 1) continue block5;
                        String string2 = stringArray[1];
                        stringBuilder3.append(string2);
                        break;
                    }
                    default: {
                        String string = String.format("<tr><th>%s</th><td>%s</td></tr>\n", pHPDocTag.getKind().toString(), pHPDocTag.getValue());
                        stringBuilder4.append(string);
                    }
                }
            }
            if (stringBuilder.length() > 0) {
                this.phpDoc.append("<div style=\"padding-top:3px;\"><b>");
                this.phpDoc.append(NbBundle.getMessage(DocRenderer.class, (String)"Parameters"));
                this.phpDoc.append("</b></div>\n<table cellspacing=0 style=\"border-style:solid; border-color: black; border-width: 1px; width: 100%; border-collapse: collapse;\">\n" + stringBuilder + "</table>\n");
            }
            if (stringBuilder3.length() > 0) {
                this.phpDoc.append("<h3>");
                this.phpDoc.append(NbBundle.getMessage(DocRenderer.class, (String)"ReturnValue"));
                this.phpDoc.append("</h3>\n" + stringBuilder3);
            }
            if (stringBuilder2.length() > 0) {
                this.phpDoc.append("<h3>");
                this.phpDoc.append(NbBundle.getMessage(DocRenderer.class, (String)"OnlineDocs"));
                this.phpDoc.append("</h3>\n" + stringBuilder2);
            }
            if (stringBuilder4.length() > 0) {
                this.phpDoc.append("<table>\n" + stringBuilder4 + "</table>\n");
            }
        }

        private String getElementValue(Program program, ASTNode aSTNode) {
            if (aSTNode instanceof Identifier) {
                FunctionInvocation functionInvocation;
                if ("define".equals(((Identifier)aSTNode).getName()) && (functionInvocation = (FunctionInvocation)Utils.getNodeAtOffset(program, this.indexedElement.getOffset(), FunctionInvocation.class)) != null) {
                    Expression expression;
                    assert (functionInvocation.getStartOffset() == aSTNode.getStartOffset());
                    if (functionInvocation.getParameters().size() > 1 && (expression = functionInvocation.getParameters().get(1)) instanceof Scalar) {
                        Scalar scalar = (Scalar)expression;
                        return scalar.getStringValue();
                    }
                }
            } else if (aSTNode instanceof ClassConstantDeclaration) {
                Expression expression;
                Expression expression2;
                ClassConstantDeclaration classConstantDeclaration = (ClassConstantDeclaration)aSTNode;
                int n = -1;
                for (int i = 0; i < classConstantDeclaration.getNames().size(); ++i) {
                    expression2 = classConstantDeclaration.getNames().get(i);
                    if (!((Identifier)expression2).getName().equals(this.indexedElement.getName())) continue;
                    n = i;
                    break;
                }
                if (n >= 0 && (expression = classConstantDeclaration.getInitializers().get(n)) instanceof Scalar) {
                    expression2 = (Scalar)expression;
                    return ((Scalar)expression2).getStringValue();
                }
            }
            return null;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
            Program program = Utils.getRoot(parserResult);
            if (program != null) {
                Object object;
                ASTNode aSTNode = Utils.getNodeAtOffset(program, this.indexedElement.getOffset());
                if (aSTNode == null) {
                    LOGGER.warning("Could not find AST node for element " + this.indexedElement.getName() + " defined in " + this.indexedElement.getFilenameUrl());
                    return;
                }
                if (aSTNode instanceof FunctionDeclaration) {
                    this.doFunctionDeclaration((FunctionDeclaration)aSTNode);
                } else {
                    this.header.name(this.indexedElement.getKind(), true);
                    this.header.appendText(this.indexedElement.getDisplayName());
                    this.header.name(this.indexedElement.getKind(), false);
                    object = this.getElementValue(program, aSTNode);
                    if (object != null) {
                        this.header.appendText(" = " + (String)object);
                    }
                }
                this.header.appendHtml("<br/><br/>");
                object = Utils.getCommentForNode(program, aSTNode);
                if (object instanceof PHPDocBlock) {
                    this.extractPHPDoc((PHPDocBlock)object);
                }
            }
        }
    }
}

