/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeUtils {
    public static final String FUNCTION_TYPE_PREFIX = "@fn:";
    public static final String METHOD_TYPE_PREFIX = "@mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "@static.mtd:";
    private static final Logger LOGGER = Logger.getLogger(CodeUtils.class.getName());

    private CodeUtils() {
    }

    public static String extractClassName(ClassName className) {
        Expression expression = className.getName();
        while (expression instanceof Variable || expression instanceof FieldAccess) {
            VariableBase variableBase;
            if (expression instanceof Variable) {
                variableBase = (Variable)expression;
                expression = ((Variable)variableBase).getName();
                continue;
            }
            if (!(expression instanceof FieldAccess)) continue;
            variableBase = (FieldAccess)expression;
            expression = ((FieldAccess)variableBase).getField().getName();
        }
        return expression instanceof Identifier ? ((Identifier)expression).getName() : "";
    }

    public static String extractClassName(ClassDeclaration classDeclaration) {
        return classDeclaration.getName().getName();
    }

    public static String extractSuperClassName(ClassDeclaration classDeclaration) {
        Identifier identifier = classDeclaration.getSuperClass();
        return identifier != null ? identifier.getName() : null;
    }

    @CheckForNull
    public static String extractVariableName(Variable variable) {
        Expression expression;
        if (variable instanceof ReflectionVariable) {
            expression = ((ReflectionVariable)variable).getName();
            if (expression instanceof Scalar) {
                Scalar scalar = (Scalar)expression;
                return scalar.getStringValue();
            }
            if (expression instanceof Variable) {
                variable = (Variable)expression;
                return CodeUtils.extractVariableName(variable);
            }
            if (expression instanceof FieldAccess) {
                variable = ((FieldAccess)expression).getField();
                return CodeUtils.extractVariableName(variable);
            }
            if (expression instanceof InfixExpression) {
                return null;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cannot extract variable name of ReflectionVariable: " + expression.getClass().toString());
            }
        }
        if (variable.getName() instanceof Identifier) {
            expression = (Identifier)variable.getName();
            StringBuilder stringBuilder = new StringBuilder();
            if (variable.isDollared()) {
                stringBuilder.append("$");
            }
            stringBuilder.append(((Identifier)expression).getName());
            return stringBuilder.toString();
        }
        if (variable.getName() instanceof Variable) {
            expression = (Variable)variable.getName();
            return CodeUtils.extractVariableName((Variable)expression);
        }
        if (variable.getName() instanceof MethodInvocation) {
            return null;
        }
        LOGGER.fine("Cannot extract variable name of type: " + variable.getName().getClass().toString());
        return null;
    }

    public static boolean isVariableTypeResolved(IndexedConstant indexedConstant) {
        return indexedConstant.getTypeName() == null || !indexedConstant.getTypeName().startsWith("@");
    }

    private static String findClassNameEnclosingDeclaration(PHPParseResult pHPParseResult, IndexedConstant indexedConstant) {
        if (pHPParseResult.getSnapshot().getSource().getFileObject().equals(indexedConstant.getFileObject())) {
            return CodeUtils.findClassNameEnclosingDeclaration(pHPParseResult.getProgram(), indexedConstant);
        }
        ClassNameExtractor classNameExtractor = new ClassNameExtractor(indexedConstant);
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)indexedConstant.getFileObject())), (UserTask)classNameExtractor);
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return classNameExtractor.className;
    }

    private static String findClassNameEnclosingDeclaration(Program program, IndexedConstant indexedConstant) {
        ASTNode aSTNode = Utils.getNodeAtOffset(program, indexedConstant.getOffset(), ClassDeclaration.class);
        if (aSTNode instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration = (ClassDeclaration)aSTNode;
            return classDeclaration.getName().getName();
        }
        return null;
    }

    public static void resolveFunctionType(PHPParseResult pHPParseResult, PHPIndex pHPIndex, Map<String, IndexedConstant> map, IndexedConstant indexedConstant) {
        String string = indexedConstant.getTypeName();
        if (!CodeUtils.isVariableTypeResolved(indexedConstant)) {
            String string2 = null;
            boolean bl = true;
            if (string.startsWith(FUNCTION_TYPE_PREFIX)) {
                String string3 = string.substring(FUNCTION_TYPE_PREFIX.length());
                for (IndexedFunction indexedFunction : pHPIndex.getFunctions(pHPParseResult, string3, QuerySupport.Kind.EXACT)) {
                    string2 = indexedFunction.getReturnType();
                }
            } else if (string.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                String[] stringArray = string.substring(STATIC_METHOD_TYPE_PREFIX.length()).split("\\.");
                String string4 = stringArray[0];
                if ("self".equals(string4) || "parent".equals(string4)) {
                    string4 = CodeUtils.findClassNameEnclosingDeclaration(pHPParseResult, indexedConstant);
                }
                String string5 = stringArray[1];
                for (IndexedFunction indexedFunction : pHPIndex.getAllMethods(pHPParseResult, string4, string5, QuerySupport.Kind.EXACT, Integer.MAX_VALUE)) {
                    string2 = indexedFunction.getReturnType();
                }
            } else if (string.startsWith(METHOD_TYPE_PREFIX)) {
                String[] stringArray = string.substring(METHOD_TYPE_PREFIX.length()).split("\\.");
                String string6 = stringArray[0];
                String string7 = stringArray[1];
                String string8 = null;
                if ("$this".equals(string6)) {
                    string8 = CodeUtils.findClassNameEnclosingDeclaration(pHPParseResult, indexedConstant);
                } else {
                    IndexedConstant indexedConstant2 = map.get(string6);
                    if (indexedConstant2 != null && indexedConstant2 != indexedConstant) {
                        CodeUtils.resolveFunctionType(pHPParseResult, pHPIndex, map, indexedConstant2);
                        string8 = indexedConstant2.getTypeName();
                    }
                }
                if (string8 != null) {
                    for (IndexedFunction indexedFunction : pHPIndex.getAllMethods(pHPParseResult, string8, string7, QuerySupport.Kind.EXACT, Integer.MAX_VALUE)) {
                        string2 = indexedFunction.getReturnType();
                    }
                }
            } else {
                bl = false;
            }
            if (bl) {
                indexedConstant.setTypeName(string2);
            }
        }
    }

    public static String extractVariableType(Assignment assignment) {
        Expression expression;
        Expression expression2 = assignment.getRightHandSide();
        if (expression2 instanceof Assignment) {
            return CodeUtils.extractVariableType((Assignment)assignment.getRightHandSide());
        }
        if (expression2 instanceof Reference) {
            expression = (Reference)expression2;
            expression2 = ((Reference)expression).getExpression();
        }
        if (expression2 instanceof ClassInstanceCreation) {
            expression = (ClassInstanceCreation)expression2;
            Expression expression3 = ((ClassInstanceCreation)expression).getClassName().getName();
            if (expression3 instanceof Identifier) {
                Identifier identifier = (Identifier)expression3;
                return identifier.getName();
            }
        } else {
            if (expression2 instanceof ArrayCreation) {
                return "array";
            }
            if (expression2 instanceof FunctionInvocation) {
                expression = (FunctionInvocation)expression2;
                String string = CodeUtils.extractFunctionName((FunctionInvocation)expression);
                return FUNCTION_TYPE_PREFIX + string;
            }
            if (expression2 instanceof StaticMethodInvocation) {
                expression = (StaticMethodInvocation)expression2;
                String string = ((StaticDispatch)expression).getClassName().getName();
                String string2 = CodeUtils.extractFunctionName(((StaticMethodInvocation)expression).getMethod());
                if (string != null && string2 != null) {
                    return STATIC_METHOD_TYPE_PREFIX + string + '.' + string2;
                }
            } else if (expression2 instanceof MethodInvocation) {
                Object object;
                expression = (MethodInvocation)expression2;
                String string = null;
                if (((Dispatch)expression).getDispatcher() instanceof Variable) {
                    object = (Variable)((Dispatch)expression).getDispatcher();
                    string = CodeUtils.extractVariableName((Variable)object);
                }
                object = CodeUtils.extractFunctionName(((MethodInvocation)expression).getMethod());
                if (string != null && object != null) {
                    return METHOD_TYPE_PREFIX + string + '.' + (String)object;
                }
            }
        }
        return null;
    }

    public static String extractFunctionName(FunctionInvocation functionInvocation) {
        return CodeUtils.extractFunctionName(functionInvocation.getFunctionName());
    }

    public static String extractFunctionName(FunctionDeclaration functionDeclaration) {
        return functionDeclaration.getFunctionName().getName();
    }

    public static String extractMethodName(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getFunction().getFunctionName().getName();
    }

    public static String extractFunctionName(FunctionName functionName) {
        if (functionName.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)functionName.getName();
            return identifier.getName();
        }
        if (functionName.getName() instanceof Variable) {
            Variable variable = (Variable)functionName.getName();
            return CodeUtils.extractVariableName(variable);
        }
        return null;
    }

    @CheckForNull
    public static String getParamDefaultValue(FormalParameter formalParameter) {
        Expression expression = formalParameter.getDefaultValue();
        if (expression instanceof Scalar) {
            Scalar scalar = (Scalar)expression;
            return scalar.getStringValue();
        }
        return expression == null ? null : "";
    }

    public static String getParamDisplayName(FormalParameter formalParameter) {
        Expression expression = formalParameter.getParameterName();
        StringBuilder stringBuilder = new StringBuilder();
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            Identifier identifier = (Identifier)variable.getName();
            if (variable.isDollared()) {
                stringBuilder.append("$");
            }
            stringBuilder.append(identifier.getName());
        } else if (expression instanceof Reference) {
            stringBuilder.append("&");
            Reference reference = (Reference)expression;
            if (reference.getExpression() instanceof Variable) {
                Variable variable = (Variable)reference.getExpression();
                if (variable.isDollared()) {
                    stringBuilder.append("$");
                }
                Identifier identifier = (Identifier)variable.getName();
                stringBuilder.append(identifier.getName());
            }
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private static class ClassNameExtractor
    extends UserTask {
        IndexedConstant variable;
        String className;

        public ClassNameExtractor(IndexedConstant indexedConstant) {
            this.variable = indexedConstant;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
            Program program = Utils.getRoot(parserResult);
            this.className = CodeUtils.findClassNameEnclosingDeclaration(program, this.variable);
        }
    }
}

