/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.PersistentClassIndex;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndexManager {
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private static boolean invalid;
    private Language language;
    private static Map<Language, ClassIndexManager> instanceMap;
    private static final Set<URL> allBootRoots;
    private final Set<URL> bootRoots = new HashSet<URL>();
    private Set<ClassIndexImpl> bootIndices;

    private ClassIndexManager(Language language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T writeLock(ExceptionAction<T> exceptionAction) throws IOException {
        lock.writeLock().lock();
        try {
            T t = exceptionAction.run();
            return t;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readLock(ExceptionAction<T> exceptionAction) throws IOException {
        lock.readLock().lock();
        try {
            T t = exceptionAction.run();
            return t;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static boolean holdsWriteLock() {
        return lock.isWriteLockedByCurrentThread();
    }

    public synchronized ClassIndexImpl getUsagesQuery(URL uRL) throws IOException {
        assert (uRL != null);
        if (invalid) {
            return null;
        }
        return this.instances.get(uRL);
    }

    public synchronized ClassIndexImpl createUsagesQuery(URL uRL, boolean bl) throws IOException {
        assert (uRL != null);
        if (invalid) {
            return null;
        }
        ClassIndexImpl classIndexImpl = this.instances.get(uRL);
        if (classIndexImpl == null) {
            classIndexImpl = PersistentClassIndex.create(this.language, uRL, Index.getDataFolder(this.language, uRL), bl);
            this.instances.put(uRL, classIndexImpl);
        }
        return classIndexImpl;
    }

    synchronized void removeRoot(URL uRL) throws IOException {
        if (this.bootRoots.contains(uRL)) {
            return;
        }
        ClassIndexImpl classIndexImpl = this.instances.remove(uRL);
        if (classIndexImpl != null) {
            classIndexImpl.close();
        }
    }

    public synchronized void close() {
        invalid = true;
        for (ClassIndexImpl classIndexImpl : this.instances.values()) {
            try {
                classIndexImpl.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static synchronized ClassIndexManager get(Language language) {
        ClassIndexManager classIndexManager = instanceMap.get(language);
        if (classIndexManager == null) {
            classIndexManager = new ClassIndexManager(language);
            instanceMap.put(language, classIndexManager);
        }
        return classIndexManager;
    }

    public synchronized Map<URL, ClassIndexImpl> getAllIndices() {
        if (invalid) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.instances);
    }

    public static boolean isBootRoot(URL uRL) {
        return allBootRoots.contains(uRL);
    }

    public void addBootRoot(URL uRL) {
        this.bootRoots.add(uRL);
        allBootRoots.add(uRL);
    }

    public void setBootRoots(List<URL> list) {
        if (this.bootRoots.size() > 0) {
            allBootRoots.removeAll(this.bootRoots);
            this.bootRoots.clear();
        }
        for (URL uRL : LanguageRegistry.getInstance().getLibraryUrls()) {
            this.bootRoots.add(uRL);
            allBootRoots.add(uRL);
        }
        for (URL uRL : list) {
            this.bootRoots.add(uRL);
            allBootRoots.add(uRL);
        }
        this.bootIndices = null;
    }

    public Set<URL> getBootRoots() {
        return this.bootRoots;
    }

    public static Set<URL> getAllBootRoots() {
        return allBootRoots;
    }

    public Set<ClassIndexImpl> getBootIndices() {
        if (this.bootIndices == null) {
            this.bootIndices = new HashSet<ClassIndexImpl>();
            Set<URL> set = this.getBootRoots();
            for (URL uRL : set) {
                try {
                    ClassIndexImpl classIndexImpl = this.getUsagesQuery(uRL);
                    if (classIndexImpl != null) {
                        this.bootIndices.add(classIndexImpl);
                        continue;
                    }
                    classIndexImpl = this.createUsagesQuery(uRL, false);
                    this.bootIndices.add(classIndexImpl);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.bootIndices;
    }

    static {
        instanceMap = new HashMap<Language, ClassIndexManager>();
        allBootRoots = new HashSet<URL>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionAction<T> {
        public T run() throws IOException;
    }
}

