/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class GsfCompletionItem
implements CompletionItem {
    private static CompletionFormatter FORMATTER = new CompletionFormatter();
    static CompletionProposal tipProposal;
    protected CompilationInfo info;
    protected CodeCompletionResult completionResult;
    protected static int SMART_TYPE;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    protected int substitutionOffset;

    public static final GsfCompletionItem createItem(CompletionProposal completionProposal, CodeCompletionResult codeCompletionResult, CompilationInfo compilationInfo) {
        return new DelegatedItem(compilationInfo, codeCompletionResult, completionProposal);
    }

    public static final GsfCompletionItem createTruncationItem() {
        return new TruncationItem();
    }

    private GsfCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (this.getInsertPrefix().length() == 0) {
                return;
            }
            Completion.get().hideAll();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            switch (keyEvent.getKeyChar()) {
                case '\n': 
                case '(': 
                case ',': 
                case '.': 
                case ';': {
                    Completion.get().hideAll();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected abstract ImageIcon getIcon();

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected void substituteText(JTextComponent jTextComponent, final int n, final int n2, String string) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final String string2 = ((Object)this.getInsertPrefix()).toString();
        if (string2 != null) {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n3 = -2;
                        String string = baseDocument.getText(n, n2);
                        if (string2.equals(string)) {
                            if (n3 > -1) {
                                baseDocument.insertString(n3, ";", null);
                            }
                            return;
                        }
                        Position position = baseDocument.createPosition(n);
                        Position position2 = n3 > -1 ? baseDocument.createPosition(n3) : null;
                        baseDocument.remove(n, n2);
                        baseDocument.insertString(position.getOffset(), string2, null);
                        if (position2 != null) {
                            baseDocument.insertString(position2.getOffset(), ";", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private static String truncateRhs(String string, int n) {
        if (string != null) {
            int n2 = 80 - n;
            if (n2 < 10) {
                n2 = 10;
            }
            if (string != null && string.length() > n2) {
                string = string.substring(0, n2 - 3) + "<b>&gt;</b>";
            }
        }
        return string;
    }

    static {
        SMART_TYPE = 1000;
    }

    private static class CompletionFormatter
    extends GsfHtmlFormatter {
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static final String END_COLOR = "</font>";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private static final String KEYWORD_COLOR = "<font color=#000099>";
        private static final String FIELD_COLOR = "<font color=#008618>";
        private static final String VARIABLE_COLOR = "<font color=#00007c>";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String INTERFACE_COLOR = "<font color=#404040>";
        private static final String PARAMETERS_COLOR = "<font color=#808080>";
        private static final String ACTIVE_PARAMETER_COLOR = "<font color=#000000>";

        private CompletionFormatter() {
        }

        public void parameters(boolean bl) {
            assert (bl != this.isParameter);
            this.isParameter = bl;
            if (this.isParameter) {
                this.sb.append(PARAMETER_NAME_COLOR);
            } else {
                this.sb.append("</font>");
            }
        }

        public void active(boolean bl) {
            if (bl) {
                this.sb.append("<font color=#000000>");
                this.sb.append(GsfCompletionItem.BOLD);
            } else {
                this.sb.append(GsfCompletionItem.BOLD_END);
                this.sb.append("</font>");
            }
        }

        public void name(ElementKind elementKind, boolean bl) {
            assert (bl != this.isName);
            this.isName = bl;
            if (this.isName) {
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        this.sb.append(CONSTRUCTOR_COLOR);
                        break;
                    }
                    case CALL: {
                        this.sb.append("<font color=#808080>");
                        break;
                    }
                    case DB: 
                    case METHOD: {
                        this.sb.append("<font color=#000000>");
                        break;
                    }
                    case CLASS: {
                        this.sb.append(CLASS_COLOR);
                        break;
                    }
                    case FIELD: {
                        this.sb.append(FIELD_COLOR);
                        break;
                    }
                    case MODULE: {
                        this.sb.append("<font color=#808080>");
                        break;
                    }
                    case KEYWORD: {
                        this.sb.append(KEYWORD_COLOR);
                        this.sb.append(GsfCompletionItem.BOLD);
                        break;
                    }
                    case VARIABLE: {
                        this.sb.append(VARIABLE_COLOR);
                        this.sb.append(GsfCompletionItem.BOLD);
                        break;
                    }
                    default: {
                        this.sb.append("<font>");
                        break;
                    }
                }
            } else {
                switch (elementKind) {
                    case VARIABLE: 
                    case KEYWORD: {
                        this.sb.append(GsfCompletionItem.BOLD_END);
                    }
                }
                this.sb.append("</font>");
            }
        }
    }

    private static class TruncationItem
    extends GsfCompletionItem
    implements CompletionTask,
    CompletionDocumentation {
        private TruncationItem() {
            super(0);
        }

        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsfret/editor/completion/warning.png", (boolean)false);
        }

        public int getSortPriority() {
            return -20000;
        }

        public CharSequence getSortText() {
            return "";
        }

        public CharSequence getInsertPrefix() {
            return "";
        }

        protected String getLeftHtmlText() {
            return GsfCompletionItem.BOLD + NbBundle.getMessage(GsfCompletionItem.class, (String)"ListTruncated") + GsfCompletionItem.BOLD_END;
        }

        public CompletionTask createDocumentationTask() {
            return this;
        }

        public void query(CompletionResultSet completionResultSet) {
            completionResultSet.setDocumentation((CompletionDocumentation)this);
            completionResultSet.finish();
        }

        public void refresh(CompletionResultSet completionResultSet) {
            completionResultSet.setDocumentation((CompletionDocumentation)this);
            completionResultSet.finish();
        }

        public void cancel() {
        }

        public String getText() {
            return NbBundle.getMessage(GsfCompletionItem.class, (String)"TruncatedHelpHtml");
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class DelegatedItem
    extends GsfCompletionItem {
        private CompletionProposal item;

        private DelegatedItem(CompilationInfo compilationInfo, CodeCompletionResult codeCompletionResult, CompletionProposal completionProposal) {
            super(completionProposal.getAnchorOffset());
            this.item = completionProposal;
            this.completionResult = codeCompletionResult;
            this.info = compilationInfo;
        }

        public int getSortPriority() {
            if (this.item.getSortPrioOverride() != 0) {
                return this.item.getSortPrioOverride();
            }
            switch (this.item.getKind()) {
                case ERROR: {
                    return -5000;
                }
                case DB: {
                    return this.item.isSmart() ? 155 - SMART_TYPE : 155;
                }
                case PARAMETER: {
                    return this.item.isSmart() ? 105 - SMART_TYPE : 105;
                }
                case CALL: {
                    return this.item.isSmart() ? 110 - SMART_TYPE : 110;
                }
                case CONSTRUCTOR: {
                    return this.item.isSmart() ? 400 - SMART_TYPE : 400;
                }
                case PACKAGE: 
                case MODULE: {
                    return this.item.isSmart() ? 900 - SMART_TYPE : 900;
                }
                case CLASS: {
                    return this.item.isSmart() ? 800 - SMART_TYPE : 800;
                }
                case ATTRIBUTE: 
                case RULE: {
                    return this.item.isSmart() ? 482 - SMART_TYPE : 482;
                }
                case TAG: {
                    return this.item.isSmart() ? 480 - SMART_TYPE : 480;
                }
                case TEST: 
                case PROPERTY: 
                case METHOD: {
                    return this.item.isSmart() ? 500 - SMART_TYPE : 500;
                }
                case FIELD: {
                    return this.item.isSmart() ? 300 - SMART_TYPE : 300;
                }
                case CONSTANT: 
                case GLOBAL: 
                case VARIABLE: {
                    return this.item.isSmart() ? 200 - SMART_TYPE : 200;
                }
                case KEYWORD: {
                    return this.item.isSmart() ? 600 - SMART_TYPE : 600;
                }
            }
            return this.item.isSmart() ? 999 - SMART_TYPE : 999;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            ElementKind elementKind = this.item.getKind();
            if (elementKind == ElementKind.PARAMETER || elementKind == ElementKind.CLASS || elementKind == ElementKind.MODULE) {
                return false;
            }
            if (this.getInsertPrefix().length() == 0) {
                return false;
            }
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getSelectionEnd();
                    if (n > this.substitutionOffset) {
                        String string = jTextComponent.getDocument().getText(this.substitutionOffset, n - this.substitutionOffset);
                        if (!((Object)this.getInsertPrefix()).toString().startsWith(string)) {
                            return false;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.defaultAction(jTextComponent);
            return true;
        }

        public CharSequence getSortText() {
            return this.item.getSortText();
        }

        public CharSequence getInsertPrefix() {
            return this.item.getInsertPrefix();
        }

        protected String getLeftHtmlText() {
            FORMATTER.reset();
            return this.item.getLhsHtml((HtmlFormatter)FORMATTER);
        }

        public String toString() {
            return this.item.getName();
        }

        protected String getRightHtmlText() {
            FORMATTER.reset();
            String string = this.item.getRhsHtml((HtmlFormatter)FORMATTER);
            FORMATTER.reset();
            String string2 = this.item.getLhsHtml((HtmlFormatter)FORMATTER);
            boolean bl = false;
            int n = 0;
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (bl) {
                    if (c != '>') continue;
                    bl = false;
                    continue;
                }
                if (c == '<') {
                    bl = true;
                    continue;
                }
                ++n;
            }
            return GsfCompletionItem.truncateRhs(string, n);
        }

        public CompletionTask createDocumentationTask() {
            ElementHandle elementHandle = this.item.getElement();
            if (elementHandle != null) {
                return GsfCompletionProvider.createDocTask(elementHandle, this.info);
            }
            return null;
        }

        protected ImageIcon getIcon() {
            ImageIcon imageIcon = this.item.getIcon();
            if (imageIcon != null) {
                return imageIcon;
            }
            ImageIcon imageIcon2 = Icons.getElementIcon(this.item.getKind(), this.item.getModifiers());
            return imageIcon2;
        }

        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            if (this.completionResult != null) {
                this.completionResult.beforeInsert(this.item);
                if (!this.completionResult.insert(this.item)) {
                    this.defaultSubstituteText(jTextComponent, n, n2, string);
                }
                this.completionResult.afterInsert(this.item);
            } else {
                this.defaultSubstituteText(jTextComponent, n, n2, string);
            }
        }

        private void defaultSubstituteText(final JTextComponent jTextComponent, final int n, final int n2, String string) {
            String string2 = this.item.getCustomInsertTemplate();
            if (string2 != null) {
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)baseDocument);
                if (codeTemplateManager != null) {
                    baseDocument.runAtomic(new Runnable(){

                        public void run() {
                            try {
                                baseDocument.remove(n, n2);
                                jTextComponent.getCaret().setDot(n);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                    codeTemplateManager.createTemporary(string2).insert(jTextComponent);
                    Completion.get().showToolTip();
                }
                return;
            }
            super.substituteText(jTextComponent, n, n2, string);
        }

        public void defaultAction(JTextComponent jTextComponent) {
            if (this.getInsertPrefix().length() == 0) {
                this.completionResult.beforeInsert(this.item);
                this.completionResult.insert(this.item);
                this.completionResult.afterInsert(this.item);
                return;
            }
            super.defaultAction(jTextComponent);
        }
    }
}

